/* 
 *   Creation Date: <2000/02/06 23:55:05 samuel>
 *   Time-stamp: <2001/01/06 23:30:59 samuel>
 *   
 *	<osi_driver.h>
 *	
 *	
 *   
 *   Copyright (C) 2000, 2001 Samuel Rydh (samuel@ibrium.se)
 *   
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation
 *   
 */

#ifndef _H_OSI_DRIVER
#define _H_OSI_DRIVER

#ifndef _H_PCI
#include "pci.h"
#endif

extern void osi_driver_services_init( void );
extern void osi_driver_services_cleanup( void );

extern struct osi_driver *register_osi_driver( char *drv_name, char *pnode_name, 
					       pci_dev_info_t *pci_config );
struct osi_driver *register_osi_driver_norom( char *drv_name, char *pnode_name, 
					       pci_dev_info_t *pci_config );

extern void 	free_osi_driver( struct osi_driver *dr );
extern int 	get_driver_pcislot( struct osi_driver *dr, int *r_bus, int *r_devfn );

struct osi_driver *get_osi_driver_from_id( ulong osi_id );

/* Use these functions in order to support shared IRQs */
extern void 	osi_irq_hi( struct osi_driver *d );
extern void 	osi_irq_low( struct osi_driver *d );


#endif   /* _H_OSI_DRIVER */

