/* 
 *   Creation Date: <2001/06/16 21:30:18 samuel>
 *   Time-stamp: <2001/06/21 13:37:53 samuel>
 *   
 *	<init.S>
 *	
 *	Asm glue for ELF images run inside MOL
 *   
 *   Copyright (C) 2001 Samuel Rydh (samuel@ibrium.se)
 *   
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation
 *   
 */

#include "mol_config.h"
#include "asmdefs.h"
#include "processor.h"
#include "os_interface.h"

	.section .bss
	.balign 32
	.space	1024*256		// 256 K stack
stack:	.space  64


/************************************************************************/
/*	Exception Vectors						*/
/************************************************************************/

	.text
	.org 0x100
1:	nop
	b	1b
	
	.org 0x200
1:	nop
	b	1b
	
	.org 0x300
1:	nop
	b	1b

	.org 0x400
1:	nop
	b	1b

	.org 0x500
1:	nop
	b	1b

	.org 0x600
1:	nop
	b	1b
		
	.org 0x700
1:	nop
	b	1b
	
	.org 0x800
	mtsprg0	r3
	mfsrr1	r3
	ori	r3,r3,0x2000
	mtsrr1	r3
	mfsprg0	r3
	rfi

	.org 0x900
1:	nop
	b	1b


/************************************************************************/
/*	Entrypoint, Asm globals						*/
/************************************************************************/

	.org 0x1400
GLOBL(_start):
	LOADI	r1,stack

	bl	entry

	li	r3,OSI_EXIT
	b	osi_call
	
GLOBL(osi_call):
	mr	r5,r3
	mr	r6,r4
	mr	r7,r5
	mr	r8,r6
	mr	r9,r7
	LOADI	r3,OSI_SC_MAGIC_R3
	LOADI	r4,OSI_SC_MAGIC_R4
	sc
	blr

