/* 
 *   Creation Date: <1999/10/31 21:19:11 samuel>
 *   Time-stamp: <2001/02/03 19:45:04 samuel>
 *   
 *	<ofglue.S>
 *	
 *	
 *   
 *   Copyright (C) 1999, 2000 Samuel Rydh (samuel@ibrium.se)
 *   
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation
 *   
 */

#include "os_interface.h"
#include "asmdefs.h"
	
	.text

/* This is the OF-client interface. r3 points to the argument array.
 * On return, r3 should contain 0==true or -1==false. r4-r12,cr0,cr1 may
 * be modified freely.
 */	

	.globl of_entry_start
of_entry_start:
	mr	r6,r3
	OSI_CALL( OSI_OF_INTERFACE )
	blr
	.globl of_entry_end
of_entry_end:


	.globl of_trap_start
of_trap_start:
	mtsprg1	r1
	mfsprg0	r1

	stw	r3,0(r1)
	stw	r4,4(r1)
	stw	r5,8(r1)
	stw	r6,12(r1)
	OSI_CALL( OSI_OF_TRAP )
	lwz	r3,0(r1)
	lwz	r4,4(r1)
	lwz	r5,8(r1)
	lwz	r6,12(r1)
	mfsprg1	r1
	rfi
	.globl of_trap_end
of_trap_end:	

	.globl of_rtas_start
of_rtas_start:
	/* r3 = argument buffer, r4 = of_rtas_start */
	/* According to the CHRP standard, cr must be preserved (cr0/cr1 too?) */
	mr	r6,r3
	OSI_CALL( OSI_OF_RTAS )
	blr
	.globl of_rtas_end
of_rtas_end:

