#!/bin/sh

echo
echo "Xalan-J Build"
echo "-------------"

if [ "$JAVA_HOME" = "" ] ; then
  echo "ERROR: JAVA_HOME not found in your environment."
  echo
  echo "Please, set the JAVA_HOME environment variable to match the"
  echo "root directory of the Java Virtual Machine you want to use."
  exit 1
fi

# UNIX
CLPATHSEP=:
# if we're on a Windows box make it ;
uname | grep WIN && CLPATHSEP=\;

# Note: to build samples, you need the servlet.jar in the CLASSPATH
# SERVLET=/jswdk-1.0.1/lib/servlet.jar

# Use our local copy of Ant, since different versions may be incompatible with our build.xml
ANT_HOME=.
ANT=bin/ant.jar
JAVAC=$JAVA_HOME/lib/tools.jar
XERCES=./xerces.jar
BSF=./bsf.jar
BSFENGINES=,.bsfengines.jar
DOCGENERATOR=xdocs/stylebook-1.0-b2.jar
DOCLET=xdocs/xalanjdoc.jar

# Make sure this classpath scheme works. I.e., can javadoc find xalanjdoc.Standard?
LOCALCLASSPATH="$ANT${CLPATHSEP}$JAVAC${CLPATHSEP}$XERCES${CLPATHSEP}$BSF${CLPATHSEP}$BSFENGINES${CLPATHSEP}$DOCGENERATOR${CLPATHSEP}$DOCLET${CLPATHSEP}$CLASSPATH"

echo
echo Building with classpath $LOCALCLASSPATH

echo
echo Starting Ant...

"$JAVA_HOME"/bin/java -Dant.home="$ANT_HOME" -classpath "$LOCALCLASSPATH" org.apache.tools.ant.Main $@
