/* $Id: utils.c,v 1.2 1998/08/02 20:34:50 proff Exp $
 * $Copyright$
 */

#include "libproff.h"

#include "mmalloc.h"

static void Pexit (char *s)
{
	syslog (LOG_ERR, "%s: %m", s);
	perror (s);
	exit (1);
}

#ifndef HAVE_USLEEP
EXPORT void usleep (unsigned long useconds)
{
	struct timeval to;

	to.tv_sec = useconds / 1000000;
	to.tv_usec = useconds % 1000000;
	select (0, (fd_set *) 0, (fd_set *) 0, (fd_set *) 0, &to);
}
#endif

#ifndef HAVE_SETENV
EXPORT int setenv (char *env, char *val, int overwrite)
{
        char *p;
	int en;
	int ret;
	if (getenv(env) && !overwrite)
		return 0;
	p = Smalloc (strlen(env) + 1 + strlen(val) + 1);
	sprintf (p, "%s=%s", env, val);
	ret = putenv (p);
	en = errno;
	free (p);
	errno = en;
	return en;
}
#endif

/* Thanks to Mike Haertel and Jim Avera for this test. */
#include <sys/types.h>
#include <fcntl.h>
#ifdef HAVE_MMAP
#  include <sys/mman.h>
#endif

#ifndef HAVE_GETPAGESIZE
# include <sys/param.h>
# ifdef EXEC_PAGESIZE
#  define pagesize EXEC_PAGESIZE
# else
#  ifdef NBPG
#   define pagesize NBPG * CLSIZE
#   ifndef CLSIZE
#    define CLSIZE 1
#   endif
#  else
#   ifdef NBPC
#    define pagesize NBPC
#   else
#    ifdef PAGE_SIZE
#     define pagesize PAGE_SIZE
#    else
#     define pagesize PAGESIZE /* SVR4 */
#    endif
#   endif
#  endif
# endif
EXPORT int getpagesize ()
{
	return pagesize;
}
#endif


/* we use usleep, because sleep() uses SIGALRM */

EXPORT void *lp_Xmalloc (int n, char *desc)
{
	void *p;
	if (!(p = mmalloc_check (NULL, n, desc)))
		Pexit (desc);
	return p;
}


EXPORT void *lp_Smalloc (int n, char *desc)
{
	void *p;
	int t = 0;
	do
	{
		if (!(p = mmalloc_check (NULL, n, desc)))
			usleep (2000000);
		else
			goto nowarn;
	} while (++t<60);
	Pexit (desc);
nowarn:
	return p;
}

EXPORT void *lp_Scalloc (int n, int n2, char *desc)
{
	void *p;
	int t = 0;
	do
	{
		if (!(p = mcalloc_check (NULL, n, n2, desc)))
			usleep (2000000);
		else
			goto nowarn;
	} while (++t<60);
	Pexit (desc);
nowarn:
	return p;
}

EXPORT void *lp_Srealloc (void *p, int n, char *desc)
{
	int t = 0;
	do
	{
		if (!(p = mrealloc_check (NULL, p, n, desc)))
			usleep (2000000);
		else
			goto nowarn;
	} while (++t<60);
	Pexit (desc);
nowarn:
	return p;
}

EXPORT char *lp_strdup (char *s, char *desc)
{
	int t = strlen (s);
	char *p = mmalloc_check (NULL, t+1, desc);
	if (!p)
		return NULL;
	memcpy (p, s, t+1);
	return p;
}

EXPORT char *lp_Sstrdup (char *s, char *desc)
{
	void *p;
	int t = 0;
	do
	{
		if (!(p = lp_strdup (s, desc)))
			usleep (2000000);
		else
			goto nowarn;
	} while (++t<60);
	Pexit (desc);
nowarn:
	return p;
}

EXPORT char *lp_Xstrdup (char *s, char *desc)
{
    return strcpy (lp_Xmalloc (strlen (s) + 1, desc), s);
}

EXPORT char *conv (double n)
{
	int v;
	static char buf[128];
	
	for (v=0; n>1024.0; v++)
	    n /= 1024.0;
	sprintf (buf, v? "%.2f%c": "%.0f", n, " kMGT"[v]);
	return buf;
}

static struct cv
{
	struct cv *next;
	char *data;
}*cv_head;

EXPORT char *convMalloc (double n)
{
	static struct cv *last;
	if (last)
	{
		last->next = Smalloc (sizeof *last);
		last = last->next;
	} else
		last = Smalloc (sizeof *last);
	last->next = NULL;
	return (last->data = Sstrdup (conv (n)));
}

EXPORT void convFree ()
{
	static struct cv *cv;
	for (cv = cv_head; cv; cv = cv->next)
		free (cv->data);
}
