/* Output from p2c 1.21alpha-07.Dec.93, the Pascal-to-C translator */
/* From input file "status.pas" */


#include "cfuncs.h"


#define STATUS_G
#include "status.h"


#ifndef GLOBALS_H
#include "globals.h"
#endif

#ifndef STRINGS_H

#endif

#ifndef MTXLINE_H
#include "mtxline.h"
#endif


#define uppers          "QWERTYUIOPASDFGHJKLZXCVBNM"


typedef struct line_status {
  short pitch, chord_pitch, octave_adjust, after_beam, last_under_slur,
	last_under_beam, slur_level, after_slur;
  char octave, lastnote, chord_lastnote, duration;
  char slur_toggle[2];
  boolean beamnext, beamed, slurnext, slurred, no_beam_melisma;
  boolean no_slur_melisma[2];
  char delay_slur[256];
} line_status;


static line_status current[maxvoices];


void addDuration(char *note, char *dur)
{
  short i, l;

  l = strlen(note);
  for (i = 1; i <= l - 1; i++) {
    if (pos1(note[i], durations) > 0) {
      *dur = note[i];
      return;
    }
    if (pos1(note[i], terminators) > 0) {
      insertchar(*dur, note, 2);
      return;
    }
  }
  insertchar(*dur, note, 2);
}


char duration(short voice)
{
  return (current[voice-1].duration);
}


void SetDuration(char *note, short voice)
{
  addDuration(note, &current[voice-1].duration);
}


void activateBeamsAndSlurs(short voice)
{
  line_status *WITH;

  WITH = &current[voice-1];
  if (WITH->beamnext) {
    WITH->beamed = true;
    WITH->beamnext = false;
  }
  if (WITH->beamed)
    WITH->after_beam++;
  if (WITH->slurnext) {
    WITH->slurred = true;
    WITH->slurnext = false;
  }
  if (WITH->slurred)
    WITH->after_slur++;
}


void saveStatus(short voice)
{
  line_status *WITH;

  WITH = &current[voice-1];
  WITH->chord_pitch = WITH->pitch;
  WITH->chord_lastnote = WITH->lastnote;
}


void appendSlur(short voice, char *note)
{
  line_status *WITH;

  if (newslurs)
    return;
  WITH = &current[voice-1];
  if (*WITH->delay_slur == '\0')
    return;
  if (endsWith(WITH->delay_slur, "s~") || endsWith(WITH->delay_slur, "t~"))
    shorten(WITH->delay_slur, strlen(WITH->delay_slur) - 2);
  if (startsWith(WITH->delay_slur, "s~") || startsWith(WITH->delay_slur, "t~"))
    predelete(WITH->delay_slur, 2);
  sprintf(note + strlen(note), " %s", WITH->delay_slur);
  *WITH->delay_slur = '\0';
}


short afterBeam(short voice)
{
  return (current[voice-1].after_beam);
}


short delaySlur(short voice)
{
  return (wordCount(current[voice-1].delay_slur));
}


short slurLevel(short voice)
{
  return (current[voice-1].slur_level);
}


void renewSlurLevel(short voice, short dir)
{
  current[voice-1].slur_level += dir;
}


boolean noBeamMelisma(short voice)
{
  return (current[voice-1].no_beam_melisma);
}


boolean noSlurMelisma(short voice, short history)
{
  line_status *WITH;

  WITH = &current[voice-1];
  return (WITH->no_slur_melisma[WITH->slur_level + history - 1]);
}


void clearBeamSlurEnd(short voice)
{
  line_status *WITH;

  WITH = &current[voice-1];
  WITH->last_under_beam = 0;
  WITH->last_under_slur = 0;
}


short lastUnderBeam(short voice)
{
  return (current[voice-1].last_under_beam);
}


void incLastUnderBeam(short voice)
{
  current[voice-1].last_under_beam++;
}


short lastUnderSlur(short voice)
{
  return (current[voice-1].last_under_slur);
}


short afterSlur(short voice)
{
  line_status *WITH;

  WITH = &current[voice-1];
  return (WITH->after_slur);
}


void incLastUnderSlur(short voice)
{
  current[voice-1].last_under_slur++;
}


char octave(short voice)
{
  return (current[voice-1].octave);
}


void resetOctave(short voice)
{
  current[voice-1].octave = ' ';
}


void setOctave(short voice)
{
  current[voice-1].octave = initOctave(voiceStave(voice));
}


void newOctave(short voice, char dir)
{
  line_status *WITH;

  WITH = &current[voice-1];
  switch (dir) {

  case '+':
    WITH->octave++;
    break;

  case '-':
    WITH->octave--;
    break;
  }
}


static short newPitch(char *note, short pitch, char lastnote)
{  /* with stat do */
  short i, l, interval, npitch;

  interval = note[0] - lastnote;
  if (interval > 3)
    interval -= 7;
  if (interval < -3)
    interval += 7;
  npitch = pitch + interval;
  l = strlen(note);
  for (i = 0; i <= l - 1; i++) {
    if (note[i] == '+')
      npitch += 7;
    else if (note[i] == '-')
      npitch -= 7;
  }
  return npitch;
}


static void delins(char *note, char c1, char c2, short l)
{
  short i, n;

  n = strlen(note);
  i = pos1(c1, note);
  if (i == 0)
    i = n + 1;
  while (l > 0 && i <= n) {
    delete1(note, i);
    n--;
    l--;
  }
  i = pos1(c2, note);
  if (i == 0)
    i = 2;
  while (l > 0) {
    insertchar(c2, note, i);
    l--;
  }
}


static void repitch(char *note, short diff)
{
  diff /= 7;
  if (diff > 0)
    delins(note, '-', '+', diff);
  else
    delins(note, '+', '-', -diff);
}


void setUnbeamed(short voice)
{
  line_status *WITH;

  WITH = &current[voice-1];
  WITH->beamed = false;
  WITH->after_beam = 0;
}


void setUnslurred(short voice)
{
  line_status *WITH;

  WITH = &current[voice-1];
  WITH->slurred = false;
  WITH->after_slur = 0;
}


void beginBeam(short voice, char *note)
{
  line_status *WITH;

  WITH = &current[voice-1];
  if (WITH->beamed)
    error3(voice, "Starting a forced beam while another is open");
  WITH->beamnext = true;
  WITH->no_beam_melisma = startsWith(note, "[[");
  if (WITH->no_beam_melisma)
    predelete(note, 1);
}


/* The following arrays are not yet used.  Later we will test
   whether labelled slurs are opened and closed properly. */

static boolean slur_open1['9' + 1 - '1'];
static boolean slur_openA['Z' + 1 - 'A'];


static void clearSlurs(void)
{
  char c;

  for (c = '1'; c <= '9'; c++)
    slur_open1[c - '1'] = false;
  for (c = 'A'; c <= 'Z'; c++)
    slur_openA[c - 'A'] = false;
}


/* static variables for beginSlur: */
struct LOC_beginSlur {
  short voice;
  char *note;
} ;

static void selectToggles(struct LOC_beginSlur *LINK)
{
  line_status *WITH;

  WITH = &current[LINK->voice-1];
  switch (WITH->slur_level) {

  case 1:
    if (LINK->note[0] == start_slur)
      WITH->slur_toggle[0] = 's';
    else
      WITH->slur_toggle[0] = 't';
    break;

  case 2:
    if (WITH->slur_toggle[0] == 't')
      WITH->slur_toggle[1] = 's';
    else
      WITH->slur_toggle[1] = 't';
    break;
  }
}


void beginSlur(short voice_, char *note_)
{
  struct LOC_beginSlur V;
  char actualslur;
  char keepnote[256];
  boolean labelled = false;
  line_status *WITH;
  char STR1[36];

  V.voice = voice_;
  V.note = note_;
  strcpy(keepnote, V.note);
  WITH = &current[V.voice-1];
  if (WITH->slur_level > 1)
    error3(V.voice, "More than two levels of nested slurs");
  WITH->slur_level++;
  WITH->no_slur_melisma[WITH->slur_level - 1] = (startsWith(V.note, "((") ||
						 startsWith(V.note, "{{"));
  if (WITH->no_slur_melisma[WITH->slur_level - 1])
    predelete(V.note, 1);
  if (WITH->slur_level == 2)
    WITH->after_slur = 0;
  WITH->slurnext = true;
  if (strlen(V.note) > 1) {
    sprintf(STR1, "%s%s", digits, uppers);
    labelled = (pos1(V.note[1], STR1) > 0);
  }
  if (labelled)
    WITH->slur_toggle[WITH->slur_level - 1] = 's';
  else
    selectToggles(&V);
  actualslur = V.note[0];
  V.note[0] = WITH->slur_toggle[WITH->slur_level - 1];
  /* Maybe delay_slur should not be used with labelled slurs */
  if (*WITH->delay_slur == '\0')
    strcpy(WITH->delay_slur, V.note);
  else {
    if (actualslur != '{' && !labelled) {
      WITH->slur_toggle[0] = 't';
      WITH->slur_toggle[1] = 's';
    }
    V.note[0] = WITH->slur_toggle[1];
    WITH->delay_slur[0] = WITH->slur_toggle[0];
    sprintf(WITH->delay_slur + strlen(WITH->delay_slur), " %s", V.note);
  }
  if (V.note[0] == 't') {
    if (pos1('+', V.note) > 0 || pos1('-', V.note) > 0)
      error3(V.voice, "`t' slurs may not have adjustments");
  }
  if (newslurs)
    strcpy(V.note, keepnote);
  else
    *V.note = '\0';
}


void endSlur(short voice, char *note)
{
  short s2;
  char keepnote[256];
  line_status *WITH;

  strcpy(keepnote, note);
  WITH = &current[voice-1];
  if (WITH->slur_level < 1)
    error3(voice, "Ending a slur that was never started");
  note[0] = WITH->slur_toggle[WITH->slur_level - 1];
  s2 = pos1(start_slur, note);
  if (s2 == 0)
    renewSlurLevel(voice, -1);
  else {
    note[s2-1] = note[0];
    insertchar(blank, note, s2);
  }
  if (WITH->slur_level == 0)
    setUnslurred(voice);
  if (newslurs)
    strcpy(note, keepnote);
}


void renewPitch(short voice, char *note)
{
  short pstat;
  line_status *WITH;

  WITH = &current[voice-1];
  pstat = newPitch(note, WITH->chord_pitch, WITH->chord_lastnote);
  WITH->pitch = newPitch(note, WITH->pitch, WITH->lastnote);
  if (WITH->pitch != pstat)
    repitch(note, WITH->pitch - pstat);
  WITH->lastnote = note[0];
  if (verbose > 2 && WITH->pitch != pstat)
    printf("Pitch from melodic line = %d   from last chordal note = %d\n",
	   WITH->pitch, pstat);
}


void renewChordPitch(short voice, char *note)
{
  line_status *WITH;

  WITH = &current[voice-1];
  WITH->chord_pitch = newPitch(note, WITH->chord_pitch, WITH->chord_lastnote);
  WITH->chord_lastnote = note[0];
}


void initStatus(void)
{
  short voice, FORLIM;
  line_status *WITH;

  FORLIM = nvoices;
  for (voice = 1; voice <= FORLIM; voice++) {
    WITH = &current[voice-1];
    WITH->duration = default_duration;
    WITH->lastnote = 'f';
    WITH->octave_adjust = 0;
    *WITH->delay_slur = '\0';
    WITH->slur_level = 0;
    WITH->beamed = false;
    WITH->beamnext = false;
    WITH->after_beam = 0;
    WITH->slurred = false;
    WITH->slurnext = false;
    WITH->after_slur = 0;
    clearSlurs();
    WITH->octave = initOctave(voiceStave(voice));
    WITH->pitch = (WITH->octave - '0') * 7 - 3;
    saveStatus(voice);
  }
}




/* End. */
