/* Output from p2c 1.21alpha-07.Dec.93, the Pascal-to-C translator */
/* From input file "files.pas" */


#include "cfuncs.h"


#define FILES_G
#include "files.h"


#ifndef STRINGS_H

#endif


#define param_leader    '-'


static char stylefilename[256] = "mtxstyle.txt";

static char buffer[256];
static char infilename[256], outfilename[256];
static short infilecount, teststyle;
static boolean eof_infile;


boolean endOfInfile(void)
{
  return eof_infile;
}


void tex3(char *s)
{
  char STR1[256], STR2[256];

  if (!pmx_preamble_done) {
    putLine(s);
    return;
  }
  if (s[0] == '%') {
    putLine(s);
    return;
  }
  if (first_paragraph) {
    sprintf(STR2, "\\%s\\", s);
    putLine(STR2);
  } else {
    sprintf(STR1, "\\\\%s\\", s);
    putLine(STR1);
  }
}


void putLine(char *line)
{
  if (outlen + strlen(line) >= PMXlinelength)
    putc('\n', outfile);
  fprintf(outfile, "%s\n", line);
  outlen = 0;
}


void put(char *line_, boolean putspace_)
{
  char line[256];
  short l;
  char STR1[256];

  strcpy(line, line_);
  l = strlen(line);
  if (l > PMXlinelength)
    error("Item longer than PMX line length", print);
  if (outlen + l >= PMXlinelength) {
    putLine("");
    put(line, false);
    return;
  }
  if (putspace_ && outlen > 0 && line[0] != ' ')
    sprintf(line, " %s", strcpy(STR1, line));
  fputs(line, outfile);
  outlen += l;
}


void showOptions(void)
{
  printf("  Options selected:\n");
  if (!dochords)
    printf("Ignore chord lines (c)\n");
  if (tonic_solfa)
    printf("Note names in tonic sol-fa (f)\n");
  if (ignore)
    printf("Ignore errors (i)\n");
  if (!dolyrics)
    printf("Music only, no lyrics (m)\n");
  if (set_names)
    printf("Set instrument names (n)\n");
  if (private_pmx)
    printf("Use private PMX features (p)\n");
  if (newslurs)
    printf("Use () slurs in PMX file (s)\n");
  if (!dotext)
    printf("Ignore uptext lines (t)\n");
  if (no_uptext_for_rests)
    printf("Uptext on notes only (u)\n");
  if (verbose == 1)
    printf("Verbose progress report (v)\n");
  else if (verbose == 2)
    printf("Debugging printouts (D)\n");
  if (pedantic)
    printf("Suppress pedantic warnings (w)\n");
  if (extended_dots)
    printf("Extended dot positioning syntax (x)\n");
  if (choice != ' ')
    printf("Chosen case = %c\n", choice);
}


boolean styleFileFound(void)
{
  return (teststyle != 0);
}


void processOption(char j)
{
  switch (j) {

  case 'b':
    unbeam_if_vocal = false;
    break;

  case 'c':
    dochords = false;
    break;

  case 'd':
    warning("-d option ignored, not supported past M-Tx 0.30", !print);
    break;

  case 'f':
    tonic_solfa = true;
    break;

  case 'i':
    ignore = true;
    break;

  case 'l':
    warning("-l option ignored, not supported past M-Tx 0.30", !print);
    break;

  case 'm':
    dolyrics = false;
    break;

  case 'n':
    set_names = true;
    break;

  case 'p':
    private_pmx = true;
    break;

  case 's':
    newslurs = true;
    break;

  case 't':
    dotext = false;
    break;

  case 'u':
    no_uptext_for_rests = true;
    break;

  case 'v':
    verbose = 1;
    break;

  case 'w':
    pedantic = false;
    break;

  case 'x':
    extended_dots = true;
    break;

  case 'D':
    verbose = 2;
    break;

  default:
    if (isdigit(j))
      choice = j;
    else {
      putchar(j);
      error(": invalid option", !print);
    }
    break;
  }
}


/* static variables for OpenFiles: */
struct LOC_OpenFiles {
  short testin;
  char basename[256];
} ;

static void checkExistingFile(struct LOC_OpenFiles *LINK)
{
  FILE *tryfile;
  char tryfile_NAME[_FNSIZE];

  strcpy(tryfile_NAME, LINK->basename);
  tryfile = fopen(tryfile_NAME, "r+b");
  _SETIO(tryfile != NULL, FileNotFound);
  LINK->testin = P_ioresult;
  if (LINK->testin != 0)
    return;
  if (tryfile != NULL)
    fclose(tryfile);
  printf("There exists a file named %s.  I am treating this\n",
	 LINK->basename);
  error("  as a fatal error unless you specify -i", !print);
}


void OpenFiles(void)
{
  struct LOC_OpenFiles V;
  short i, j, l;
  short fileid = 0;
  char param[256], ext[256];
  short FORLIM1;
  char STR2[256];

  infilecount = 0;
  line_no = 0;
  paragraph_no = 0;
  for (i = 1; i <= P_argc - 1; i++) {
    strcpy(param, P_argv[i]);
    if (param[0] == param_leader) {
      FORLIM1 = strlen(param);
      for (j = 1; j <= FORLIM1 - 1; j++)
	processOption(param[j]);
    } else if (fileid == 0)
      fileid = i;
    else if (*texdir == '\0')
      strcpy(texdir, param);
    else
      strcpy(stylefilename, param);
  }
  if (fileid == 0)
    fatalerror("You must supply a basename on the command line");
  else
    strcpy(V.basename, P_argv[fileid]);
  l = strlen(V.basename);
  if (l > 4 && V.basename[l-4] == '.') {
    substr_(ext, V.basename, l - 2, 3);
    toUpper(ext);
    if (!strcmp(ext, "MTX")) {
      warning(".mtx extension deleted from basename", !print);
      shorten(V.basename, l - 4);
    }
  }
  if (pos1('.', V.basename) > 0)
    checkExistingFile(&V);
  sprintf(infilename, "%s.mtx", V.basename);
  sprintf(outfilename, "%s.pmx", V.basename);
  strcpy(infile_NAME, infilename);
  if (infile != NULL)
    infile = freopen(infile_NAME, "r", infile);
  else
    infile = fopen(infile_NAME, "r");
  _SETIO(infile != NULL, FileNotFound);
  V.testin = P_ioresult;
  *buffer = '\0';
  strcpy(outfile_NAME, outfilename);
  if (outfile != NULL)
    outfile = freopen(outfile_NAME, "w", outfile);
  else
    outfile = fopen(outfile_NAME, "w");
  _SETIO(outfile != NULL, FileNotFound);
  strcpy(stylefile_NAME, stylefilename);
  if (stylefile != NULL)
    stylefile = freopen(stylefile_NAME, "r", stylefile);
  else
    stylefile = fopen(stylefile_NAME, "r");
  _SETIO(stylefile != NULL, FileNotFound);
  teststyle = P_ioresult;
  if (V.testin != 0) {
    sprintf(STR2, "Input file %s not found", infilename);
    fatalerror(STR2);
  }
  outfile_open = true;
  printf("Writing to %s.pmx\n", V.basename);
}


void CloseFiles(void)
{
  if (outfile != NULL)
    fclose(outfile);
  outfile = NULL;
  if (infile != NULL)
    fclose(infile);
  infile = NULL;
  if (teststyle != 0)
    return;
  if (stylefile != NULL)
    fclose(stylefile);
  stylefile = NULL;
}


static boolean skipEmptyLines(void)
{
  /* TRUE if non-empty line found */
  boolean started = false;
  char *TEMP;

  if (posNot(blank, buffer) == 0)
    *buffer = '\0';
  if (*buffer != '\0')
    return true;
  do {
    eof_infile = P_eof(infile);
    if (*buffer == '\0' && !eof_infile) {
      fgets(buffer, 256, infile);
      TEMP = strchr(buffer, '\n');
      if (TEMP != NULL)
	*TEMP = 0;
      infilecount++;
      if (posNot(blank, buffer) == 0)
	*buffer = '\0';
      else
	started = true;
    }
  } while (!(started || eof_infile));
  if (eof_infile)
    *buffer = '\0';
  return started;
}


void readParagraph(char (*P)[256], short *no, short *L)
{
  boolean ended;
  boolean dropline = false;
  char *TEMP;

  *L = 0;
  if (!skipEmptyLines())
    return;
  paragraph_no++;
  if (startsWithIgnoreCase(buffer, "SUSPEND")) {
    ignore_input = true;
    dropline = true;
  }
  if (startsWithIgnoreCase(buffer, "RESUME")) {
    ignore_input = false;
    dropline = true;
  }
  do {
    if (*L < lines_in_paragraph) {
      if (dropline)
	dropline = false;
      else {
	(*L)++;
	strcpy(P[*L - 1], buffer);
	*buffer = '\0';
	no[*L - 1] = infilecount;
      }
    } else {
      line_no = infilecount;
      warning("Paragraph too long: skipping line", !print);
    }
    eof_infile = P_eof(infile);
    if (eof_infile)
      *buffer = '\0';
    else {
      fgets(buffer, 256, infile);
      TEMP = strchr(buffer, '\n');
      if (TEMP != NULL)
	*TEMP = 0;
      infilecount++;
    }
    ended = (posNot(blank, buffer) == 0 || eof_infile);
  } while (!ended);
  skipEmptyLines();
/* p2c: files.pas: Note: Eliminated unused assignment statement [338] */
}




/* End. */
