/***************************************************************************
**    xIrcMsgQuery.cpp  $Revision: 1.13 $ - $Name: V2-0 $ 
**    Dialog box to ask about Private messages
**
** Copyright (C) 1995, 1996  Joseph Croft <jcroft@unicomp.net>  
** 
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 1, or (at your option)
** any later version.
** 
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
** 
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
**
 ***************************************************************************/
#include <stdio.h>
#include <qfont.h>
#include "xIrcMsgQuery.h"

static int dbg = 0;

static const char *pInitialResources[] =
{
   NULL
};
/*
MessageDialog.
MessageDialog.
MessageDialog.
MessageDialog.
*/

xIrcMsgQuery::xIrcMsgQuery(xWidgetResInfo *pPRes, QWidget *pParent, 
                           const char *pName) :
               xDialog(wdtRes = new xWidgetResInfo(pPRes, QString("messagedialog"),
                                                   QString("MessageDialog")), 
                       pParent, pName)
{
   Resources->setWidgetInit(pInitialResources);
   setDefPallet(this, wdtRes);
   setDefFont(this, wdtRes);

   initClass(pParent, pName);
}

void xIrcMsgQuery::initClass(QWidget *pParent, const char *pName)
{
   if (dbg) fprintf(stdout, "xIrcMsgQuery::initClass():Enter\n");
   if (dbg) fflush(stdout);

   // Appease the compiler warnings
   pParent = pParent;
   pName = pName;
      
   setAcceptFocus(TRUE);   
   
   pEdit = new xMultiLineEdit(wdtRes, this);
   pEdit->setWidth(80);
   pEdit->setHeight(7);
   pEdit->setEnabled(FALSE);

   pButtons = new xPshBtnFrame(wdtRes, this);
   pButtons->setFrameStyle(QFrame::Panel | QFrame::Raised);
   pButtons->setAlignment(xALIGN_Horz);
   pButtons->setMargins(2, 2);
   pButtons->addButton("Chat", QDialog::Accepted);
   pButtons->addButton("Close", QDialog::Rejected);

   addWidget(pEdit);
   addWidget(pButtons);
   setMargins(0, 0);
   setWidgetSpacing(0);
   initFrame();
   
   connect(pButtons, SIGNAL(clicked(int)), this, SLOT(buttonPressed(int)));
   if (dbg) fprintf(stdout, "xIrcMsgQuery::initClass():Exit\n");
   if (dbg) fflush(stdout);   
}

void xIrcMsgQuery::buttonPressed(int results)
{
   if (dbg) fprintf(stdout, "xIrcMsgQuery::button pressed():results = %d\n", results);
   if (dbg) fflush(stdout);
   
   btnPressed = results;
   if (dbg) fprintf(stdout, "xIrcMsgQuery::button pressed():signaling...\n");
   if (dbg) fflush(stdout);
   
   emit done(this);
}

void xIrcMsgQuery::add(xIrcMessage *pMsg)
{
   QString strTmp;
   const char *cp;
   
   if (dbg) fprintf(stdout, "xIrcMsgQuery::setupQuery():Enter\n");
   if (dbg) fflush(stdout);

   msgList.append(pMsg);

   QString caption("New Message From: ");
   caption += pMsg->srcNick;
   setCaption(caption);

   strTmp = "<";
   strTmp += pMsg->srcNick;
   strTmp += "> ";
   for (cp = pMsg->msgStr; *cp; cp++)
   {
      if (*cp != '\n' && *cp != '\r')
         strTmp += *cp;
   }

   pEdit->insertLine(strTmp, -1);
   if (dbg) fprintf(stdout, "xIrcMsgQuery::setupQuery():Exit\n");
   if (dbg) fflush(stdout);   
}

xIrcMsgQuery::~xIrcMsgQuery()
{
   if (dbg) fprintf(stdout, "xIrcMsgQuery::~xIrcMsgQuery(0x%x):Enter\n",
                            (unsigned int)this);
   if (dbg) fflush(stdout);
   if (pEdit)
      delete pEdit;
   if (pButtons)
      delete pButtons;
   if (dbg) fprintf(stdout, "xIrcMsgQuery::~xIrcMsgQuery():Exit\n");
   if (dbg) fflush(stdout);
}

xIrcMsgQuery *xIrcMsgQueryList::find(xIrcMessage *pMsg)
{
   xIrcMsgQuery *p;
   if (dbg) fprintf(stdout, "xIrcMsgQueryList::find():Enter\n");
   if (dbg) fflush(stdout);
   for (p = first(); p != NULL; p = next())
   {
      if (dbg) fprintf(stdout, "xIrcMsgQueryList::find():Testing 0x%x\n",
                       (unsigned int)p);
      if (dbg) fflush(stdout);
      if (p->is(pMsg))
         break;
   }
   if (dbg) fprintf(stdout, "xIrcMsgQueryList::find():Exit(0x%x)\n",
                    (unsigned int)p);
   return(p);
};

#include "xIrcMsgQuery.moc"
