#include "outputwin.h"
#include "icq-defines.h"

//-----OutputWin::constructor----------------------------------------------------------------------
OutputWin::OutputWin(QWidget *parent = 0, const char *name = 0) : QWidget(parent, name)
{
   resize(430, 220);

   char filename[256];
   sprintf(filename, "%s%s", BASE_DIR, "netwin.debug");
   debugFile = new QFile(filename);
   debugFile->open(IO_Append | IO_WriteOnly);

   chkDebug = new QCheckBox ("Dump data to netwin.debug", this);
   chkDebug->setChecked(false);
   //chkDebug->setStyle(WindowsStyle);
   
   outputBox = new MLEditWrap (true, this);
   outputBox->setGeometry(5, 5, 400, 200);
   outputBox->setFrameStyle( QFrame::WinPanel | QFrame::Sunken);
   outputBox->setReadOnly(true);

   btnHide = new QPushButton("Hide Window", this);
   connect(btnHide, SIGNAL(clicked()), this, SLOT(hide()));

   btnClear = new QPushButton("Clear", this);
   connect(btnClear, SIGNAL(clicked()), outputBox, SLOT(clear()));
   
}


//-----OutputWin::resizeEvent----------------------------------------------------------------------
void OutputWin::resizeEvent(QResizeEvent *)                                                        
{
   outputBox->resize(width() - 10, height() - 45);
   btnHide->setGeometry(5, height() - 35, 100, 30);
   btnClear->setGeometry(120, height() - 35, 100, 30);
   chkDebug->setGeometry(235, height() - 35, 200, 30);
}

//-----OutputWin::operator<<-----------------------------------------------------------------------
void OutputWin::operator<<(const char *d)  
{ 
   //outputBox->insertLine(d, 0);
   outputBox->append(d);
   outputBox->newLine();
   if (chkDebug->isChecked()) 
   {
      debugFile->writeBlock(d, strlen(d));
      debugFile->putch('\n');
      debugFile->flush();
   }
}

//-----OutputWin::operator<<-----------------------------------------------------------------------
void OutputWin::operator<<(char d)
{
   char s[2];
   s[0] = d;
   s[1] = '\0';
   *this << s;
}

void OutputWin::operator<<(unsigned long d)
{
   char s[64];
   sprintf(s, "%lu", d);
   *this << s;
}

void OutputWin::operator<<(unsigned short d)
{
   char s[64];
   sprintf(s, "%d", d);
   *this << s;
}


//-----OutputWin::wprintf--------------------------------------------------------------------------
void OutputWin::wprintf(char *formatIn, ...)
{
   va_list argp;
   char formatOut[2048], out[1024], theLine[4096];
   
   unsigned short i = 0, j = 0;
   
   va_start(argp, formatIn);

   while(i < strlen(formatIn) && formatIn[i] != '%') formatOut[j++] = formatIn[i++]; 
   formatOut[j] = '\0';
   sprintf(theLine, "%s", formatOut);
   while(i < strlen(formatIn))
   {
      j = 0;
      switch(formatIn[++i])
      {
      case 'C':   // set color
         i++;
         //wattrset(win, COLOR_PAIR(va_arg(argp, short)));
         (void) va_arg(argp, short);  // for now just read the number in
         while((formatIn[i] != '%') && i < strlen(formatIn)) formatOut[j++] = formatIn[i++]; 
         formatOut[j] = '\0';
         sprintf(theLine, "%s%s", theLine, formatOut);
         break;
      case 'A':   // more generally set attributes
         i++;
         //wattrset(win, va_arg(argp, short));
         while((formatIn[i] != '%') && i < strlen(formatIn)) formatOut[j++] = formatIn[i++]; 
         formatOut[j] = '\0';
         sprintf(theLine, "%s%s", theLine, formatOut);
         break;
      case 'f': break; //can't cast a float right.
      default:
         formatOut[j++] = '%';
         while((formatIn[i] != '%') && i < strlen(formatIn)) formatOut[j++] = formatIn[i++]; 
         formatOut[j] = '\0';
         sprintf(out, formatOut, va_arg(argp, long)); //use a double to make sure we get all of the arg (up to 64 bits).
         sprintf(theLine, "%s%s", theLine, out);
         break;
      }
   }
   va_end(argp);
   *this << theLine;
//   wattrset(win, COLOR_PAIR(COLOR_WHITE));
}


