#ifndef ICQEVENT_H
#define ICQEVENT_H

#include <qtimer.h>
#include <qobject.h>

#include "socket.h"
#include "packet.h"
#include "outputwin.h"


//=====ICQEvent====================================================================================
// wraps a timer event so that the timeout will return the socket and sequence of the packet
// that timed out
class ICQEvent : public QObject
{
   Q_OBJECT
public:
   ICQEvent(unsigned short, unsigned short, unsigned long, unsigned long, INetSocket *, Packet *, OutputWin *);
   ~ICQEvent(void);
   bool start(void);
   bool isEvent(int, unsigned long);
   unsigned short cmd, subCmd;
   unsigned long uin, seq;
   QTimer ackTimer;
protected:   
   unsigned short retries;
   INetSocket *sock;
   Packet *packet;
   OutputWin *outWin;
signals:
   void timedOut(bool, int, int);
protected slots:
   void noAck();
};

#endif
