// Copyright (c) 1998 Albrecht Kleine    All rights reserved
// file version #200

#define TYAASM_S
#include "tyaconfig.h"
#include "tya.h"

#undef  TYAASM_S

.text
	.align 16
.globl Arrstex
	.type	 Arrstex,@function
Arrstex:
	pushl %eax
	pushl %ebx
	movl (LOCSTART-16)(%ebp),%ecx
	// get EE into ecx
	pushl %ecx
	//   cc=(ClassClass**)unhand(arr);
	movl (%ebx),%eax
	//   dcb=*(cc+obj_length(arr));
	movl 4(%ebx),%ecx
	shrl $5,%ecx
	movl (%eax,%ecx,4),%eax
	//	
	pushl %eax
	pushl %edx
	call is_instance_of
	orl %eax,%eax
	popl %edx
	popl %ebx
	popl %ecx
	popl %ebx
	popl %eax
	ret
//////////////////////////////////////////////////////////////

#ifdef FAST_NATIVE102STYLE
	.align 16
.globl CRun32asm
	.type	 CRun32asm,@function
CRun32asm:
	pushl %ebp
	movl %esp,%ebp

	movl 8(%ebp),%edi
	movl 12(%ebp),%esi
	movl 16(%ebp),%ebx

        push %edi
        push %esi
        movl (%esi), %edi	//save
	
        call *%ebx
        movl (%esi), %eax	// LO
	movl %edi, (%esi)	//restore

	movl %ebp,%esp
	popl %ebp
	ret
#endif	
	
//////////////////////////////////////////////////////////////

#ifdef FAST_NATIVE102STYLE
	.align 16
.globl CRun64asm
	.type	 CRun64asm,@function
CRun64asm:
	pushl %ebp
	movl %esp,%ebp

	movl 8(%ebp),%edi
	movl 12(%ebp),%esi
	movl 16(%ebp),%ebx

        push %edi
        push %esi

	movl 4(%esi), %edi	// save	// nb32
	movl %edi, 12(%ebp)		// nb 32
	movl (%esi), %edi   
   
        call *%ebx
	movl (%esi), %eax	// LO
	movl 4(%esi), %edx	// HI
 
	movl %edi, (%esi)	//restore
	movl 12(%ebp), %edi	// nb 32
	movl %edi, 4(%esi)	// nb 32

	movl %ebp,%esp
	popl %ebp
	ret
#endif

///////////////////////////////////////////////////////////


#ifdef USEASM

.globl FastInvCheck32,FastInvNoCheck32
//
// this looks from C side as follows: 
//
// void* FastInvCheck(struct execenv *ee,struct methodblock *mbpcalled,stack_item *sp);
//                                = ebx                   = eax          = 12(%esp)
//
	.type	FastInvCheck32,@function
	
	.align 16
FastInvCheck32:
	cmpl $0,68(%eax)
	je FICheck32_2	
FastInvNoCheck32:
	movl 4(%ebx),%ecx
	movl %ecx,%edx		// cfr
	addl $44,%ecx		// new JF
//
//	if ((char*)JF > (char*)ee->current_frame->javastack->end_data)
// 	  StOvExcHandler();
//	
	movl 20(%edx),%edx	// cfr->jstc
	cmpl %ecx,12(%edx)	// end_data @ 12
	jae FICheck32_1
	call StOvExcHandler

FICheck32_1:
	movl 12(%esp),%edx	// == stack_item *sp	
	movl %edx,12(%ecx)
	movl 4(%ebx),%edx
	movl %edx,16(%ecx)
	movl %eax,28(%ecx)
	movl 20(%edx),%edx
	movl %edx,20(%ecx)
	leal 40(%ecx),%edx
	movl %edx,8(%ecx)	// ecx is ee->current_frame
	movl %ecx,4(%ebx)
	movl 68(%eax),%eax
	//	
	movl 16(%ecx),%ecx	// ...->prev    [ also via subl $44,%ecx ]
	ret
	// returning:
	// eax is mbpcalled->CompiledCode  /  ebx is ee   /  ecx is ee->current_frame->prev
//	
//	JF++;
//	JF->vars=sp;
//	JF->prev=ee->current_frame;
//	JF->current_method=mbpcalled;
//	JF->javastack=ee->current_frame->javastack;
//	JF->optop=JF->ostack;
//	ee->current_frame=JF;
//
	.align 16
FICheck32_2:
	testb $1,17(%eax)		// this is ACC_NATIVE's hibyte
	jne FICheck32_3

	pushl %ebx 
	pushl %eax 
	call JITCompileMethod
	testl %eax,%eax
	popl %eax
	popl %ebx
	jne FastInvNoCheck32
FICheck32_3:
	movl 4(%ebx),%ecx
	movl $CodeRunner32_withDummies,%eax
	ret
	


.globl FastInvCheck64,FastInvNoCheck64
	.type	 FastInvCheck64,@function
	.align 16
FastInvCheck64:
	cmpl $0,68(%eax)
	je FICheck64_2
FastInvNoCheck64:
	movl 4(%ebx),%ecx
	movl %ecx,%edx		// cfr
	addl $44,%ecx		// new JF
//
//	if ((char*)JF > (char*)ee->current_frame->javastack->end_data)
// 	  StOvExcHandler();
//	
	movl 20(%edx),%edx	// cfr->jstc
	cmpl %ecx,12(%edx)	// end_data @ 12
	jae FICheck64_1
	call StOvExcHandler
FICheck64_1:
	movl 12(%esp),%edx	// == stack_item *sp	
	movl %edx,12(%ecx)
	movl 4(%ebx),%edx
	movl %edx,16(%ecx)
	movl %eax,28(%ecx)
	movl 20(%edx),%edx
	movl %edx,20(%ecx)
	leal 40(%ecx),%edx
	movl %edx,8(%ecx)	// ecx is ee->current_frame
	movl %ecx,4(%ebx)
	movl 68(%eax),%eax
	//	
	movl 16(%ecx),%ecx	// ...->prev    [ also via subl $44,%ecx ]
	ret
	// returning:
	// eax is mbpcalled->CompiledCode  /  ebx is ee   /  ecx is ee->current_frame->prev
//	
//	JF++;
//	JF->vars=sp;
//	JF->prev=ee->current_frame;
//	JF->current_method=mbpcalled;
//	JF->javastack=ee->current_frame->javastack;
//	JF->optop=JF->ostack;
//	ee->current_frame=JF;
//
	.align 16
FICheck64_2:
	testb $1,17(%eax)		// this is ACC_NATIVE's hibyte
	jne FICheck64_3

	pushl %ebx 
	pushl %eax 
	call JITCompileMethod
	testl %eax,%eax
	popl %eax
	popl %ebx
	jne FastInvNoCheck64
	
FICheck64_3:
	movl $CodeRunner64_withDummies,%eax
	movl 4(%ebx),%ecx	
	ret	
#endif
//////////////////////////////////////////////////////////////
#ifdef USEASM

	.align 16
.globl MyObjAlloc
	.type	 MyObjAlloc,@function
MyObjAlloc:
	// expecting class in eax
	pushl $0
	pushl %eax
	call ObjAlloc
	popl %ebx
	popl %ecx
	testl %eax,%eax
	je .MyObjAlloc2
	movl (%ebx),%edx	// unhand(class)
	movl %edi,%ebx		// save edi
	movl (%eax),%edi	// unhand(object)

	movzwl 84(%edx),%ecx
	movl %eax,%edx
	shrl $0x2,%ecx
	xorl %eax,%eax
	cld
	rep 
	stosl %es:(%edi)
	movl %edx,%eax
	movl %ebx,%edi		// restore edi
	ret
.MyObjAlloc2:
	jmp out_of_memory
#endif
//////////////////////////////////////////////////////////////


	.align 16
.globl StOvExcHandler
	.type	 StOvExcHandler,@function
StOvExcHandler:

#ifndef USEASM
	movl %ebp,%esp			// discard caller's C stack frame
	popl %ebp			// for access to stack pointer
#endif
	call EE
	pushl StOvExc			// params for ExecExcep
	pushl %eax
	jmp SEH1			// exc is not catchable inside method
	
/////////////////////////////////////////////////////////////


	.align 16
.globl SimpleExcHandler
	.type	 SimpleExcHandler,@function
SimpleExcHandler:
	pushl %eax			// expecting in eax: ExcObject
	movl (LOCSTART-16)(%ebp),%edx	// get EE into ecx
	pushl %edx
SEH1:	
	call ExecExcep
	movl %ebp,%esp			// standard epilog
	popl %ebp
	popl %edi
	popl %esi
	popl %ebx
	ret
	
/////////////////////////////////////////////////////////////

