/* gencust.h */
/* Chris Jacobi, October 1, 1997 2:29 pm PDT */

/*
 * Copyright (c) 1997 Xerox Corporation.  All Rights Reserved.
 * Unlimited use, reproduction, and distribution of this software is permitted.
 * Any copy of this software must include both the above copyright notice of
 * Xerox Corporation and this paragraph.  Any distribution of this software
 * must comply with all applicable United States export control laws.  This
 * software is made available AS IS, and XEROX CORPORATION DISCLAIMS ALL
 * WARRANTIES, EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, AND
 * NOTWITHSTANDING ANY OTHER PROVISION CONTAINED HEREIN, ANY LIABILITY FOR
 * DAMAGES RESULTING FROM THE SOFTWARE OR ITS USE IS EXPRESSLY DISCLAIMED,
 * WHETHER ARISING IN CONTRACT, TORT (INCLUDING NEGLIGENCE) OR STRICT
 * LIABILITY, EVEN IF XEROX CORPORATION IS ADVISED OF THE POSSIBILITY OF SUCH
 * DAMAGES.
 */
 
/* $Id: gencust.h,v 1.3 1997/10/01 22:18:06 jacobi Exp $ */

typedef struct customMappingSpec_s {
    char* iluTypeName;
    char* javaTypeName;
    char* holderClassName;
    char* loadThisClassName;
} CustomMappingSpec;


extern boolean custom_is_a(Type t);
extern Type custom_assert(Type t);

extern char * custom_typeDeclarator(Type t);

extern char * custom_ioSzPiece(Type t, const char *arg);
extern char * custom_ioOutPiece(Type t, const char *arg);
extern char * custom_ioInPiece(Type t);


extern char * custom_holderTypeDeclarator(Type t);
    /* returns 0 if not defined. Idea is: if it returns 0
     * use the standard holder name...
     */

extern void custom_PrintHelperStubs(Type t);

/* end */
