/* context.c */
/* Chris Jacobi, November 12, 1997 2:54 pm PST */

/*
 * Copyright (c) 1991-1996 Xerox Corporation.  All Rights Reserved.
 * Unlimited use, reproduction, and distribution of this software is permitted.
 * Any copy of this software must include both the above copyright notice of
 * Xerox Corporation and this paragraph.  Any distribution of this software
 * must comply with all applicable United States export control laws.  This
 * software is made available AS IS, and XEROX CORPORATION DISCLAIMS ALL
 * WARRANTIES, EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, AND
 * NOTWITHSTANDING ANY OTHER PROVISION CONTAINED HEREIN, ANY LIABILITY FOR
 * DAMAGES RESULTING FROM THE SOFTWARE OR ITS USE IS EXPRESSLY DISCLAIMED,
 * WHETHER ARISING IN CONTRACT, TORT (INCLUDING NEGLIGENCE) OR STRICT
 * LIABILITY, EVEN IF XEROX CORPORATION IS ADVISED OF THE POSSIBILITY OF SUCH
 * DAMAGES.
 */
 
/* $Id: context.c,v 1.18 1997/11/12 23:09:17 jacobi Exp $ */


#include <stdio.h>
#include <string.h>
#include "iluptype.h" 
#include "shared.h"
#include "context.h"
#include "stubops.h"
#include "name.h"

#define AND &&


/*public*/
IHandle currentIH;
Interface currentIfc;

PUBLIC void setCurrentIfc(Interface ifc)
{
    currentIfc = ifc;
}

PRIVATE IHandle rootContext = 0;
PRIVATE IHandle emptyNameContext = 0;


PRIVATE boolean ihMatch(IHandle ctx, char* b)
{
    return (strcmp(ctx->i.step0, b) == 0);
}


PRIVATE IHandle newContext(IHandle parent)
{
    IHandle c = (IHandle) iluparser_Malloc(sizeof(struct context_s));
    c->p.prefix = 0;
    c->p.dirName = 0;
    c->p.flatDir = 0;
    c->p.genHlp = 0;
    c->p.genHldCls = 0;
    c->p.noServer = 0;
    c->p.genDel = 0;
    c->p.genFactory = 0;
    c->p.forbidden = 0;
    c->p.genImpl = 0;
    c->p.genVisiVar = 0;
    c->p.stubSuffix = 0;
    c->p.refSuffix = 0;
    c->p.holderSuffix = 0;
    c->p.helperSuffix = 0;
    c->p.delClassSuffix = 0;
    c->p.exceptSuffix = 0;
    c->p.implSuffix = 0;
    c->p.implPrefix = 0;
    c->p.loaderClass_Name = 0;
    c->p.genOmgAttr = 0;
    c->p.prerem = 0;
    c->p.extraSuffix = 0;
    c->p.extraFiles = 0;
    c->i.step0 = 0;
    c->i.step = 0;
    c->i.chain = 0;
    c->i.packagePrefix = 0;
    c->i.children = new_list();
    c->i.stuffToLoad = new_list();
    c->i.customMappings = 0;
    c->i.isIdlInterface = 0;
    c->i.specialIdlConstants = 0;
    c->i.up = parent;
    return c;
}


PUBLIC IHandle getContextRoot()
{
    IHandle ih = rootContext;
    if (ih==0) {
        ih = newContext(0);
        rootContext = ih;
    }
    return ih;
}


PRIVATE IHandle newChild(IHandle ctx)
{
    IHandle ih = newContext(ctx);
    if (ctx) {
        ih->p = ctx->p;
    }
    return ih;
}


PUBLIC IHandle getChildContext(IHandle ph, char* piece, boolean create) {
    IHandle found;
    if (ph->i.children==0) {
       ph->i.children = new_list();
    }
    found = (IHandle) 
        list_find(ph->i.children, (iluparser_FindProc) ihMatch, piece);
    if ((found == 0) && create) {
        found = newChild(ph);
        found->i.step0 = piece;
        found->i.step = javaizeString(found->i.step0);
        list_insert(ph->i.children, found);
    }
    return found;
}

PUBLIC IHandle getContext(Interface ifc, list scoping)
{
    IHandle ih = getContextRoot();
    listElement *ptr;
    if (scoping==0) {
        if (ifc==0) {
            return getContextC(0);
        }
        ih = getChildContext(ih, interface_name(ifc), 1);
        return ih;
    }
    /* step down scoping, but ommit last element as this is a feature name
     * and not a module name
     */
    for (ptr = scoping->head; (ptr != NULL AND ptr->next != NULL);  ptr = ptr->next) {
        char* piece = (char*) ptr->data;
        ih = getChildContext(ih, piece, 1);
    }
    return ih;
}

PRIVATE int dotPos(const char* s)
{
    int i;
    int length = stringlength(s);
    for (i = 0; i<length; i++) {
        if (s[i] == '.') return i;
    }
    return -1;
}

PRIVATE char* leftsubstring(const char* s, int cnt)
{
    int i;
    string buff;
    buff = iluparser_Malloc(cnt+1);
    for (i = 0; i<cnt; i++) {
        buff[i] = s[i];
    }
    buff[cnt] = 0;
    return buff;
}


PUBLIC IHandle getContextC(char * name)
{
    char* lp;
    int dp; 
    IHandle ih = getContextRoot();
    if (name==0) {
        if (emptyNameContext==0) {
            ih = newChild(ih);
        }
        return emptyNameContext;
    }
    while (stringlength(name) > 0) {
        dp = dotPos(name);
        if (dp<0) return getChildContext(ih, name, 1);
        lp = leftsubstring(name, dp-1);
        ih = getChildContext(ih, lp, 1);
        name = name + dp + 1;
    }
    return ih;
}


PUBLIC IHandle getContextTraw(Type t)
{
    return getContext(t->interface, t->scoping);
}


PUBLIC IHandle getContextT(Type t)
{
    t = ur_type(t);
    return getContext(t->interface, t->scoping);
}

PRIVATE void defineChain(IHandle ih) {
    if (ih->i.chain == 0) {
        if (ih->i.up) {
            defineChain(ih->i.up);
            ih->i.chain = dotCat(ih->i.up->i.chain, ih->i.step);
        } else {
            ih->i.chain = ih->i.step;
        }
        if (ih->i.isIdlInterface) {
            ih->i.chain = cat2(ih->i.chain, "Package");
        }
    }
}

PUBLIC char* packagePrefix(IHandle ih)
{
    if (ih->i.packagePrefix==0) {
        defineChain(ih);
        ih->i.packagePrefix = dotCat(ih->p.prefix, ih->i.chain);
    }
    return ih->i.packagePrefix;
}

     
PUBLIC void setCurrentIH(IHandle ih)
{
    currentIH = ih;
    if (ih AND ih->p.forbidden) {
        defineChain(ih);
        fatalError(cat2("Must not generate stubs for %s", ih->i.chain));
    }
}

