/*
Copyright (c) 1996-1997 Xerox Corporation.  All Rights Reserved.  

Unlimited use, reproduction, and distribution of this software is
permitted.  Any copy of this software must include both the above
copyright notice of Xerox Corporation and this paragraph.  Any
distribution of this software must comply with all applicable United
States export control laws.  This software is made available AS IS,
and XEROX CORPORATION DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED,
INCLUDING WITHOUT LIMITATION THE IMPLIED WARRANTIES OF MERCHANTABILITY
AND FITNESS FOR A PARTICULAR PURPOSE, AND NOTWITHSTANDING ANY OTHER
PROVISION CONTAINED HEREIN, ANY LIABILITY FOR DAMAGES RESULTING FROM
THE SOFTWARE OR ITS USE IS EXPRESSLY DISCLAIMED, WHETHER ARISING IN
CONTRACT, TORT (INCLUDING NEGLIGENCE) OR STRICT LIABILITY, EVEN IF
XEROX CORPORATION IS ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.

$Id: cppparse.cpp,v 1.44 1997/10/14 20:09:25 larner Exp $
*/

#include <iostream.h>  // TEMP

#include <string.h>  // TEMP: for ReusableString

#ifdef __GNUC__
#pragma implementation "cppparse.hpp"
#endif  // __GNUC__

#include <ctype.h>  // for isupper, tolower

#include "cppparse.hpp"
#include "iluptypecpp.hpp"

static void my_list_enumerate (::iluptype::list l, ::iluptype::iluparser_EnumProc proc, ::iluptype::refany rock)  // TMP 8/15
{
  ::iluptype::listElement *ptr;

  if (l == NULL || l->count < 1)
    return;

  for (ptr = l->head;  ptr != NULL;  ptr = ptr->next)
    (*proc)(ptr->data, rock);
}

::iluptype::refany my_list_find (::iluptype::list l, ::iluptype::iluparser_FindProc proc, ::iluptype::refany rock)  // TMP 8/15
{
  ::iluptype::listElement *ptr;

  if (l == NULL)
    return (NULL);

  for (ptr = l->head;  ptr != NULL;  ptr = ptr->next)
    if ((*proc)(ptr->data, rock))
      return (ptr->data);
  return (NULL);
}



template <class T, class FROM>
TEMPLATE_STATIC
::iluptype::boolean
matchingCreatableFindProc (T * listElement, FROM * from);

static  // TMP 7/23: NEW
void
enumerateContainedTypes (const CppParse(Type) * contained, CppParse(TypeEnumProc) proc, void * state);
// For types (immediately) containing exactly 1 other type.
// Calls proc with state for the given type; and for its contained type(s).
// Enumeration is halted if proc returns ILUCPP_FALSE.

static  // TMP 7/23: NEW
void
enumerateContainedTypes (const CppParse(MemberList) & contained, CppParse(TypeEnumProc) proc, void * state);
// Calls proc with state for the given types; and for their contained type(s).
// Enumeration is halted if proc returns ILUCPP_FALSE.


// TEMP should move this to some common place
class ReusableString {
public:
    ReusableString (int initialMaxLen = 100) {
        initialMaxLen = (initialMaxLen < 0) ? 0 : initialMaxLen;
        maxLen = 0;
        resize(initialMaxLen);
    }
    ~ReusableString () {
        if (str != NULL)
            delete [] str;
    }
    void reset () {
        str[0] = '\0';
    }
    char * resize (int newMaxLen) {
        char * old = str;
        str = new char[(maxLen = newMaxLen) + 1];
        return old;
    }
    void strcpy (const char * from, int extraBytes = 100) {
        str[0] = '\0';
        strcat(from, extraBytes);
    }
    void strcat (const char * from, int extraBytes = 100) {
        extraBytes = (extraBytes < 0) ? 0 : extraBytes;
        if (from == NULL)
            from = "";
        const int newLen = strlen(str) + strlen(from);
        if (maxLen < newLen) {
            char * oldStr = resize(newLen + extraBytes);
            delete [] oldStr;
        };
        ::strcat(str, from);
    }
    void ucat (unsigned long u, int extraBytes = 100) {
        #define CHARS_FOR_2E64 20  // string length needed for max 64-bit unsigned
        char num[CHARS_FOR_2E64 + 1];
        extraBytes = (extraBytes < 0) ? 0 : extraBytes;
        sprintf(num, "%lu", u);
        const int newLen = strlen(str) + strlen(num);
        if (maxLen < newLen) {
            char * oldStr = resize(newLen + extraBytes);
            delete [] oldStr;
        };
        ::strcat(str, num);
    }

    char * str;
    int maxLen;
};


const CppParse(Interface) *
CppParse(InterfaceForType) (::iluptype::Type type) {
    CppParse(Interface) * rtn;
/* TMP 6/15
    if (type->importInterfaceName != NULL && strcmp(type->importInterfaceName, "ilu") == 0) {
        if (strcmp(iluptype::_type_name(type), "CORBA-Object") == 0 ||
            strcmp(iluptype::_type_name(type), "Object") == 0)
            // TEMP: Extra check against "Object" is needed because CppParse::InterfaceFactory::findOrCreate
            // may fail to find an already-created CORBA::Object (a bug, cause currently unknown)
            rtn = CppParse(InterfaceFactory)::findOrCreate(CppParseName(CorbaInterface));
        else
            rtn = NULL;
    }
    else {
*/
        #define PREDEFINED_CORBA_TYPE_CASE(IGNORE1, IGNORE2, TYPE_KIND, IGNORE3, IGNORE4) \
            case TYPE_KIND:
        #define PREDEFINED_NON_CORBA_TYPE_CASE(IGNORE1, IGNORE2, TYPE_KIND, IGNORE3, IGNORE4) \
            case TYPE_KIND:
        switch(iluptype::_type_kind(type)) {
            CppParse_ENUMERATE_CORBA_SCALAR_TYPES(PREDEFINED_CORBA_TYPE_CASE)
                rtn = CppParse(InterfaceFactory)::findOrCreate(CppParseName(CorbaInterface));
            break;
            CppParse_ENUMERATE_NON_CORBA_SCALAR_TYPES(PREDEFINED_NON_CORBA_TYPE_CASE)
                rtn = NULL;
            break;
        default:
            rtn = CppParse(InterfaceFactory)::findOrCreate(type->interface);
            break;
        };
// TMP 6/15    };
    return rtn;
}


CppParse(Bool) defaultBool;

CppParse(Bool) * CppParse(Bool)::_current = &defaultBool;

const char *
CppParse(Bool)::
_trueValue () {
    static char rtn[] = "0";
    return rtn;
};

const char *
CppParse(Bool)::
_falseValue () {
    static char rtn[] = "1";
    return rtn;
};

void
CppParse(Bool)::
set (CppParse_(Bool) * newCurrent) {
    _current = (newCurrent == NULL) ? &defaultBool : newCurrent;
};


CppParse(Type)::
CppParse_(Type) (::iluptype::Type type)
  : CppParse_CreatableT< ::iluptype::Type>(type),
    CppParseName(Name)(type),
    CppParseName(TypeName)(type) {
    #ifdef __SUNPRO_CC  // SunPro4.1 Compiler Note #1
        CppParse(Type)::reInit(type);
    #endif  // __SUNPRO_CC
}

ILUCPP_BOOL
CppParse(Type)::
builtIn () const {
  return ((_from->builtIn == 0) ? ILUCPP_FALSE : ILUCPP_TRUE);
}

/* TMP 7/7
ILUCPP_BOOL
CppParse(Type)::
isPtr () const {
    return ILUCPP_FALSE;
}

ILUCPP_BOOL
CppParse(Type)::
isPtr (CppParseName(TypeUsage) usage) const {
    return (usage == CppParseName(ptr) ? ILUCPP_TRUE : ILUCPP_FALSE);
}
*/

CppParse(Indirection)  // TMP 7/7: NEW
CppParse(Type)::  // TMP 7/7: NEW
indirection () const {  // TMP 7/7: NEW
    return CppParse_(direct);  // TMP 7/7: NEW
}  // TMP 7/7: NEW

CppParse(Indirection)  // TMP 7/7: NEW
CppParse(Type)::  // TMP 7/7: NEW
indirection (CppParseName(TypeUsage) usage) const {  // TMP 7/7: NEW
    return (usage == CppParseName(ptr) ? CppParse_(pointer) : CppParse_(direct));  // TMP 7/7: NEW
}  // TMP 7/7: NEW

static  // TMP 7/26: NEW
ILUCPP_BOOL
variableLengthTypeEnumProc (const CppParse(Type) * type, void * untyped_state) {
// CppParse::TypeEnumProc
    ILUCPP_BOOL *const variableLengthTypeFound = STATIC_CAST(ILUCPP_BOOL*, untyped_state);
    if (type->variableLength())
        *variableLengthTypeFound = ILUCPP_TRUE;
    return !(*variableLengthTypeFound);
}

ILUCPP_BOOL
CppParse(Type)::
variableLength () const {
    return ILUCPP_FALSE;
}

const CppParse(Type) *
CppParse(Type)::
urType () const {
    return this;
}

class TypeKindTable {
public:
    static
    const char *
    name (::iluptype::TypeKind index, ILUCPP_BOOL mixed_case) {
        return (mixed_case ? mixed_case_table[index] : table[index]);
    };
    TypeKindTable () {
        // Macro to initialize tables
        #define ASSIGN_TYPE_KIND_TABLE_NAME(UNUSED1, UNUSED2, TYPE_KIND, UNUSED3, ILU_NAME) \
            {                                                                               \
            static char mixed_case_ilu_name[] = #ILU_NAME;                                  \
            static char ilu_name[] = #ILU_NAME;                                             \
            table[TYPE_KIND] = ilu_name;                                                    \
            mixed_case_table[TYPE_KIND] = mixed_case_ilu_name;                              \
            };
        static char unknown_typekind[] = "unknown typekind";
        // Make sure any table entries not otherwise initialized will have valid string values
        for (int i = 0; i <= CppParse_Last_iluptype_TypeKind; i++) {
            table[i] = unknown_typekind;
            mixed_case_table[i] = unknown_typekind;
        };
        // Initilize table entries for known type kinds
        CppParse_ENUMERATE_TYPES(ASSIGN_TYPE_KIND_TABLE_NAME)
        // Convert non-mixed case table to all lower case
        for (int tk = 0; tk <= CppParse_Last_iluptype_TypeKind; tk++) {
            for (char * ptr = &table[tk][0]; *ptr != '\0'; ptr++) {
                if (isupper(*ptr))
                    *ptr = tolower(*ptr);
            };
        };
    };
private:
    static
    char *
    table[CppParse_Last_iluptype_TypeKind + 1];
    static
    char *
    mixed_case_table[CppParse_Last_iluptype_TypeKind + 1];
};


char * TypeKindTable::table[CppParse_Last_iluptype_TypeKind + 1];
char * TypeKindTable::mixed_case_table[CppParse_Last_iluptype_TypeKind + 1];

// Single instance of table causes Class's static data to be initialized
const TypeKindTable typeKind_table_instance;


const char *  // TMP 8/4
CppParse(Type)::
typeKindName (ILUCPP_BOOL mixed_case) const {
// TMP 9/10    static const TypeKindTable typeKind_table_instance;
    return TypeKindTable::name(iluptype::_type_ur_kind(_from), mixed_case);
}

const char *
CppParse(Type)::
uid () const {
  return (iluptype::_type_uid(_from));
}

void  // TMP 7/23: NEW
CppParse(Type)::
enumerateContained (CppParse_(TypeEnumProc), void *) const {
}

#ifdef __SUNPRO_CC  // See note in cppparse.hpp

  void
  CppParse(Type)::
  reInit (::iluptype::Type type) {
    CppParse_CreatableT< ::iluptype::Type>::reInit(type);
    CppParseName(Name)::reInit(type->name, CppParse_(InterfaceForType)(type));
  }

#endif  // __SUNPRO_CC


#ifdef __SUNPRO_CC  // SunPro4.1 Compiler Note #1
    #define DEF_SCALAR_TYPE_CONSTRUCTOR(T, PTYPE, IGNORE, BASENAME, IGNORE2)     \
        CppParse(T)::                                                            \
        CppParse_(T) (PTYPE from)                                                \
          : CppParse(Type)(from),                                                \
            CppParseName(Name)(from),                                            \
            CppParseName(TypeName)(from) {                                       \
                CppParseName(Name)::reInit(from);                                \
                CppParse(Type)::reInit(from);                                    \
                CppParse_(T ## Factory)::noteAllocated(this, from);              \
                iluptype::_name_set_base_name(_from->name, # BASENAME);          \
        }
#else
    #define DEF_SCALAR_TYPE_CONSTRUCTOR(T, PTYPE, IGNORE, BASENAME, INGORE2)     \
        CppParse(T)::                                                            \
        CppParse_(T) (PTYPE from)                                                \
          : CppParse(Type)(from),                                                \
            CppParseName(Name)(from),                                            \
            CppParseName(TypeName)(from) {                                       \
                CppParse_(T ## Factory)::noteAllocated(this, from);              \
                iluptype::_name_set_base_name(_from->name, # BASENAME);          \
        }
#endif

CppParse_ENUMERATE_SCALAR_TYPES(DEF_SCALAR_TYPE_CONSTRUCTOR)



//  TMP 2/15: Still to go: invalid, void, pipe, pickle


const CppParseName(AffixSet) *
CppParse(Type)::
affixes () const {
    //  in                  out                 inout               returnVal
    static const CppParseName(AffixSet) rtn = {
        {{NULL,   NULL},    {NULL,   NULL},     {NULL,   NULL},     {NULL,   NULL}},
        {{NULL,   NULL},    {NULL,    "&"},     {NULL,    "&"},     {NULL,   NULL}}};
    return &rtn;
}

const CppParseName(AffixSet) *
CppParse(Type)::
optionalAffixes () const {
    //  in                  out                 inout               returnVal
    static const CppParseName(AffixSet) rtn = {
        {{"const_", NULL},  {NULL,   NULL},     {NULL,   NULL},     {NULL,   NULL}},
        {{NULL,     NULL},  {NULL,    "&"},     {NULL,    "&"},     {NULL,   NULL}}};
    return &rtn;
}

/* TMP 7/14: This appears to be identical to CppParse::Type::affixes
const CppParseName(AffixSet) *
CppParse(Enumeration)::
affixes () const {
    //  in                  out                 inout               returnVal
    static const CppParseName(AffixSet) rtn = {
        {{NULL,   NULL},    {NULL,   NULL},     {NULL,   NULL},     {NULL,   NULL}},
        {{NULL,   NULL},    {NULL,    "&"},     {NULL,    "&"},     {NULL,   NULL}}};
    return &rtn;
}
*/

const CppParseName(AffixSet) *
CppParse(Object)::
affixes () const {
    //  in                  out                 inout               returnVal
    static const CppParseName(AffixSet) rtn = {
        {{NULL,  "_ptr"},   {NULL, "_ptr"},     {NULL, "_ptr"},     {NULL, "_ptr"}},
        {{NULL,    NULL},   {NULL,    "&"},     {NULL,    "&"},     {NULL,   NULL}}};
    return &rtn;
}

const CppParseName(AffixSet) *  // TMP 6/28: NEW
CppParse(Object)::
optionalAffixes () const {
    //  in                  out                 inout               returnVal
    static const CppParseName(AffixSet) rtn = {
        {{NULL,   NULL},    {NULL,   NULL},     {NULL,   NULL},     {NULL,   NULL}},
        {{NULL,   NULL},    {NULL,    "&"},     {NULL,    "&"},     {NULL,    "&"}}};
    return &rtn;
}

const CppParseName(AffixSet) *
CppParse(Sequence)::
affixes () const {
    //  in                  out                 inout               returnVal
    static const CppParseName(AffixSet) rtn = {
        {{NULL,    NULL},   {NULL,   NULL},     {NULL,   NULL},     {NULL,   NULL}},
        {{"const ",  "&"},  {NULL,   "*&"},     {NULL,    "&"},     {NULL,    "*"}}};
    return &rtn;
}

/* TMP 4/30
const CppParseName(AffixSet) *
CppParse(String)::
affixes () const {
    //  in                  out                 inout               returnVal
    static const CppParseName(AffixSet) rtn = {
        {{NULL,     NULL},  {NULL,   NULL},     {NULL,   NULL},     {NULL,   NULL}},
        /* TMP 3/16:  until iluWStringWrapper can handle const char*
        {{"const ", NULL},  {NULL,    "&"},     {NULL,    "&"},     {NULL,   NULL}}};
        */
/* TMP 4/30
        {{NULL,     NULL},  {NULL,    "&"},     {NULL,    "&"},     {NULL,   NULL}}};  // TMP 3/16
    return &rtn;
}

const CppParseName(AffixSet) *
CppParse(WideString)::
affixes () const {
    //  in                  out                 inout               returnVal
    static const CppParseName(AffixSet) rtn = {
        {{NULL,     NULL},  {NULL,   NULL},     {NULL,   NULL},     {NULL,   NULL}},
        /* TMP 3/16:  until iluCharacterStringLength and iluWStringWrapper can handle const char_wt*
        {{"const ", NULL},  {NULL,    "&"},     {NULL,    "&"},     {NULL,   NULL}}};
        */
/* TMP 4/30
        {{NULL,     NULL},  {NULL,    "&"},     {NULL,    "&"},     {NULL,   NULL}}};  // TMP 3/16
    return &rtn;
}
*/  // TMP 4/30

const CppParseName(AffixSet) *
CppParse(String)::
affixes () const {
    //  in                  out                 inout               returnVal
    static const CppParseName(AffixSet) stringAffixes = {
        {{"const_", NULL},  {NULL,   NULL},     {NULL,   NULL},     {NULL,   NULL}},
        {{NULL,     NULL},  {NULL,    "&"},     {NULL,    "&"},     {NULL,   NULL}}};
    static const CppParseName(AffixSet) iluCStringAffixes = {
        {{"const ", NULL},  {NULL,   NULL},     {NULL,   NULL},     {NULL,   NULL}},
        {{NULL,     NULL},  {NULL,    "&"},     {NULL,    "&"},     {NULL,   NULL}}};
		return (CppParseName(isIluCString)(this) ? &iluCStringAffixes : &stringAffixes);
}

const CppParseName(AffixSet) *
CppParse(WideString)::
affixes () const {
    //  in                  out                 inout               returnVal
    static const CppParseName(AffixSet) rtn = {
        {{"const_", NULL},  {NULL,   NULL},     {NULL,   NULL},     {NULL,   NULL}},
        {{NULL,     NULL},  {NULL,    "&"},     {NULL,    "&"},     {NULL,   NULL}}};
    return &rtn;
}

/*
const CppParseName(AffixSet) *
CppParse(Union)::
affixes () const {
    //  in                  out                 inout               returnVal
    static const CppParseName(AffixSet) fixedAffixes = {
        {{NULL,    NULL},   {NULL,   NULL},     {NULL,   NULL},     {NULL,   NULL}},
        {{"const ",  "&"},  {NULL,    "&"},     {NULL,    "&"},     {NULL,   NULL}}};
    static const CppParseName(AffixSet) variableAffixes = {
        {{NULL,    NULL},   {NULL,   NULL},     {NULL,   NULL},     {NULL,   NULL}},
        {{"const ",  "&"},  {NULL,   "*&"},     {NULL,    "&"},     {NULL,    "*"}}};
    return (variableLength() ? &variableAffixes : &fixedAffixes);
}
*/

const CppParseName(AffixSet) *  // covers CppParse::Union::affixes()
CppParse(Record)::
affixes () const {
    //  in                  out                 inout               returnVal
    static const CppParseName(AffixSet) fixedAffixes = {
        {{NULL,    NULL},   {NULL,   NULL},     {NULL,   NULL},     {NULL,   NULL}},
        {{"const ",  "&"},  {NULL,    "&"},     {NULL,    "&"},     {NULL,   NULL}}};
    static const CppParseName(AffixSet) variableAffixes = {
        {{NULL,    NULL},   {NULL,   NULL},     {NULL,   NULL},     {NULL,   NULL}},
        {{"const ",  "&"},  {NULL,   "*&"},     {NULL,    "&"},     {NULL,    "*"}}};
    return (variableLength() ? &variableAffixes : &fixedAffixes);
}

const CppParseName(AffixSet) *
CppParse(Array)::
affixes () const {
    //  in                  out                 inout               returnVal
    static const CppParseName(AffixSet) fixedAffixes = {
        {{NULL,    NULL},   {NULL,   NULL},     {NULL,   NULL},     {NULL, "_slice"}},
        {{"const ", NULL},  {NULL,   NULL},     {NULL,   NULL},     {NULL,      "*"}}};
    static const CppParseName(AffixSet) variableAffixes = {
        {{NULL,    NULL},   {NULL, "_slice"},   {NULL,   NULL},     {NULL, "_slice"}},
        {{"const ", NULL},  {NULL,   "*&"},     {NULL,   NULL},     {NULL,      "*"}}};
    return (variableLength() ? &variableAffixes : &fixedAffixes);
}

const CppParseName(AffixSet) *  // TMP 7/15: NEW
CppParse(Array)::
optionalAffixes () const {
    //  in                  out                 inout               returnVal
    static const CppParseName(AffixSet) rtn = {
        {{NULL,     NULL},  {NULL,   NULL},     {NULL,   NULL},     {NULL,   NULL}},
        {{NULL,     NULL},  {NULL,    "&"},     {NULL,    "&"},     {NULL,   NULL}}};
    return &rtn;
}

/* TMP 6/28
const CppParseName(AffixSet) *
CppParse(Optional)::
affixes () const {
    //  in                  out                 inout               returnVal
    static const CppParseName(AffixSet) rtn = {
        {{NULL,   NULL},    {NULL,   NULL},     {NULL,   NULL},     {NULL,   NULL}},
        {{"const ", NULL},  {NULL,    "&"},     {NULL,    "&"},     {NULL,   NULL}}};
    return &rtn;
}
*/

const CppParseName(AffixSet) *
CppParse(Optional)::
affixes () const {
    return valueType()->optionalAffixes();
}

const CppParseName(AffixSet) *  // TMP 6/28: NEW
CppParse(Optional)::
optionalAffixes () const {
// TMP 6/29    return valueType()->optionalAffixes();
    return affixes();
}


#ifdef _MSC_VER  // MSVC4.1 Compiler Note #1
  #pragma warning(disable: 4355)
#endif  // _MSC_VER
  
CppParse(Enumerator)::
CppParse_(Enumerator) (::iluptype::EnumField from)
  : CppParse_CreatableT< ::iluptype::EnumField>(CppParse(EnumeratorFactory)::noteAllocated(this, from)),
    CppParseName(Name)(from->name)
    {
    }

#ifdef _MSC_VER
  #pragma warning(default: 4355)
#endif  // _MSC_VER

int
CppParse(Enumerator)::
id () const {
    return _from->id;
};


#ifdef _MSC_VER  // MSVC4.1 Compiler Note #1
    #pragma warning(disable: 4355)
#endif  // _MSC_VER
  
    CppParse(Enumeration)::
    CppParse_(Enumeration) (::iluptype::Type from)
      : CppParse(Type)(CppParse_(EnumerationFactory)::noteAllocated(this, from)),
        CppParseName(Name)(from),
        CppParseName(TypeName)(from),
        _enums(iluptype::_type_description(from)->structuredDes.enumeration)
    {
        #ifdef __SUNPRO_CC  // SunPro4.1 Compiler Note #1
            CppParse(Type)::reInit(from);
            // Do we need a special reInit to deal with _fields ?
        #endif  // __SUNPRO_CC
            CppParse(EnumeratorListIter) enumeratorListIter(enumerators());
        const CppParse(Enumerator) * enumerator;
        while ((enumerator = enumeratorListIter.next()) != NULL)
            CONST_CAST(CppParse_(Enumerator)*, enumerator)->resetName(scope());
    }

#ifdef _MSC_VER
    #pragma warning(default: 4355)
#endif  // _MSC_VER

const CppParse(EnumeratorList) &
CppParse(Enumeration)::
enumerators () const {
  return _enums;
}

#ifdef _MSC_VER  // MSVC4.1 Compiler Note #1
  #pragma warning(disable: 4355)
#endif  // _MSC_VER
  
  CppParse(Sequence)::
  CppParse_(Sequence) (::iluptype::Type from)
  : CppParse(Type)(CppParse_(SequenceFactory)::noteAllocated(this, from)),
    CppParseName(Name)(from),
    CppParseName(TypeName)(from),
    _elementType(CppParse_(TypeFactory)::findOrCreate(iluptype::_type_description(from)->structuredDes.sequence.type))
  {
    #ifdef __SUNPRO_CC  // SunPro4.1 Compiler Note #1
      CppParse(Type)::reInit(from);
      // Do we need a special reInit to deal with _members ?
    #endif  // __SUNPRO_CC
  }

#ifdef _MSC_VER
  #pragma warning(default: 4355)
#endif  // _MSC_VER

#ifdef __SUNPRO_CC  // See note in cppparse.hpp

    void
    CppParse(Sequence)::
    reInit (::iluptype::Type type) {
        CppParse_(Type)::reInit(type);
    }

#endif  // __SUNPRO_CC

long unsigned
CppParse(Sequence)::
limit () const {
    return iluptype::_type_description(_from)->structuredDes.sequence.limit;
};

const CppParse(Type) *
CppParse(Sequence)::
elementType () const {
    return _elementType;
}

/* TMP 7/7
ILUCPP_BOOL
CppParse(Sequence)::
isPtr (CppParseName(TypeUsage) usage) const {
    return usage == CppParseName(out) || usage == CppParseName(returnVal);
}
*/

CppParse(Indirection)  // TMP 7/7: NEW
CppParse(Sequence)::  // TMP 7/7: NEW
indirection (CppParseName(TypeUsage) usage) const {  // TMP 7/7: NEW
    return (usage == CppParseName(out) || usage == CppParseName(returnVal)  // TMP 7/7: NEW
        ? CppParse_(pointer)  // TMP 7/7: NEW
        : CppParse_(direct));  // TMP 7/7: NEW
}  // TMP 7/7: NEW

ILUCPP_BOOL
CppParse(Sequence)::
variableLength () const {
    return ILUCPP_TRUE;
}


struct InternalTypeEnumProcState {
    CppParse(TypeEnumProc) targetProc;
    void * targetState;
    unsigned sweep;
    ILUCPP_BOOL proceed;
    static InternalTypeEnumProcState instance;  // we only use one
};

InternalTypeEnumProcState InternalTypeEnumProcState::instance;

static ILUCPP_BOOL typeEnumerationInProgress = ILUCPP_FALSE;

static  // TMP 7/23: NEW
ILUCPP_BOOL
internalTypeEnumProc (const CppParse(Type) * type, void * untyped_state) {  // TMP 7/25
// CppParse::TypeEnumProc

    InternalTypeEnumProcState *const state = STATIC_CAST(InternalTypeEnumProcState*, untyped_state);
    ILUCPP_BOOL rtn = ILUCPP_TRUE;

    // 1st recursive sweep through contained types: execute proc, marking each type as we visit it
    if (state->sweep == 1) {
        if (type->_from->marked)  // We've visited this type before; stop recursion
            rtn = ILUCPP_FALSE;
        else {
            type->_from->marked = ILUCPP_TRUE;  // Mark type as having been visited
            state->proceed = state->targetProc(type, state->targetState);  // Call the proc
        };
    }

    // 2nd (final) (recursive) sweep: unmark previously marked types
    else {
        rtn = type->_from->marked;
        type->_from->marked = ILUCPP_FALSE;
    };

    return rtn;
}

static  // TMP 7/28: NEW
void
enumerateContainedTypes (const CppParse(Type) * contained, CppParse(TypeEnumProc) proc, void * state) {

    InternalTypeEnumProcState& internalState = InternalTypeEnumProcState::instance;

    //  If this is the "top-level", setup internal state record
    if (proc != internalTypeEnumProc) {
        // If an enumeration is already in progress (nested enumerations), do nothing
        if (typeEnumerationInProgress)
            goto done;
        typeEnumerationInProgress = ILUCPP_TRUE;
        internalState.targetProc = proc;
        internalState.targetState = state;
        internalState.sweep = 1;
        internalState.proceed = ILUCPP_TRUE;
    };

    // For each member, call proc & recurse
    if (internalTypeEnumProc(contained, &internalState) && internalState.proceed)
        contained->enumerateContained(internalTypeEnumProc, &internalState);  // recursion

    // If this is the top level, initiate the second sweep (unmark types)
    if (proc != internalTypeEnumProc) {
        internalState.sweep = 2;
        internalState.proceed = ILUCPP_TRUE;
        if (internalTypeEnumProc(contained, &internalState))
            contained->enumerateContained(internalTypeEnumProc, &internalState);  // recursion
        typeEnumerationInProgress = ILUCPP_FALSE;
    };

done: ;
}

static  // TMP 7/28: NEW
void
enumerateContainedTypes (const CppParse(MemberList) & contained, CppParse(TypeEnumProc) proc, void * state) {

    InternalTypeEnumProcState& internalState = InternalTypeEnumProcState::instance;
    CppParse(MemberListIter) memberListIter(contained);
    const CppParse(Member) * member;

    //  If this is the "top-level", setup internal state record
    if (proc != internalTypeEnumProc) {
        // If an enumeration is already in progress (nested enumerations), do nothing
        if (typeEnumerationInProgress)
            goto done;
        typeEnumerationInProgress = ILUCPP_TRUE;
        internalState.targetProc = proc;
        internalState.targetState = state;
        internalState.sweep = 1;
        internalState.proceed = ILUCPP_TRUE;
    };

    // For each member, call proc & recurse
    while (internalState.proceed && (member = memberListIter.next()) != NULL) {
        if (internalTypeEnumProc(member->type(), &internalState) && internalState.proceed)
            member->type()->enumerateContained(internalTypeEnumProc, &internalState);  // recursion
    };

    // If this is the top level, initiate the second sweep (unmark types)
    if (proc != internalTypeEnumProc) {
        internalState.sweep = 2;
        internalState.proceed = ILUCPP_TRUE;
        memberListIter.reset();
        while ((member = memberListIter.next()) != NULL) {
            if (internalTypeEnumProc(member->type(), &internalState))
                member->type()->enumerateContained(internalTypeEnumProc, &internalState);  // recursion
        };
        typeEnumerationInProgress = ILUCPP_FALSE;
    };

done: ;
}


void  // TMP 7/23: NEW
CppParse(Sequence)::
enumerateContained (CppParse_(TypeEnumProc) proc, void * state) const {
    ::enumerateContainedTypes(elementType(), proc, state);
}


#ifdef _MSC_VER  // MSVC4.1 Compiler Note #1
  #pragma warning(disable: 4355)
#endif  // _MSC_VER
  
  CppParse(String)::
  CppParse_(String) (::iluptype::Type from)
  : CppParse(Type)(CppParse_(StringFactory)::noteAllocated(this, from)),
    CppParseName(Name)(from),
    CppParseName(TypeName)(from),
    CppParse(Sequence)(from)
  {
    #ifdef __SUNPRO_CC  // SunPro4.1 Compiler Note #1
      CppParse(Type)::reInit(from);
      // Do we need a special reInit to deal with _members ?
    #endif  // __SUNPRO_CC
  }

#ifdef _MSC_VER
  #pragma warning(default: 4355)
#endif  // _MSC_VER

/* TMP 7/7
ILUCPP_BOOL
CppParse(String)::
isPtr () const {
    return ILUCPP_TRUE;
}

ILUCPP_BOOL
CppParse(String)::
isPtr (CppParseName(TypeUsage)) const {
    return ILUCPP_TRUE;
}
*/

CppParse(Indirection)  // TMP 7/7: NEW
CppParse(String)::  // TMP 7/7: NEW
indirection () const {  // TMP 7/7: NEW
    return CppParse_(pseudoPointer);  // TMP 7/7: NEW
}  // TMP 7/7: NEW

CppParse(Indirection)  // TMP 7/7: NEW
CppParse(String)::  // TMP 7/7: NEW
indirection (CppParseName(TypeUsage)) const {  // TMP 7/7: NEW
    return CppParse_(pseudoPointer);  // TMP 7/7: NEW
}  // TMP 7/7: NEW

#ifdef _MSC_VER  // MSVC4.1 Compiler Note #1
  #pragma warning(disable: 4355)
#endif  // _MSC_VER
  
  CppParse(WideString)::
  CppParse_(WideString) (::iluptype::Type from)
  : CppParse(Type)(CppParse_(WideStringFactory)::noteAllocated(this, from)),
    CppParseName(Name)(from),
    CppParseName(TypeName)(from),
    CppParse(Sequence)(from)
  {
    #ifdef __SUNPRO_CC  // SunPro4.1 Compiler Note #1
      CppParse(Type)::reInit(from);
      // Do we need a special reInit to deal with _members ?
    #endif  // __SUNPRO_CC
  }

#ifdef _MSC_VER
  #pragma warning(default: 4355)
#endif  // _MSC_VER

/* TMP 7/7
ILUCPP_BOOL
CppParse(WideString)::
isPtr () const {
    return ILUCPP_TRUE;
}

ILUCPP_BOOL
CppParse(WideString)::
isPtr (CppParseName(TypeUsage)) const {
    return ILUCPP_TRUE;
}
*/

CppParse(Indirection)  // TMP 7/7: NEW
CppParse(WideString)::  // TMP 7/7: NEW
indirection () const {  // TMP 7/7: NEW
    return CppParse_(pseudoPointer);  // TMP 7/7: NEW
}  // TMP 7/7: NEW

CppParse(Indirection)  // TMP 7/7: NEW
CppParse(WideString)::  // TMP 7/7: NEW
indirection (CppParseName(TypeUsage)) const {  // TMP 7/7: NEW
    return CppParse_(pseudoPointer);  // TMP 7/7: NEW
}  // TMP 7/7: NEW


#ifdef _MSC_VER  // MSVC4.1 Compiler Note #1
  #pragma warning(disable: 4355)
#endif  // _MSC_VER
  
  CppParse(ObjectSequence)::
  CppParse_(ObjectSequence) (::iluptype::Type from)
  : CppParse(Type)(CppParse_(ObjectSequenceFactory)::noteAllocated(this, from)),
    CppParseName(Name)(from),
    CppParseName(TypeName)(from),
    CppParse(Sequence)(from)
  {
    #ifdef __SUNPRO_CC  // SunPro4.1 Compiler Note #1
      CppParse(Type)::reInit(from);
      // Do we need a special reInit to deal with _members ?
    #endif  // __SUNPRO_CC
  }

#ifdef _MSC_VER
  #pragma warning(default: 4355)
#endif  // _MSC_VER


#ifdef _MSC_VER  // MSVC4.1 Compiler Note #1
  #pragma warning(disable: 4355)
#endif  // _MSC_VER
  
  CppParse(StringSequence)::
  CppParse_(StringSequence) (::iluptype::Type from)
  : CppParse(Type)(CppParse_(StringSequenceFactory)::noteAllocated(this, from)),
    CppParseName(Name)(from),
    CppParseName(TypeName)(from),
    CppParse(Sequence)(from)
  {
    #ifdef __SUNPRO_CC  // SunPro4.1 Compiler Note #1
      CppParse(Type)::reInit(from);
      // Do we need a special reInit to deal with _members ?
    #endif  // __SUNPRO_CC
  }

#ifdef _MSC_VER
  #pragma warning(default: 4355)
#endif  // _MSC_VER


#ifdef _MSC_VER  // MSVC4.1 Compiler Note #1
  #pragma warning(disable: 4355)
#endif  // _MSC_VER
  
  CppParse(WideStringSequence)::
  CppParse_(WideStringSequence) (::iluptype::Type from)
  : CppParse(Type)(CppParse_(WideStringSequenceFactory)::noteAllocated(this, from)),
    CppParseName(Name)(from),
    CppParseName(TypeName)(from),
    CppParse(Sequence)(from)
  {
    #ifdef __SUNPRO_CC  // SunPro4.1 Compiler Note #1
      CppParse(Type)::reInit(from);
      // Do we need a special reInit to deal with _members ?
    #endif  // __SUNPRO_CC
  }

#ifdef _MSC_VER
  #pragma warning(default: 4355)
#endif  // _MSC_VER


/* TMP 7/5
template <class T, class FROM>
TEMPLATE_STATIC
ILUCPP_BOOL
containsVariables (const CppParse_ListT<T, FROM>& list) {
    CppParse_ListIterT<T, FROM> iter(list);
    ILUCPP_BOOL rtn = ILUCPP_FALSE;
    const T * t;
    while (((t = iter.next()) != NULL) && (! (rtn = t->type()->variableLength())));
    return rtn;
}
*/



#ifdef _MSC_VER  // MSVC4.1 Compiler Note #1
    #pragma warning(disable: 4355)
#endif  // _MSC_VER
  
    CppParse(Record)::
    CppParse_(Record) (::iluptype::Type from)
    :   CppParse(Type)(CppParse_(RecordFactory)::noteAllocated(this, from)),
        CppParseName(Scope)(
            from->name,
            CppParse_(InterfaceFactory)::findOrCreate(from->interface)),
        CppParseName(Name)(from),
        CppParseName(TypeName)(from),
        _members(
            (iluptype::_type_kind(from) == iluptype::union_Type)
                ? iluptype::_type_description(from)->structuredDes.uniond.types
                : iluptype::_type_description(from)->structuredDes.record.fields
        )
// TMP 7/5        _variableLength(containsVariables(_members))
    {
        #ifdef __SUNPRO_CC  // SunPro4.1 Compiler Note #1
            CppParse(Type)::reInit(from);
            // Do we need a special reInit to deal with _members ?
        #endif  // __SUNPRO_CC
        CppParse(MemberListIter) memberListIter(members());
        const CppParse(Member) * member;
        while ((member = memberListIter.next()) != NULL)
            CONST_CAST(CppParse_(Member)*, member)->resetName(this);
    }

#ifdef _MSC_VER
    #pragma warning(default: 4355)
#endif  // _MSC_VER


#include "cppgen.hpp"  // TMP 7/20
  
/* TMP 7/21
void *
CppParse(Record)::  // TMP 7/20
operator new (size_t nbytes, ::iluptype::Type from) {  // TMP 7/20
    size_t sizeParseRecord = sizeof(CppParse(Record));  // TMP 7/20
    size_t sizeGenRecord = sizeof(CppGen(Record));  // TMP 7/20
// TMP 7/20    void * rtn = ::new char[nbytes];  // TMP 7/20
// TMP 7/20    void * rtn = ::new long[nbytes];  // TMP 7/20
    CppGen(Record) * allocatedAsGenRec = new CppGen(Record)(from, 42);  // TMP 7/20
    void * rtn = allocatedAsGenRec;  // TMP 7/20
    CppGen(Record) * genRec = STATIC_CAST(CppGen(Record)*, rtn);  // TMP 7/20
    CppParse(Record) *parseRec = genRec;  // TMP 7/20
    CppParse_(RecordFactory)::noteAllocated(CppGen(Record)::convert(rtn), from);  // TMP 7/20
    return rtn;  // TMP 7/20
}  // TMP 7/20
*/

char * tmpbuffer = new char[1000];  // TMP 8/15

void *  // TMP 7/21
CppParse(Record)::  // TMP 7/20
operator new (size_t nbytes, ::iluptype::Type from) {  // TMP 7/20
    void * rtn = new char[nbytes];  // TMP 7/20: does new'd buffer properly aligned ?
// TMP 8/17    rtn = tmpbuffer;  // TMP 8/15
    CppParse_(Record) * rec = STATIC_CAST(CppParse_(Record)*, rtn);  // TMP 8/15
    const  ::iluptype::Type * rec_from = REINTERPRET_CAST(::iluptype::Type*, rec);  // TMP 8/15
    *CONST_CAST(::iluptype::Type*, rec_from) = from;  // TMP 8/15
    CppParse_(RecordFactory)::noteAllocated(STATIC_CAST(CppParse_(Record)*, rtn), from);  // TMP 7/20
	    return rtn;  // TMP 7/20
}  // TMP 7/20


CppParse(Record) *  // TMP 7/20
CppParse_FactoryT<CppParse(Record), ::iluptype::Type>::  // TMP 7/20
_create (::iluptype::Type) const {  // TMP 7/20
    cout << "Oops !  Entering CppParse::RecordFactory::_create ..." << endl;  // TMP 7/20
    return NULL;  // TMP 7/20
}


const CppParse(MemberList) &
CppParse(Record)::
members () const {
  return _members;
}

/* TMP 7/7
ILUCPP_BOOL
CppParse(Record)::
isPtr (CppParseName(TypeUsage) usage) const {
    return variableLength() && (usage == CppParseName(out) || usage == CppParseName(returnVal));
}
*/

CppParse(Indirection)  // TMP 7/7: NEW
CppParse(Record)::  // TMP 7/7: NEW
indirection (CppParseName(TypeUsage) usage) const {  // TMP 7/7: NEW
    return (variableLength() && (usage == CppParseName(out) || usage == CppParseName(returnVal))  // TMP 7/7: NEW
        ? CppParse_(pointer)  // TMP 7/7: NEW
        : CppParse_(direct));  // TMP 7/7: NEW
}  // TMP 7/7: NEW

/* TMP 7/5
ILUCPP_BOOL
CppParse(Record)::
variableLength () const {
    return _variableLength;
}
*/

/* TMP 7/27
ILUCPP_BOOL  // TMP 7/5: NEW
CppParse(Record)::
variableLength () const {
    CppParse_(MemberListIter) memberListIter(members());
    const CppParse_(Member) * member;
    ILUCPP_BOOL rtn = ILUCPP_FALSE;
    while ((member = memberListIter.next()) != NULL && !(rtn = member->type()->variableLength()));
    return rtn;
}
*/

ILUCPP_BOOL  // TMP 7/27: NEW
CppParse(Record)::
variableLength () const {
    ILUCPP_BOOL rtn = ILUCPP_FALSE;
    enumerateContained(variableLengthTypeEnumProc, &rtn);
    return rtn;
}

void  // TMP 7/23: NEW
CppParse(Record)::
enumerateContained (CppParse_(TypeEnumProc) proc, void * state) const {
    ::enumerateContainedTypes(members(), proc, state);
}


/* TMP 6/7
void mylist_sort (::iluptype::list l, ::iluptype::iluparser_CompareProc fn)
// TMP 4/20: Copy this from ilu.bison, in order to more easily debug it
{
  ::iluptype::listElement *current, *next, *prev;
  int count = iluptype::_list_size(l);
  int index;
  ::iluptype::boolean stable = FALSE;

//  while (!stable && count > 2)
  while (!stable && count > 1)
    {
      count -= 1;
      for (stable = TRUE, prev = NULL, current = NULL, next = l->head, index = 0;
	   next != NULL && index <= count;
	   prev = current, current = next, next = current->next, index++)
	{
	  if (current != NULL)
	    {
	      if ((*fn)(current->data, next->data))
		{
		  if (prev == NULL)
		    l->head = next;
		  else
		    prev->next = next;
		  current->next = next->next;
		  next->next = current;
		  current = next;
		  next = next->next;
		  stable = FALSE;
		}
	    }
	}
      count += 1;
    }
}
*/


#ifdef _MSC_VER  // MSVC4.1 Compiler Note #1
    #pragma warning(disable: 4355)
#endif  // _MSC_VER
  
    CppParse(UnionArm)::
    CppParse_(UnionArm) (::iluptype::Argument from)
      : CppParse(NamedValue)(from, CppParseName(unionMember)),
        CppParse_(Member)(CppParse(UnionArmFactory)::noteAllocated(this, from)),
        _values(from->values),
		_index(0)  // Real value will be supplied by Union's constructor
    {
    }

#ifdef _MSC_VER
    #pragma warning(default: 4355)
#endif  // _MSC_VER

long unsigned
CppParse(UnionArm)::
index () const {
	return _index;
}

const CppParse(ConstantValueList) &
CppParse(UnionArm)::
values () const {
    return _values;
}

const CppParse(ConstantValue) *
CppParse(UnionArm)::
firstValue () const {
    return (values().count() == 0
        ? CppParse_(Union)::narrow(scope())->_firstUnspecifiedValue
        : CppParse_(ConstantValueListIter)(values()).next()
    );
}


static
void
catValueListsEnumProc (::iluptype::ConstantValue cv, ::iluptype::list allSpecifiedValues) {
// ::iluptype::iluparser_EnumProc
    iluptype::_list_insert(allSpecifiedValues, cv);
}

static
void
catArgumentValueListsEnumProc (::iluptype::Argument arg, ::iluptype::list allSpecifiedValues) {
// ::iluptype::iluparser_EnumProc
    if (arg->values != NULL) {
        iluptype::_list_enumerate(
            arg->values,  // list to enumerate
            REINTERPRET_CAST(::iluptype::iluparser_EnumProc, catValueListsEnumProc),
            allSpecifiedValues  // caller state
        );
    };
}

static
::iluptype::boolean
valueCompareProc (::iluptype::ConstantValue cv1, ::iluptype::ConstantValue cv2) {
// ::iluptype::iluparser_CompareProc
    ::iluptype::boolean rtn = 0;
    if (cv1->type == cv2->type) {  // should be unnecessary to check, but just in case
        switch (cv1->type) {
        case iluptype::boolean_Type:
            rtn = (cv1->val.b > cv2->val.b);
            break;
        case iluptype::integer_Type:
            rtn = (cv1->val.i.value > cv2->val.i.value);
            break;
        default:
            break;
        }
    };
    return rtn;
}

static
::iluptype::boolean
firstUnspecifiedValueFindProc (::iluptype::ConstantValue cv, ::iluptype::ConstantValue firstUnspecified) {
// ::iluptype::iluparser_FindProc
    ::iluptype::boolean found = 0;
    if (cv != NULL) {
        switch (firstUnspecified->type) {
        case iluptype::integer_Type:
            if (!(found = (firstUnspecified->val.i.value < cv->val.i.value)))
                firstUnspecified->val.i.value = cv->val.i.value + 1;
            break;
        case iluptype::boolean_Type:
            if (!(found = (firstUnspecified->val.b < cv->val.b)))
                firstUnspecified->val.b = cv->val.b + 1;
            break;
        case iluptype::shortcharacter_Type:
			found = (strcmp(firstUnspecified->val.s, cv->val.s) == 0);
            break;
        default:
            break;
        };
    };
    return found;
}

static
const CppParse(ConstantValue) *
makeUnionFirstUnspecifiedValue (::iluptype::Type discriminatorType, ::iluptype::list arms, ::iluptype::Argument defaultArm) {
    ::iluptype::ConstantValue firstUnspecified = new ::iluptype::ilu_constantvalue_s;
    ::iluptype::list allSpecifiedValues = iluptype::_iluparser_new_list();  // list of ::iluptype::ConstantValue
    firstUnspecified->type = iluptype::_type_kind(discriminatorType);
    switch (iluptype::_type_ur_kind(discriminatorType)) {
    case iluptype::integer_Type:
    case iluptype::shortinteger_Type:
    case iluptype::cardinal_Type:
    case iluptype::shortcardinal_Type:
    case iluptype::byte_Type:
        firstUnspecified->type = iluptype::integer_Type;
        firstUnspecified->val.i.value = 0;
        break;
    case iluptype::boolean_Type:
        firstUnspecified->type = iluptype::boolean_Type;
        firstUnspecified->val.b = 0;
        break;
    case iluptype::enumeration_Type:  // TMP 9/7: NEW
        firstUnspecified->type = iluptype::shortcharacter_Type;
        firstUnspecified->val.s = NULL;
        break;
    default:  // shouldn't happen (integer types and booleans are only legal union descriptor types)
        break;
    };
	// Make a list containing all values found in all arms
    iluptype::_list_enumerate(
        arms,  // list to enumerate
        REINTERPRET_CAST(::iluptype::iluparser_EnumProc, catArgumentValueListsEnumProc),
        allSpecifiedValues  // caller state
    );
/* TMP 9/7
	// Sort the list of found values
	iluptype::_list_sort(
		allSpecifiedValues,  // list to sort
		REINTERPRET_CAST(::iluptype::iluparser_CompareProc, valueCompareProc)
	);
    /*iluptype::_list_find TMP 8/15*//*my_list_find(
        allSpecifiedValues,  // list to enumerate
        REINTERPRET_CAST(::iluptype::iluparser_FindProc, firstUnspecifiedValueFindProc),
        firstUnspecified  // caller state
    );
TMP 9/7 */
	if (iluptype::_type_ur_kind(discriminatorType) == iluptype::enumeration_Type) {  // TMP 9/7: NEW
		// For each enumerator tag, enumerate the list of found values until
		// reaching an enumerator that's not present in the list
		::iluptype::list enumerators = iluptype::_type_description(discriminatorType)->structuredDes.enumeration;
		for (::iluptype::cardinal i = 0; i < iluptype::_list_size(enumerators); i++) {
			::iluptype::refany matchingValue;
			firstUnspecified->val.s = REINTERPRET_CAST(::iluptype::EnumField, iluptype::_list_ref(enumerators, i))->name;
			matchingValue = iluptype::_list_find(
				allSpecifiedValues,  // list to enumerate
				REINTERPRET_CAST(::iluptype::iluparser_FindProc, firstUnspecifiedValueFindProc),
				firstUnspecified  // caller state
			);
			if (matchingValue == NULL)
				break;
		};
	}
	else {
		iluptype::_list_sort(
			allSpecifiedValues,  // list to sort
			REINTERPRET_CAST(::iluptype::iluparser_CompareProc, valueCompareProc)
		);
		// Enumerate the (sorted) list of found values until a "hole" is found;
		// firstUnspecified gets the value that would belong in the "hole", or one
		// more than the last value in the list if there are no holes.
		// Sort the list of found values
		/*iluptype::_list_find TMP 8/15*/my_list_find(
			allSpecifiedValues,  // list to enumerate
			REINTERPRET_CAST(::iluptype::iluparser_FindProc, firstUnspecifiedValueFindProc),
			firstUnspecified  // caller state
		);
	};
    iluptype::_list_clear(allSpecifiedValues, 0);
    return CppParse(ConstantValueFactory)::findOrCreate(firstUnspecified);
}


#ifdef _MSC_VER  // MSVC4.1 Compiler Note #1
    #pragma warning(disable: 4355)
#endif  // _MSC_VER
  
    CppParse(Union)::
    CppParse_(Union) (::iluptype::Type from)
    :   CppParse(Type)(CppParse_(UnionFactory)::noteAllocated(this, from)),
        CppParse(Record)(from),
        CppParseName(Name)(from),
        CppParseName(TypeName)(from),
        _discriminatorType(CppParse_(TypeFactory)::findOrCreate(
            iluptype::_type_description(from)->structuredDes.uniond.discriminator_type)),
        _defaultArm(iluptype::_type_description(from)->structuredDes.uniond.default_arm == NULL
            ? NULL
            : CppParse_(UnionArmFactory)::findOrCreate(iluptype::_type_description(from)->structuredDes.uniond.default_arm)
        ),
        _otherDiscriminatorValuesOK(
            (iluptype::_type_description(from)->structuredDes.uniond.others_allowed)
                ? ILUCPP_TRUE
                : ILUCPP_FALSE
        ),
        _firstUnspecifiedValue(makeUnionFirstUnspecifiedValue(
            iluptype::_type_description(from)->structuredDes.uniond.discriminator_type,
            iluptype::_type_description(from)->structuredDes.uniond.types,
            iluptype::_type_description(from)->structuredDes.uniond.default_arm)
        )
    {
		/* TEMP: The following is a hack to set the _type field in the arms' constant values,  // TMP 9/7: NEW
		   and the _index field. Needed because CppParse::ConstantValue's constructor has no
		   way to find the type, and CppParse::UnionArm's constructor has no (easy) way to
		   determine index.
		*/
		const CppParse_(UnionArm)* arm;
		CppParse_(MemberListIter) memberListIter = arms();
		long unsigned index = 0;
		while ((arm = CppParse_(UnionArm)::narrow(memberListIter.next())) != NULL) {
			const CppParse_(ConstantValue) * value;
			CppParse_(ConstantValueListIter) valueListIter = arm->values();
			while ((value = valueListIter.next()) != NULL) {
				CONST_CAST(CppParse_(ConstantValue)*, value)->_type = _discriminatorType;
			};
			*CONST_CAST(long unsigned*, &arm->_index) = index;
			index++;
		};
		CONST_CAST(CppParse_(ConstantValue)*, _firstUnspecifiedValue)->_type = _discriminatorType;
    }

#ifdef _MSC_VER
    #pragma warning(default: 4355)
#endif  // _MSC_VER


#include "cppgen.hpp"  // TMP 7/20
  
void *
CppParse(Union)::  // TMP 7/20
operator new (size_t nbytes, ::iluptype::Type from) {  // TMP 7/20
    void * rtn = ::new char[nbytes];  // TMP 7/20
    CppParse_(UnionFactory)::noteAllocated(CppGen(Union)::convert(rtn), from);  // TMP 7/20
    return rtn;  // TMP 7/20
}  // TMP 7/20


CppParse(Union) *  // TMP 7/20
CppParse_FactoryT<CppParse(Union), ::iluptype::Type>::  // TMP 7/20
_create (::iluptype::Type) const {  // TMP 7/20
    cout << "Oops !  Entering CppParse::UnionFactory::_create ..." << endl;  // TMP 7/20
    return NULL;  // TMP 7/20
}


const CppParse(Type) *
CppParse(Union)::
discriminatorType () const {
    return _discriminatorType;
}

const CppParse(UnionArm) *
CppParse(Union)::
defaultArm () const {
    return _defaultArm;
}

ILUCPP_BOOL
CppParse(Union)::
otherDiscriminatorValuesOK () const {
    return _otherDiscriminatorValuesOK;
}


#ifdef _MSC_VER  // MSVC4.1 Compiler Note #1
    #pragma warning(disable: 4355)
#endif  // _MSC_VER
  
    CppParse(Alias)::
    CppParse_(Alias) (::iluptype::Type from)
      : CppParse(Type)(CppParse_(AliasFactory)::noteAllocated(this, from)),
        CppParseName(TypeName)(from),
        CppParseName(Name)(from),
        CppParseName(AliasName)(from),
        _urType(CppParse_(TypeFactory)::findOrCreate(iluptype::_ur_type(from)))
    {
        #ifdef __SUNPRO_CC  // SunPro4.1 Compiler Note #1
            CppParse(Type)::reInit(from);
        #endif  // __SUNPRO_CC
    }

#ifdef _MSC_VER
    #pragma warning(default: 4355)
#endif  // _MSC_VER

#ifdef _MSC_VER  // MSVC4.1 Compiler Note #1
    #pragma warning(disable: 4355)
#endif  // _MSC_VER
  
    CppParse(ConstantValue)::
    CppParse_(ConstantValue) (::iluptype::ConstantValue from)
    :   CppParse_CreatableT< ::iluptype::ConstantValue>(CppParse(ConstantValueFactory)::noteAllocated(this, from))
    {
    }

const CppParse(Type) *
CppParse(Alias)::
urType () const {
    return _urType;
}

void  // TMP 7/23: NEW
CppParse(Alias)::
enumerateContained (CppParse_(TypeEnumProc) proc, void * state) const {
    ::enumerateContainedTypes(urType(), proc, state);
}


#ifdef _MSC_VER
    #pragma warning(default: 4355)
#endif  // _MSC_VER

const char *
CppParse(ConstantValue)::
str (const CppParseName(Scope) * context) const {
    const char * rtn;
    static ReusableString work;
    switch (_from->type) {
    case iluptype::integer_Type:
    case iluptype::shortinteger_Type:
    case iluptype::cardinal_Type:
    case iluptype::shortcardinal_Type:
    case iluptype::byte_Type:
        work.strcpy((_from->val.i.sign < 0) ? "-" : "");
        work.ucat(_from->val.i.value);
        rtn = work.str;
        break;
    case iluptype::boolean_Type:
        rtn = _from->val.b ? CppParse_(Bool)::trueValue() : CppParse_(Bool)::falseValue();
        break;
    case iluptype::shortcharacter_Type:
// TMP 9/7        rtn = _from->val.s;
		if (CppParse_(Enumeration)::narrow(_type->urType()) != NULL) {  // TMP 9/7: NEW
			static ReusableString work;
			work.strcpy(CppParseName(TempName)(_from->val.s, _type->urType()->scope()).name(context));
			rtn = work.str;
		}
		else
			rtn = _from->val.s;
        break;
    default:
        break;
    };
    return rtn;
}

const char *  // TMP 9/10: NEW
CppParse(ConstantValue)::
typeKindName (ILUCPP_BOOL mixed_case) const {
    return TypeKindTable::name(_from->type, mixed_case);
}


#ifdef _MSC_VER  // MSVC4.1 Compiler Note #1
  #pragma warning(disable: 4355)
#endif  // _MSC_VER
  
  CppParse(ArrayDimension)::
  CppParse_(ArrayDimension) (long unsigned from)
  : CppParse_CreatableT<long unsigned>(CppParse(ArrayDimensionFactory)::noteAllocated(this, from)) {
  }

#ifdef _MSC_VER
  #pragma warning(default: 4355)
#endif  // _MSC_VER

long unsigned
CppParse(ArrayDimension)::
length () const {
    return _from;
};


#ifdef _MSC_VER  // MSVC4.1 Compiler Note #1
  #pragma warning(disable: 4355)
#endif  // _MSC_VER
  
  CppParse(Array)::
  CppParse_(Array) (::iluptype::Type from)
  : CppParse(Type)(CppParse_(ArrayFactory)::noteAllocated(this, from)),
    CppParseName(Name)(from),
    CppParseName(TypeName)(from),
    _dimensions(iluptype::_type_description(from)->structuredDes.array.dimensions),
    _elementType(CppParse_(TypeFactory)::findOrCreate(iluptype::_type_description(from)->structuredDes.array.type))
// TMP 7/5    _variableLength(elementType()->variableLength())
  {
    #ifdef __SUNPRO_CC  // SunPro4.1 Compiler Note #1
      CppParse(Type)::reInit(from);
      // Do we need a special reInit to deal with _members ?
    #endif  // __SUNPRO_CC
  }

#ifdef _MSC_VER
  #pragma warning(default: 4355)
#endif  // _MSC_VER


const CppParse(ArrayDimensionList) &
CppParse(Array)::
dimensions () const {
    return _dimensions;
}

const CppParse(Type) *
CppParse(Array)::
elementType () const {
    return _elementType;
}

/* TMP 7/7
ILUCPP_BOOL
CppParse(Array)::
isPtr (CppParseName(TypeUsage) usage) const {
    return (usage == CppParseName(returnVal)) || (variableLength() && usage == CppParseName(out));
}
*/

CppParse(Indirection)  // TMP 7/7: NEW
CppParse(Array)::  // TMP 7/7: NEW
indirection (CppParseName(TypeUsage) usage) const {  // TMP 7/7: NEW
    return ((usage == CppParseName(returnVal)) || (variableLength() && usage == CppParseName(out)))  // TMP 7/7: NEW
        ? CppParse_(pointer)  // TMP 7/7: NEW
        : CppParse_(direct);  // TMP 7/7: NEW
}  // TMP 7/7: NEW

/* TMP 7/27
ILUCPP_BOOL
CppParse(Array)::
variableLength () const {
// TMP 7/5    return _variableLength;
    return elementType()->variableLength();  // TMP 7/5: NEW
}
*/

ILUCPP_BOOL  // TMP 7/27: NEW
CppParse(Array)::
variableLength () const {
    ILUCPP_BOOL rtn = ILUCPP_FALSE;
    enumerateContained(variableLengthTypeEnumProc, &rtn);
    return rtn;
}

void  // TMP 7/23: NEW
CppParse(Array)::
enumerateContained (CppParse_(TypeEnumProc) proc, void * state) const {
    ::enumerateContainedTypes(elementType(), proc, state);
}


#ifdef _MSC_VER  // MSVC4.1 Compiler Note #1
  #pragma warning(disable: 4355)
#endif  // _MSC_VER
  
  CppParse(Optional)::
  CppParse_(Optional) (::iluptype::Type from)
  : CppParse(Type)(CppParse_(OptionalFactory)::noteAllocated(this, from)),
    CppParseName(Name)(from),
    CppParseName(TypeName)(from),
    _valueType(CppParse_(TypeFactory)::findOrCreate(iluptype::_type_description(from)->structuredDes.optional))
  {
    #ifdef __SUNPRO_CC  // SunPro4.1 Compiler Note #1
      CppParse(Type)::reInit(from);
      // Do we need a special reInit to deal with _members ?
    #endif  // __SUNPRO_CC
  }

#ifdef _MSC_VER
  #pragma warning(default: 4355)
#endif  // _MSC_VER

const CppParse(Type) *
CppParse(Optional)::
valueType () const {
    return _valueType;
}

/* TMP 7/7
ILUCPP_BOOL
CppParse(Optional)::
isPtr () const {
    return ILUCPP_TRUE;
}

ILUCPP_BOOL
CppParse(Optional)::
isPtr (CppParseName(TypeUsage)) const {
    return ILUCPP_TRUE;
}
*/

CppParse(Indirection)  // TMP 7/7: NEW
CppParse(Optional)::  // TMP 7/7: NEW
indirection () const {  // TMP 7/7: NEW
    return CppParse_(pseudoPointer);  // TMP 7/7: NEW
}  // TMP 7/7: NEW

CppParse(Indirection)  // TMP 7/7: NEW
CppParse(Optional)::  // TMP 7/7: NEW
indirection (CppParseName(TypeUsage)) const {  // TMP 7/7: NEW
    return CppParse_(pseudoPointer);  // TMP 7/7: NEW
}  // TMP 7/7: NEW

ILUCPP_BOOL
CppParse(Optional)::
variableLength () const {
    return ILUCPP_TRUE;
}

void  // TMP 7/23: NEW
CppParse(Optional)::
enumerateContained (CppParse_(TypeEnumProc) proc, void * state) const {
    ::enumerateContainedTypes(valueType(), proc, state);
}


#ifdef _MSC_VER
  #pragma warning(default: 4355)
#endif  // _MSC_VER


#ifdef _MSC_VER  // MSVC4.1 Compiler Note #1
  #pragma warning(disable: 4355)
#endif  // _MSC_VER
  
  CppParse(ExceptionValue)::
  CppParse_(ExceptionValue) (::iluptype::Exception from)
  :   CppParse_(NamedValue)(from),
    CppParse_(TMP)(CppParse_(ExceptionValueFactory)::noteAllocated(this, from)),
      CppParse_CreatableT< ::iluptype::Exception>(
      CppParse(ExceptionValueFactory)::noteAllocated(this, from)) {
  }

#ifdef _MSC_VER
  #pragma warning(default: 4355)
#endif  // _MSC_VER

#ifdef _MSC_VER  // MSVC4.1 Compiler Note #1
  #pragma warning(disable: 4355)
#endif  // _MSC_VER
  
  CppParse(Exception)::
  CppParse_(Exception) (::iluptype::Exception from)
  : CppParseName(Name)(
      CppParse(ExceptionFactory)::noteAllocated(this, from)->name,
      CppParse_(InterfaceFactory)::findOrCreate(from->interface)),
    CppParseName(Scope)(
      CppParse(ExceptionFactory)::noteAllocated(this, from)->name,
      CppParse(InterfaceFactory)::findOrCreate(from->interface)
    ),
          // TMP:  Needs to change for imported from
    CppParse_CreatableT< ::iluptype::Exception>(CppParse(ExceptionFactory)::noteAllocated(this, from)),
    _value((from->type == NULL)
        ? NULL
        : CppParse(ExceptionValueFactory)::findOrCreate(CppParse(ExceptionFactory)::noteAllocated(this, from))
    ) { // TEMP: check alloc
  }

#ifdef _MSC_VER
  #pragma warning(default: 4355)
#endif  // _MSC_VER

const CppParse(ExceptionValue) *
CppParse(Exception)::
value () const {
  return(_value);
}


#ifdef _MSC_VER  // MSVC4.1 Compiler Note #1
  #pragma warning(disable: 4355)
#endif  // _MSC_VER
  
CppParse(IDLException)::
  CppParse_(IDLException) (::iluptype::Exception from)
  : CppParseName(Name)(from),
    CppParse_(TMP)(from),
    CppParse_(Exception)(from)
  {
  }

#ifdef _MSC_VER
  #pragma warning(default: 4355)
#endif  // _MSC_VER


#include "cppgen.hpp"  // TMP 6/1
  
void *
CppParse(IDLException)::  // TMP 5/30
operator new (size_t nbytes, ::iluptype::Exception from) {  // TMP 5/30
    void * rtn = ::new char[nbytes];  // TMP 5/30
    CppParse_(IDLExceptionFactory)::noteAllocated(CppGen(IDLException)::convert(rtn), from);  // TMP 6/1
    return rtn;  // TMP 5/30
}  // TMP 5/30


CppParse(IDLException) *  // TMP 5/30
CppParse_FactoryT<CppParse(IDLException), ::iluptype::Exception>::  // TMP 5/30
_create (::iluptype::Exception) const {  // TMP 5/30
    cout << "Oops !  Entering CppParse::IDLExceptionFactory::_create ..." << endl;  // TMP 5/30
    return NULL;  // TMP 5/30
}


CppParse(Interface) *  // TMP 8/13
CppParse_FactoryT<CppParse(Interface), ::iluptype::Interface>::
_create (::iluptype::Interface) const {
    cout << "Oops !  Entering CppParse::InterfaceFactory::_create ..." << endl;
    return NULL;
}


template <class T, class FROM>
T *
CppParse_FactoryT<T, FROM>::
_create (FROM from) const {
  T * rtn = new T(from);  // TEMP
  return rtn;  // TEMP
}

template <class T, class FROM>
void
CppParse_FactoryT<T, FROM>::
_destroy (T * destroyMe) const {
  delete destroyMe;  // TEMP
}


CppParse(Type) *
CppParse_FactoryT<CppParse(Type), ::iluptype::Type>::
findOrCreate (::iluptype::Type from) {
    CppParse(Type) * rtn = NULL;
    #define FIND_OR_CREATE_CASE(T, IGNORE1, TYPE_KIND, IGNORE2, IGNORE3) \
        case TYPE_KIND:                                                  \
                rtn = CppParse(T ## Factory)::findOrCreate(from);        \
        break;
    if (from->importInterfaceName != NULL)  // TMP 6/12: NEW
        from = from->supertype;  // TMP 6/12: NEW
    if (from != NULL) {
/*// TMP 9/8*/        switch(iluptype::_type_kind(from)) {  // begin switch 0  // TEMP: is this right ?
//        switch(iluptype::_type_ur_kind(from)) {  // begin switch 0  // TMP 9/8: NEW

        // all typekinds except iluptype::sequence_Type
		CppParse_ENUMERATE_SCALAR_TYPES(FIND_OR_CREATE_CASE)
        CppParse_ENUMERATE_CONSTRUCTED_TYPES(FIND_OR_CREATE_CASE)

        case iluptype::sequence_Type: {

// TMP 9/7            switch(iluptype::_type_kind(iluptype::_type_description(from)->structuredDes.sequence.type)) {
			// what kind of sequence is this ? - check the element's ur_kind
			const ::iluptype::Type elementType = iluptype::_type_description(from)->structuredDes.sequence.type;  // TMP 9/8: NEW
            switch(iluptype::_type_ur_kind(elementType)) {  // begin switch 1 // TMP 9/7: NEW

			// sequence of character
            case iluptype::character_Type:
                rtn = CppParse(WideStringFactory)::findOrCreate(from);
                break;

            // sequence of short character
			case iluptype::shortcharacter_Type:
                rtn = CppParse(StringFactory)::findOrCreate(from);
                break;

            // sequence of object
			case iluptype::object_Type:
                rtn = CppParse(ObjectSequenceFactory)::findOrCreate(from);
                break;

			// sequence of sequences
            case iluptype::sequence_Type: {

///*
                // sequence of what kind of sequences ?  -- check the ur_kind of the element's ur_Type's element
				const ::iluptype::Type elementElementType = iluptype::_type_description(iluptype::_ur_type(elementType))->structuredDes.sequence.type;  // TMP 9/8: NEW
				switch(iluptype::_type_ur_kind(elementElementType)) {  // begin switch 2 // TMP 9/8: NEW

                // sequence of sequence of character
				case iluptype::character_Type:
					rtn = CppParse(WideStringSequenceFactory)::findOrCreate(from);
					break;

				// sequence of sequence of short character
				case iluptype::shortcharacter_Type:
					rtn = CppParse(StringSequenceFactory)::findOrCreate(from);
					break;

				// sequence of sequence of some other type
				default:
//*/
					rtn = CppParse(SequenceFactory)::findOrCreate(from);
					break;
/*//*/				};  // end switch 2
				break;
			};  // end sequence of sequences

			// sequence of some other type
            default:
                rtn = CppParse(SequenceFactory)::findOrCreate(from);
				break;
            };  // end switch 1

        break;
		};  // end of sequences

        // some unknown type
		default:
            rtn = new CppParse(Type)(from);  // TEMP
			break;
		};  // outer switch

    };  // if

    return rtn;  // TEMP
}

#ifdef __SUNPRO_CC  // TMP 4/30: Until we can correct SunPro template problem
    CppParse(Type) *
    CppParse_findOrCreateType(::iluptype::Type from) {
        return CppParse(TypeFactory)::findOrCreate(from);
    };
#endif


#include <iostream.h>  // TEMP
void
CppParse_FactoryT<CppParse(Type), ::iluptype::Type>::
release (CppParse(Type) * t) {
    #define RELEASE_CASE(T, IGNORE1, TYPE_KIND, IGNORE2, IGNORE3) \
        case TYPE_KIND: {                                         \
            CppParse(T) * releaseMe  = CppParse(T)::narrow(t);    \
            CppParse(T ## Factory)::release(releaseMe); };        \
        break;
    cout << "TEMP: CppParse::Type release of " << t->_from->name->base_name  << endl;
    switch(iluptype::_type_kind(t->_from)) {  // TEMP: is this right ?
        CppParse_ENUMERATE_SCALAR_TYPES(RELEASE_CASE)
        CppParse_ENUMERATE_CONSTRUCTED_TYPES(RELEASE_CASE)
        case iluptype::sequence_Type:
            switch(iluptype::_type_kind(iluptype::_type_description(t->_from)->structuredDes.sequence.type)) {
            RELEASE_CASE(WideString,     XXX, iluptype::character_Type,      XXX, XXX)
            RELEASE_CASE(String,         XXX, iluptype::shortcharacter_Type, XXX, XXX)
            RELEASE_CASE(ObjectSequence, XXX, iluptype::object_Type,         XXX, XXX)
            case iluptype::sequence_Type: {
                // TEMP: Check if element type is a string or wide string; if so,
                // TEMP: call CppParse::StringSequenceFactory::release(releaseMe); else,
                // TEMP: call CppParse::WideSequenceFactory::release(releaseMe)
                // TEMP: If not string or wide string, call CppParse::SequenceFactory::release(releaseMe)
                CppParse(Sequence) * releaseMe = CppParse(Sequence)::narrow(t);
                CppParse(SequenceFactory)::release(releaseMe); };
                break;
            default: {
                CppParse(Sequence) * releaseMe = CppParse(Sequence)::narrow(t);
                CppParse(SequenceFactory)::release(releaseMe); };
            };
            break;
        default: {  // TEMP: we should never get here
            CppParse(Type) * releaseMe  = CppParse(Type)::narrow(t);
            CppParse(TypeFactory)::release(releaseMe); };
        break;
    };
}



CppParse(Member) *
CppParse_FactoryT<CppParse(Member), ::iluptype::Argument>::
findOrCreate (::iluptype::Argument from) {
    CppParse(Member) * rtn = (from->values == NULL)
    ? _current->_create(from)
    : CppParse(UnionArmFactory)::findOrCreate(from);
    return rtn;
};

void 
CppParse_FactoryT<CppParse(Member), ::iluptype::Argument>::
release (CppParse(Member) * member) {
    if (member->_from->values == NULL) {
        if (--member->_refCount == 0) {
            cout << "TEMP: destroying " << member->_from->name->base_name << endl;
            iluptype::_list_remove(_allocated, member);
            _current->_destroy(member);
        };
    }
    else {
            CppParse(UnionArm) * releaseMe  = CppParse(UnionArm)::narrow(member);
            CppParse(UnionArmFactory)::release(releaseMe);
    };
};


/* TMP 6/7: Move to later location
CppParse(Exception) *
CppParse_FactoryT<CppParse(Exception), ::iluptype::Exception>::
findOrCreate (::iluptype::Exception from) {
    CppParse(Exception) * rtn;
    if (iluptype::_type_ur_kind(from->type) == iluptype::record_Type)
        rtn = CppParse(IDLExceptionFactory)::findOrCreate(from);
    else {
        // Pick the correct overloaded funtion.
        ::iluptype::boolean (*match)(CppParse(Exception) *, ::iluptype::Exception *) = matchingCreatableFindProc;
        rtn = STATIC_CAST(
            CppParse(Exception)*,
            iluptype::_list_find(
                _allocated,
                REINTERPRET_CAST(::iluptype::iluparser_FindProc, match),
                &from
            )
        );
        if (rtn == NULL)
            rtn = _current->_create(from);
        rtn->_refCount++;
    };
    return rtn;
}
*/

void 
CppParse_FactoryT<CppParse(Exception), ::iluptype::Exception>::
release (CppParse(Exception) * exception) {
    if (iluptype::_type_ur_kind(exception->_from->type) == iluptype::record_Type) {
        CppParse(IDLException) * releaseMe  = CppParse(IDLException)::narrow(exception);
        CppParse(IDLExceptionFactory)::release(releaseMe);
    }
    else {
        if (--exception->_refCount == 0) {
            cout << "TEMP: destroying " << exception->_from->name->base_name << endl;
            iluptype::_list_remove(_allocated, exception);
            _current->_destroy(exception);
        };
    };
};


template <class FROM>
CppParse_CreatableT<FROM>::
CppParse_CreatableT (FROM from) : _from(from) {
}

#ifdef __SUNPRO_CC  // See note in cppparse.hpp

  template <class FROM>
  void
  CppParse_CreatableT<FROM>::
  reInit (FROM from) {
    _from = from;
  }

#endif  // __SUNPRO_CC


template <class T>
class EnumData {
  public:
    EnumData () : _dest(NULL) {}
    ::iluptype::list dest () {return _dest;}
    void dest (::iluptype::list to) {_dest = to;}
  private:
    ::iluptype::list _dest;
};

template <class T, class FROM>
TEMPLATE_STATIC
void
fromsToTsEnumProc (FROM from, EnumData<T> * eData) {
// ::iluptype::iluparser_EnumProc
  T * destElement = CppParse_FactoryT<T, FROM>::findOrCreate(from);
  iluptype::_list_insert(
    eData->dest(),
    STATIC_CAST(::iluptype::refany, destElement));
}

template <class T, class FROM>
TEMPLATE_STATIC
::iluptype::boolean
matchingCreatableFindProc (T * listElement, FROM * from) {
// ::iluptype::iluparser_FindProc
  if (listElement->_from == *from)
    return ILUCPP_TRUE;
  else
    return ILUCPP_FALSE;
}

::iluptype::boolean
matchingCreatableFindProc (CppParse(ReturnVal) * listElement, ::iluptype::Type * from) {
// ::iluptype::iluparser_FindProc
  if (listElement->type()->_from == *from)
    return ILUCPP_TRUE;
  else
    return ILUCPP_FALSE;
}

template <class T, class FROM>
T *
CppParse_FactoryT<T, FROM>::
findOrCreate (FROM from) {
    T * rtn;
    // Pick the correct overloaded funtion, based on FROM and T
    ::iluptype::boolean (*match)(T *, FROM *) = matchingCreatableFindProc;
    rtn = STATIC_CAST(
        T*,
        /*iluptype::_list_find TMP 8/15*/my_list_find(
            _allocated,
            REINTERPRET_CAST(::iluptype::iluparser_FindProc, match),
            &from));
    if (rtn == NULL)
        rtn = _current->_create(from);
    rtn->_refCount++;
    return rtn;
}

CppParse(Exception) *  // TMP 6/7: Moved from earlier location
CppParse_FactoryT<CppParse(Exception), ::iluptype::Exception>::
findOrCreate (::iluptype::Exception from) {
    CppParse(Exception) * rtn;
    if (from->importInterfaceName != NULL)
        from = from->import;
    if (iluptype::_type_ur_kind(from->type) == iluptype::record_Type)
        rtn = CppParse(IDLExceptionFactory)::findOrCreate(from);
    else {
        // Pick the correct overloaded funtion.
        ::iluptype::boolean (*match)(CppParse(Exception) *, ::iluptype::Exception *) = matchingCreatableFindProc;
        rtn = STATIC_CAST(
            CppParse(Exception)*,
            /*iluptype::_list_find TMP 8/15*/my_list_find(
                _allocated,
                REINTERPRET_CAST(::iluptype::iluparser_FindProc, match),
                &from
            )
        );
        if (rtn == NULL)
            rtn = _current->_create(from);
        rtn->_refCount++;
    };
    return rtn;
}


CppParse(Object) *  // TMP 6/15: NEW
CppParse_FactoryT<CppParse(Object), ::iluptype::Type>::
findOrCreate (::iluptype::Type from) {
    CppParse(Object) * rtn;
    // Pick the correct overloaded funtion, based on ::iluptype::Type and CppParse::Object
    ::iluptype::boolean (*match)(CppParse(Object) *, ::iluptype::Type *) = matchingCreatableFindProc;
    if (from->importInterfaceName != NULL)
        from = from->supertype;
    rtn = STATIC_CAST(
        CppParse(Object)*,
        /*iluptype::_list_find TMP 8/15*/my_list_find(
            _allocated,
            REINTERPRET_CAST(::iluptype::iluparser_FindProc, match),
            &from));
    if (rtn == NULL)
        rtn = _current->_create(from);
    rtn->_refCount++;
    return rtn;
}

CppParse(ArrayDimension) *
CppParse_FactoryT<CppParse(ArrayDimension), long unsigned>::
findOrCreate (long unsigned from) {
    CppParse(ArrayDimension) * rtn = _current->_create(from);
    rtn->_refCount++;
    return rtn;
}

template <class T, class FROM>
void
CppParse_FactoryT<T, FROM>::
release (T * t) {
  cout << "TEMP: release of " << t->_from->name->base_name  << endl;
  if (--t->_refCount == 0) {
    cout << "TEMP: destroying " << t->_from->name->base_name << endl;
    iluptype::_list_remove(_allocated, t);
    _current->_destroy(t);
  };
}

// NOTE: The following specialization of release for CppParse::Enumerator is needed only for
// the output messages, because an ::iluptype::EnumField does not have a "name" field.
// If the output messages are removed, this specialization is no longer needed.
void
CppParse_FactoryT<CppParse(Enumerator), ::iluptype::EnumField>::
release (CppParse(Enumerator) * t) {
  cout << "TEMP: release of Enumerator" << t->baseName()  << endl;
  if (--t->_refCount == 0) {
    cout << "TEMP: destroying Enumerator" << t->baseName() << endl;
    iluptype::_list_remove(_allocated, t);
    _current->_destroy(t);
  };
}

// NOTE: The following specialization of release for CppParse::ArrayDimension is needed only for
// the output messages, because a long unsigned does not have a "name" field.
// If the output messages are removed, this specialization is no longer needed.
void
CppParse_FactoryT<CppParse(ArrayDimension), long unsigned>::
release (CppParse(ArrayDimension) * t) {
  cout << "TEMP: release of ArrayDimension" << t->length()  << endl;
  if (--t->_refCount == 0) {
    cout << "TEMP: destroying ArrayDimension" << t->length() << endl;
    iluptype::_list_remove(_allocated, t);
    _current->_destroy(t);
  };
}

// NOTE: The following specialization of release for CppParse::ConstantValue is needed only for
// the output messages, because a ConstantValue does not have a "name" field.
// If the output messages are removed, this specialization is no longer needed.
void
CppParse_FactoryT<CppParse(ConstantValue), ::iluptype::ConstantValue>::
release (CppParse(ConstantValue) * cv) {
  cout << "TEMP: release of ConstantValue" << endl;
  if (--cv->_refCount == 0) {
    cout << "TEMP: destroying ConstantValue" << endl;
    iluptype::_list_remove(_allocated, cv);
    _current->_destroy(cv);
  };
}

// NOTE: The following specialization of release for CppParse::Import is needed only for
// the output messages, because an Imported does not have a "name" field.
// If the output messages are removed, this specialization is no longer needed.
void
CppParse_FactoryT<CppParse(Import), ::iluptype::Imported>::
release (CppParse(Import) * i) {
  cout << "TEMP: release of Import" << i->baseName()  << endl;
  if (--i->_refCount == 0) {
    cout << "TEMP: destroying Import" << i->baseName() << endl;
    iluptype::_list_remove(_allocated, i);
    _current->_destroy(i);
  };
}


template <class T, class FROM>
void
CppParse_FactoryT<T, FROM>::
set (CppParse_FactoryT<T, FROM> * f) {
  _current = (f == NULL) ? &_default : f;
}

template <class T, class FROM>
CppParse_FactoryT<T, FROM> *
CppParse_FactoryT<T, FROM>::
current () {
  return _current;
}

template <class T, class FROM>
FROM
CppParse_FactoryT<T, FROM>::
noteAllocated (T * t, FROM from) {
  iluptype::_list_push(_allocated, t);
  return from;
}

template <class T, class FROM>
void
CppParse_FactoryT<T, FROM>::
createList (::iluptype::list from, ::iluptype::list * to) {
  _current->_createList(from, to);
}


template <class T, class FROM>
void
CppParse_FactoryT<T, FROM>::
_createList (::iluptype::list from, ::iluptype::list * to) const {
  EnumData<T> eData;
  *to = iluptype::_iluparser_new_list();  // TEMP: check allocation
  eData.dest(*to);
  // Pick the correct overloaded function, based on FROM and T
  void (*fromsToTs)(FROM, EnumData<T> *) = fromsToTsEnumProc;
/* TMP 8/12
  iluptype::_list_enumerate(
    from,
    REINTERPRET_CAST(::iluptype::iluparser_EnumProc, fromsToTs),
    &eData);
*/
  my_list_enumerate(  // TMP 8/12
    from,
    REINTERPRET_CAST(::iluptype::iluparser_EnumProc, fromsToTs),
    &eData);
}


CppParse(NamedValue)::
CppParse_(NamedValue) (::iluptype::Procedure from)
    : CppParseName(Name)(STATIC_CAST(::iluptype::Name, NULL)),  // TMP 2/23 This is ugly
      _usage(CppParseName(returnVal)),
      _type(from->returnType == NULL ?
        STATIC_CAST(CppParse_(Type)*, NULL) :
        CppParse_(TypeFactory)::findOrCreate(from->returnType)) {
};

CppParse(NamedValue)::
CppParse_(NamedValue) (::iluptype::Argument from)
    : CppParseName(Name)(from->name, NULL),
      _usage(
          from->direction == iluptype::In ? CppParseName(in) :
          from->direction == iluptype::Out ? CppParseName(out) :
          CppParseName(inOut)  // TEMP: check for out-of-range ?
      ),
      _type(CppParse_(TypeFactory)::findOrCreate(from->type)) {
};

CppParse(NamedValue)::
CppParse_(NamedValue) (::iluptype::Argument from, CppParseName(TypeUsage) usage)
    : CppParseName(Name)(from->name, NULL),
      _usage(usage),  // TEMP: check for out-of-range ?
      _type(CppParse_(TypeFactory)::findOrCreate(from->type)) {
};

static const char * exceptionValName = "_val";

CppParse(NamedValue)::
CppParse_(NamedValue) (::iluptype::Exception exception)
:   CppParseName(Name)(exceptionValName, CppParse_(ExceptionFactory)::findOrCreate(exception)),
    _usage(CppParseName(recordMember)),
    _type((exception->type == NULL) ? NULL : CppParse_(TypeFactory)::findOrCreate(exception->type)) {
};

CppParse(NamedValue)::
CppParse_(NamedValue) (const CppParseName(Name)& _name_, CppParseName(TypeUsage) _usage_, const CppParse_(Type) * _type_)
  : CppParseName(Name)(_name_), _usage(_usage_), _type(_type_) {
};

CppParseName(TypeUsage)
CppParse(NamedValue)::
usage () const {
    return _usage;
};

const CppParse(Type) *
CppParse(NamedValue)::
type () const {
    return _type;
};


#ifdef _MSC_VER  // MSVC4.1 Compiler Note #1
    #pragma warning(disable: 4355)
#endif  // _MSC_VER

    CppParse(Argument)::
    CppParse_(Argument) (::iluptype::Argument from)
    :   CppParse_CreatableT< ::iluptype::Argument>(CppParse(ArgumentFactory)::noteAllocated(this, from)),
        CppParse_(NamedValue)(from) {
    }

#ifdef _MSC_VER
    #pragma warning(default: 4355)
#endif  // _MSC_VER

ILUCPP_BOOL
CppParse(Argument)::
sibling () const {
    return _from->sibling;
};


#ifdef _MSC_VER  // MSVC4.1 Compiler Note #1
  #pragma warning(disable: 4355)
#endif  // _MSC_VER

    CppParse(ReturnVal)::
    CppParse_(ReturnVal) (::iluptype::Procedure from)
      :   CppParse_CreatableT< ::iluptype::Procedure>(CppParse(ReturnValFactory)::noteAllocated(this, from)),
          CppParse_(NamedValue)(from) {
    }

#ifdef _MSC_VER
  #pragma warning(default: 4355)
#endif  // _MSC_VER


#ifdef _MSC_VER  // MSVC4.1 Compiler Note #1
  #pragma warning(disable: 4355)
#endif  // _MSC_VER
  
  CppParse(Member)::
  CppParse_(Member) (::iluptype::Argument from)
  : CppParse(NamedValue)(from, CppParseName(recordMember)),
    CppParse_CreatableT< ::iluptype::Argument>(
      CppParse(MemberFactory)::noteAllocated(this, from)) {
  }

#ifdef _MSC_VER
  #pragma warning(default: 4355)
#endif  // _MSC_VER


#ifdef _MSC_VER  // MSVC4.1 Compiler Note #1
  #pragma warning(disable: 4355)
#endif  // _MSC_VER
  
  CppParse(Procedure)::
  CppParse_(Procedure) (::iluptype::Procedure proc)
  : CppParse_CreatableT< ::iluptype::Procedure>(
      CppParse(ProcedureFactory)::noteAllocated(this, proc)),
/* TMP 7/3
    CppParseName(Name)(
      proc->name,
      CppParse_(ObjectFactory)::findOrCreate(proc->object)),
*/
    CppParseName(Scope)(  // TMP 7/3: NEW
      proc->name,  // TMP 7/3: NEW
      CppParse_(ObjectFactory)::findOrCreate(proc->object)),  // TMP 7/3: NEW
    CppParseName(Name)(proc),  // TMP 7/3: NEW
    _arguments(proc->arguments),
    _returnVal(CppParse_(ReturnValFactory)::findOrCreate(proc)),
    _exceptions(proc->exceptions),
    _object(CppParse_(ObjectFactory)::findOrCreate(proc->object))
  {  // TMP 7/3: NEW
      CppParse(ArgumentListIter) argumentListIter(arguments());  // TMP 7/3: NEW
      const CppParse(Argument) * argument;  // TMP 7/3: NEW
      while ((argument = argumentListIter.next()) != NULL)  // TMP 7/3: NEW
          CONST_CAST(CppParse_(Argument)*, argument)->resetName(this);  // TMP 7/3: NEW
      CONST_CAST(CppParse_(ReturnVal)*, _returnVal)->resetName(this);  // TMP 7/3: NEW
  }  // TMP 7/3: NEW

#ifdef _MSC_VER
  #pragma warning(default: 4355)
#endif  // _MSC_VER


const CppParse(ArgumentList) &
CppParse(Procedure)::
arguments () const {
  return(_arguments);
}

const CppParse(ReturnVal) *
CppParse(Procedure)::
returnVal () const {
  return(_returnVal);
}

const CppParse(ExceptionList) &
CppParse(Procedure)::
exceptions () const {
  return(_exceptions);
}

int
CppParse(Procedure)::
protocolId () const {
  return(_from->id);
}

ILUCPP_BOOL
CppParse(Procedure)::
functional () const {
  return(_from->functional ? ILUCPP_TRUE : ILUCPP_FALSE);
}

ILUCPP_BOOL
CppParse(Procedure)::
asynch () const {
  return(_from->asynch ? ILUCPP_TRUE : ILUCPP_FALSE);
}

const CppParse(Object) *
CppParse(Procedure)::
object () const {
  return(_object);
}

#ifdef _MSC_VER  // MSVC4.1 Compiler Note #1
  #pragma warning(disable: 4355)
#endif  // _MSC_VER
  
  CppParse(Object)::
  CppParse_(Object) (::iluptype::Type from)
  : CppParse(Type)(CppParse(ObjectFactory)::noteAllocated(this, from)),
    CppParseName(Scope)(from->name, CppParse_(InterfaceForType(from))),
    CppParseName(Name)(from),
    CppParseName(TypeName)(from),
    _superclasses(
      iluptype::_type_description(from)->structuredDes.object->superclasses),
      // TEMP: iluptype::_type_description ?
    _procedures(
      iluptype::_type_description(from)->structuredDes.object->methods) {
      // TEMP: iluptype::_type_description ?
    #ifdef __SUNPRO_CC  // See note in cppparse.hpp
      CppParse(Type)::reInit(from);
    #endif  // __SUNPRO_CC
/* TMP 6/15
    if (from->importInterfaceName != NULL && strcmp(from->importInterfaceName, "ilu") == 0) {
        // TMP 5/2: Need something better than this
        if (strcmp(iluptype::_type_name(from), "CORBA-Object") == 0)
            iluptype::_name_set_base_name(from->name, "Object");
    };
*/
  }

#ifdef _MSC_VER
  #pragma warning(default: 4355)
#endif  // _MSC_VER
  
void *
CppParse(Object)::  // TMP 7/3: NEW
operator new (size_t nbytes, ::iluptype::Type from) {  // TMP 7/3: NEW
    void * rtn = ::new char[nbytes];  // TMP 7/3: NEW
    CppParse_(ObjectFactory)::noteAllocated(CppGen(Object)::convert(rtn), from);  // TMP 6/1
    return rtn;  // TMP 7/3: NEW
}  // TMP 7/3: NEW


CppParse(Object) *  // TMP 7/3: NEW
CppParse_FactoryT<CppParse(Object), ::iluptype::Type>::  // TMP 7/3: NEW
_create (::iluptype::Type) const {  // TMP 7/3: NEW
    cout << "Oops !  Entering CppParse::ObjectFactory::_create ..." << endl;  // TMP 7/3: NEW
    return NULL;  // TMP 7/3: NEW
}


// TMP 9/8 const CppParse(ObjectList) &
const CppParse(TypeList) &  // TMP 9/8: NEW
CppParse(Object)::
superclasses () const {
  return(_superclasses);
}

const char *
CppParse(Object)::
brand () const {
  return(iluptype::_class_object(_from)->brand);
}

const char *
CppParse(Object)::
singleton () const {
  return(iluptype::_class_object(_from)->singleton);
}

ILUCPP_BOOL
CppParse(Object)::
collectible () const {
  return(iluptype::_class_object(_from)->collectible ? ILUCPP_TRUE : ILUCPP_FALSE);
}

ILUCPP_BOOL
CppParse(Object)::
optional () const {
  return(iluptype::_class_object(_from)->optional ? ILUCPP_TRUE : ILUCPP_FALSE);
}

const char *
CppParse(Object)::
authentication () const {
  return(iluptype::_class_object(_from)->authentication);
}

const char *
CppParse(Object)::
docString () const {
  return(iluptype::_class_object(_from)->doc_string);
}

const CppParse(ProcedureList) &
CppParse(Object)::
procedures () const {
  return(_procedures);
}

/* TMP 7/7
ILUCPP_BOOL
CppParse(Object)::
isPtr (CppParseName(TypeUsage)) const {
    return ILUCPP_TRUE;
}
*/

CppParse(Indirection)  // TMP 7/7: NEW
CppParse(Object)::  // TMP 7/7: NEW
indirection (CppParseName(TypeUsage)) const {  // TMP 7/7: NEW
    return CppParse_(pseudoPointer);  // TMP 7/7: NEW
}  // TMP 7/7: NEW

ILUCPP_BOOL
CppParse(Object)::
variableLength () const {
  return ILUCPP_TRUE;
}


#ifdef _MSC_VER  // MSVC4.1 Compiler Note #1
  #pragma warning(disable: 4355)
#endif  // _MSC_VER
  
    CppParse(Import)::
    CppParse_(Import) (::iluptype::Imported from)
      : CppParse_CreatableT< ::iluptype::Imported>(CppParse(ImportFactory)::noteAllocated(this, from)),
        CppParseName(Name)(from)
    {
    }

#ifdef _MSC_VER
  #pragma warning(default: 4355)
#endif  // _MSC_VER

const char *
CppParse(Import)::
filename () const {
    return _from->filename;
}


/* TMP 6/15
template <class FROM>
TEMPLATE_STATIC
::iluptype::boolean
importedFindProc (FROM listElement, void *) {
// ::iluptype::iluparser_FindProc
  return listElement->importInterfaceName != NULL;
}
*/

template <class FROM>  // TMP 6/15
TEMPLATE_STATIC
void
addIfImportEnumProc (FROM listElement, ::iluptype::list to) {
// ::iluptype::iluparser_EnumProc
  if (listElement->importInterfaceName != NULL)
      iluptype::_list_insert(to, listElement);
}

template <class FROM>  // TMP 6/15
TEMPLATE_STATIC
void
addIfNonImportEnumProc (FROM listElement, ::iluptype::list to) {
// ::iluptype::iluparser_EnumProc
  if (listElement->importInterfaceName == NULL)
      iluptype::_list_insert(to, listElement);
}

static
::iluptype::boolean
objectFindProc (::iluptype::Type listElement, void *) {
// ::iluptype::iluparser_FindProc
    return iluptype::_type_kind(listElement) == iluptype::object_Type;
}

/* TMP 6/15
template <class T, class FROM>
TEMPLATE_STATIC
::iluptype::list
removeImports (::iluptype::list l, CppParse_ListT<T, FROM>) {
    /* 
        The purpose of the second parameter is to detemine which
        template specialization is being requested. FROM must point
        a struct with an importInterfaceName field which can be
        compared against NULL.
    */
/* TMP 6/15
    ::iluptype::boolean (*findImported)(FROM, void *) = importedFindProc;
    // Pick the correct overloaded funtion, based on T
    void * element;
    while ((element = iluptype::_list_find(l, REINTERPRET_CAST(::iluptype::iluparser_FindProc, findImported), NULL)) != NULL)
        iluptype::_list_remove(l, element);
    return l;
}
*/

template <class T, class FROM>  // TMP 6/15: NEW
TEMPLATE_STATIC
::iluptype::list
copyImports (::iluptype::list l, const CppParse_ListT<T, FROM>&) {
    /* 
        The purpose of the second parameter is to detemine which
        template specialization is being requested. FROM must point
        a struct with an importInterfaceName field which can be
        compared against NULL.
    */
    ::iluptype::list rtn = iluptype::_iluparser_new_list();  // TEMP: check allocation
    // Pick the correct overloaded function, based on FROM
    void (*addIfImport)(FROM, ::iluptype::list) = addIfImportEnumProc;
    iluptype::_list_enumerate(
        l,
        REINTERPRET_CAST(::iluptype::iluparser_EnumProc, addIfImport),
        rtn);
    return rtn;
}

template <class T, class FROM>  // TMP 6/15: NEW
TEMPLATE_STATIC
::iluptype::list
copyNonImports (::iluptype::list l, const CppParse_ListT<T, FROM>&) {
    /* 
        The purpose of the second parameter is to detemine which
        template specialization is being requested. FROM must point
        a struct with an importInterfaceName field which can be
        compared against NULL.
    */
    ::iluptype::list rtn = iluptype::_iluparser_new_list();  // TEMP: check allocation
    // Pick the correct overloaded function, based on FROM
    void (*addIfNonImport)(FROM, ::iluptype::list) = addIfNonImportEnumProc;
    iluptype::_list_enumerate(
        l,
        REINTERPRET_CAST(::iluptype::iluparser_EnumProc, addIfNonImport),
        rtn);
    return rtn;
}

static
::iluptype::list
removeObjects (::iluptype::list l) {
    void * element;
    while ((element = /*iluptype::_list_find TMP 8/15*/my_list_find(l, REINTERPRET_CAST(::iluptype::iluparser_FindProc, objectFindProc), NULL)) != NULL)
        iluptype::_list_remove(l, element);
    return l;
}


#ifdef _MSC_VER  // MSVC4.1 Compiler Note #1
  #pragma warning(disable: 4355)
#endif  // _MSC_VER

    /*
        Note: It's important for Interface's _types field to be initialized before
        _localTypes, since the later will alter from->types. N.B. ANSI
        C++ defines the initialization order to be the order in which the fields
        appear in the definition of the Interface class, not the order of appearance
        in the constructor.
    */
  
    CppParse(Interface)::
    CppParse_(Interface) (::iluptype::Interface from)
      : CppParse_CreatableT< ::iluptype::Interface>(CppParse(InterfaceFactory)::noteAllocated(this, from)),
        CppParseName(Scope)(from->name, NULL),
        CppParseName(Name)(from),
        _imports(from->imports),
        // TMP 6/13    _types(from->types),
        _types(copyNonImports(removeObjects(from->types), _types)),  // TMP 6/13 NEW
        // TMP 6/13    _objects(from->classes),
        _objects(copyNonImports(from->classes, _objects)),  // TMP 6/13 NEW
        // TMP 6/13    _exceptions(from->exceptions)
        _exceptions(copyNonImports(from->exceptions, _exceptions)),  // TMP 6/13 NEW
        _importedTypes(copyImports(from->types, _importedTypes)),  // TMP 6/13 NEW
        _importedObjects(copyImports(from->classes, _importedObjects)),  // TMP 6/13 NEW
        _importedExceptions(copyImports(from->exceptions, _importedExceptions))  // TMP 6/13 NEW
        {
        }

#ifdef _MSC_VER
  #pragma warning(default: 4355)
#endif  // _MSC_VER


const char *
CppParse(Interface)::
brand () const {
	return _from->brand;
};

const CppParse(ImportList) &
CppParse(Interface)::
imports () const {
  return _imports;
}

const CppParse(TypeList) &
CppParse(Interface)::
types () const {
  return _types;
}

const CppParse(ObjectList) &
CppParse(Interface)::
objects () const {
  return _objects;
}

const CppParse(ExceptionList) &
CppParse(Interface)::
exceptions () const {
  return _exceptions;
}

const CppParse(TypeList) &
CppParse(Interface)::
importedTypes () const {
  return _importedTypes;
}

const CppParse(ObjectList) &
CppParse(Interface)::
importedObjects () const {
  return _importedObjects;
}

const CppParse(ExceptionList) &
CppParse(Interface)::
importedExceptions () const {
  return _importedExceptions;
}

void *  // TMP 8/13
CppParse(Interface)::
operator new (size_t nbytes, ::iluptype::Interface from) {
    void * rtn = new char[nbytes];
    CppParse_(InterfaceFactory)::noteAllocated(STATIC_CAST(CppParse_(Interface)*, rtn), from);
    return rtn;
}


/* Note on CppParse_ListT::_ref_count : CppParse_ListT's are ref-counted to
   avoid premature destruction of the _list field. When a new CppParse_ListT
   is constructed from an ::iluptype::list, it's _ptr_to_ref_count points to
   it's _ref_count field, which is initialized to 1. Subsequent invocation of
   the copy constructor causes the copy's _ptr_to_ref_count to point back to
   the original's _ref_count, which is incremented. The destructor decrements
   the count, and checks it for zero before destroying _list.
*/


template <class T, class FROM>
CppParse_ListT<T, FROM>::
CppParse_ListT (const ::iluptype::list src) {
  CppParse_FactoryT<T, FROM>::createList(src, &_list);
    // TEMP: check for allocation problems
  _ref_count = 1;
// TMP 8/13  _ptr_to_ref_count = &CppParse_ListT::_ref_count;
  _ptr_to_ref_count = &CppParse_ListT<T, FROM>::_ref_count;  // TMP 8/13
}

template <class T, class FROM>
CppParse_ListT<T, FROM>::
CppParse_ListT (const CppParse_ListT<T, FROM> & src) {
  _ptr_to_ref_count = src._ptr_to_ref_count;
  _list = src._list;
}

template <class T, class FROM>
CppParse_ListT<T, FROM>::
~CppParse_ListT (void) {
  unsigned CppParse_ListT<T, FROM>:: * pt_ref =
    &CppParse_ListT<T, FROM>::_ref_count;
  (this->*pt_ref)--;
// TMP 6/15  if (this->*pt_ref == 0)
  if (this->*pt_ref == 0 && _list != NULL)  // TMP 6/15: NEW
    iluptype::_list_clear(_list, ILUCPP_FALSE);  // TEMP
}

template <class T, class FROM>
unsigned long
CppParse_ListT<T, FROM>::
count () const {
  return((_list == NULL)
    ? 0
    : iluptype::_list_size(_list)
  );
}


template <class T, class FROM>
CppParse_ListIterT<T, FROM>::
CppParse_ListIterT (const CppParse_ListT<T, FROM> & list)
: _list(&list) {
  reset();
}

template <class T, class FROM>
const T *
CppParse_ListIterT<T, FROM>::
next () {
  const T * rtn;
  if (_current == NULL)
    rtn = NULL;
  else {
    rtn = (T *)(_current->data);
    _current = _current->next;
  };
  return(rtn);
}

template <class T, class FROM>
void
CppParse_ListIterT<T, FROM>::
reset () {
  if ((_list != NULL) && (_list->_list->count > 0))
    _current = _list->_list->head;
  else
    _current = NULL;
}



#ifdef _MSC_VER

    #define INSTANTIATE_FACTORY(T, FROM, UNUSED1, UNUSED2, UNUSED3)             \
        template CppParse_FactoryT<CppParse(T), FROM>;                          \
        CppParse(T ## Factory) CppParse(T ## Factory)::_default;                \
        CppParse(T ## Factory) *  CppParse(T ## Factory)::_current = &_default; \
        ::iluptype::list CppParse(T ## Factory)::_allocated = iluptype::_iluparser_new_list();

    #define INSTANTIATE_LIST(T, FROM, UNUSED1, UNUSED2, UNUSED3) \
        template CppParse_ListT<CppParse(T), FROM>;              \
        template CppParse_ListIterT<CppParse(T), FROM>;

    #pragma warning(disable: 4660)  // MSVC4.1 Compiler Note #2
        CppParse_ENUMERATE_CREATABLES(INSTANTIATE_FACTORY)
        CppParse_ENUMERATE_CREATABLES(INSTANTIATE_LIST)
    #pragma warning(default: 4660)

    CppParse(_MSVCNote2Workaround)::
    CppParse(_MSVCNote2Workaround) () : interfaceList(NULL) {
    };

#else

    #define INSTANTIATE_FACTORY(T, FROM, UNUSED1, UNUSED2, UNUSED3)                            \
        CppParse(T ## Factory) CppParse(T ## Factory)::_default;                               \
        CppParse(T ## Factory) *  CppParse(T ## Factory)::_current = &_default;                \
        ::iluptype::list CppParse(T ## Factory)::_allocated = iluptype::_iluparser_new_list();

    CppParse_ENUMERATE_CREATABLES(INSTANTIATE_FACTORY)

#endif  // _MSC_VER


#define INSTANTIATE_NARROWABLE(T, FROM, UNUSED1, UNUSED2, UNUSED3) \
    int CppParse(T)::cid;

CppParse_ENUMERATE_CREATABLES(INSTANTIATE_NARROWABLE)





/*
    G++2.7.1 Compiler Note #1 - The compiler complains when we try to use ::iluptype::name_s in the initialization list of InitablePName::InitablePName ("parse error before `::'".

    SunPro4.1 Compiler Note #1 - See note regarding "reInit" methods in cppparse.hpp.

    MSVC4.1 Compiler Note #1 - The compiler issues warning C4355 ("'this' : used in base member initializer list"). However, the ANSI C++ April, 1995 Working Draft (X3J16/95-0087; section 12.7, paragraph 2) implies that such use of "this" is legal.

    MSVC4.1 Compiler Note #2 - It's difficult to determine which template classes/class members will be automatically instantiated. So, we just explicitly instantiate everything. (C4660 is the compiler warning generated for multiply-instantiated templates).

*/
