/*
 * macos.h -- MacOS specific macro definitions for library and system calls
 *
 * Dan B. Keith    December 1996
 */

#ifndef MACOS_H
#define MACOS_H


/*OLDSTUFF - Probably should be deleted...
 * macos.h -- MacOS specific macro definitions for library and system calls
 *
 * Antony A. Courtney, 17/7/93

#include "support.h"

#define OS_BCOPY		ilu_sup_bcopy
#define OS_GETPID		ilu_sup_getpid
#define OS_SIGVEC		SIGVEC_NOT_SUPPORTED

#ifndef ANSI_STRERROR
#define ANSI_STRERROR(a)	strerror(a)
#endif
 */


#ifdef __cplusplus
extern "C" {
#endif

#include	<unistd.h>

int access(const char *path, int oflag);

int chmod(const char *path, int mode);

unsigned int mac_sleep(unsigned int sleep);

#define OS_SLEEP		mac_sleep	/* memory.c */
#define OS_READ			read	/* mainloop.c */
#define OS_WRITE		write	/* mainloop.c */
#define OS_GETPID		getpid	/* bsdutils.c */
#define OS_UNLINK		unlink	/* simpbind.c */
#define OS_ACCESS		access	/* simpbind.c */
#define OS_CHMOD		chmod	/* simpbind.c */
#define OS_SIGVEC		SIGVEC_NOT_SUPPORTED

#define OS_ACCESS_R_OK		0x04
#define OS_ACCESS_W_OK		0x02

#define OS_CHMOD_S_IWUSR	1	/* simpbind.c */
#define OS_CHMOD_S_IRUSR	0	/* simpbind.c */
#define OS_CHMOD_S_IWGRP	1	/* simpbind.c */
#define OS_CHMOD_S_IRGRP	0	/* simpbind.c */
#define OS_CHMOD_S_IWOTH	1	/* simpbind.c */
#define OS_CHMOD_S_IROTH	0	/* simpbind.c */

#ifndef ANSI_STRERROR
#define ANSI_STRERROR(a)	strerror(a)
#endif


#define OS_SOCKIOCTL(fd,req,arg)	ioctlsocket(fd,req,arg)	/* tcp.c, udp.c */
/* Larner removed casts to int from third arg in his WIN port */

#define OS_ACCEPT(fd,adr,len)	accept(fd,adr,len)	/* tcp.c */

#define OS_SOCKINV(x) ((x) == INVALID_SOCKET)	/* tcp.c, udp.c */
/*
 * Call this on result/errcode to test whether a fd-returning
 * sockets call is raising an error
 */

#define OS_SOCKERR(x) ((x) == SOCKET_ERROR)	/* tcp.c, udp.c */
/*
 * Call this on result/errcode to test whether a non-fd-returning
 * sockets call is raising an error
 */

#define OS_SOCKLOSE(x)	closesocket(x)	/* tcp.c, udp.c */
/* Call this to close an FD for a socket */

#define SOCKERRID(x)	(WSAE##x)
#define sockerrno	WSAGetLastError()

void StartupWinsock();
void ShutdownWinsock();

#ifdef __cplusplus
};
#endif

#endif


