/*
 * Programm XBLAST V1.2.9 or higher
 * (C) by Oliver Vogel (e-mail: vogel@ikp.uni-koeln.de)
 * February 24th 1996
 * started August 1993
 *
 * File: info.c
 * level info
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public Licences as by published
 * by the Free Software Foundation; either version 2; or (at your option)
 * any later version
 *
 * This program is distributed in the hope that it will be entertaining,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILTY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 * Publis License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.
 * 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#define _INFO_C

#include <stdio.h>
#include <stdlib.h>

#include "include.h"
#include "mytypes.h"
#include "data.h"
#include "func.h"
#include "shrink.h"
#include "info.h"


/*
 * public function alloc_info
 */
#ifdef __STDC__
char **
alloc_info (void)
#else
char **
alloc_info ()
#endif
{
  char **ptr;
  int i;

  if (NULL == (ptr = (char **) calloc(MAX_INFO,sizeof(char *) ) ) ) {
    return NULL;
  }
  for (i=0; i<MAX_INFO; i++) {
    if (NULL == (ptr[i] = calloc(INFO_LENGTH,sizeof(char) ) ) ) {
      while (i > 0) {
	free (ptr[--i]);
      }
      free(ptr);
      return NULL;
    }    
  } 
  return ptr;
}



/*
 * Shrink Info
 */
static FuncInfo shrink_info[] = {
  { shrink_void,           NULL },
  { shrink_spiral,         "Spiral shrinking at half time" },
  { shrink_speed_spiral,   "Fast spiral shrinking at half time" },
  { shrink_spiral_plus,    "Spiral shrinking at half time" },
  { shrink_spiral_3,       "3 level spiral shrinking at half time" },
  { shrink_compound,       "Continuous compound shrinking" },
  { shrink_compound_f,     "Continuous compound shrinking" },
  { shrink_compound_solid, "Continuous compound shrinking" },
  { shrink_compound_extra, "Compound shrinking with blastables" },
  { shrink_savage_compound,"Double continous compound shrinking" },
  { shrink_down,           "Continuous downward shrinking" },
  { shrink_down_f,         "Continuous downward shrinking" },
  { shrink_quad,           "Quad shrinking at half time" },
  { shrink_constrict_wave, "3 level wave shrink at half time" },
  { shrink_lazy_compound_f,"Lazy compound shrinking" },
  { shrink_compound_2_f,   "2 level compound shrinking" },
  { NULL, NULL },
};

/*
 * game function info
 */
static FuncInfo game_info[] = {
  { special_game_void,        NULL },
  { special_game_nasty_walls, "The Walls launch bombs" },
  { special_game_haunt,       "All bombs are haunted" },
  { special_game_haunt_fast,  "All bombs are haunted (and dangerous)" },
  { NULL, NULL },
};


/*
 * Extra info
 */
static FuncInfo special_extra_info[] = {
  { special_extra_void,         NULL  },
  { special_extra_invincible,   "Invincibility as an extra" },
  { special_extra_kick,         "Kick bomb as an extra" },
  { special_extra_teleport,     "Teleporter as an extra" },
  { special_extra_RC,           "Remote control as an extra" },
  { special_extra_ignite_all,   "Button as an extra" },
  { special_extra_air,          "Airpump as an extra" },
  { special_extra_junkie,       "Junkie virus as an extra" },
  { special_extra_special_bomb, NULL },
  { NULL, NULL },
};

/*
 * bomb extra info
 */
static char *bomb_name[] = {
  NULL,
  "Napalm bomb",
  NULL,
  NULL,
  "Firecracker",
  NULL,
  "Construction bomb",
  "Three bomb",
  "Grenade",
  "Triangle bomb",
  "Destruction bomb",
  "Fungus bomb",
  "Renovation bomb",
  "Pyro bomb",
  NULL,
  "Random bomb",
};

/* 
 * fuse time info
 */
static char *fuse_info[NUM_FUSES] = {
  "All bombs are short fused",
  NULL,
  "All bombs are long fused",
};


/*
 * info on bomb directions
 */
static char *bomb_dir_info[] = {
  NULL,
  "Bombs are going up",
  "Bombs are going left",
  "Bombs are falling down",
  "Bombs are going right",
  NULL,
};

/*
 * info on bomb clicks
 */
static char *bomb_click_info[] = {
  NULL,
  "Bombs are snooker bombs",
  "Bombs explode on contact with others",
  "Bombs turn clockwise on hitting others",
  "Bombs turn anticlockwise on hitting others",
  "Bombs bounce off randomly from others",
  "Bombs rebound from others",
};

/*
 * info on wall clicks
 */
static char *wall_click_info[] = {
  NULL,
  "Bombs rebound off walls",
  "Bombs explode on contact with walls",
  "Bombs turn clockwise on hitting walls",
  "Bombs turn anticlockwise on hitting walls",
  "Bombs bounce off randomly of walls",
};

/*
 * info on player click
 */
static char *player_click_info[] = {
  NULL,
  NULL,
  "Bombs stun players running through",
  "Bombs explode on contact with players",
  "Bombs rebound off players",
};



#ifdef __STDC__
static int
set_func_info (PFV func, 
	       FuncInfo *info,
	       char **line)
#else
static int
set_func_info (func, info, line)
     PFV func;
     FuncInfo *info;
     char **line;
#endif
{
  int i;

  for (i=0; info[i].func != NULL; i ++) {
    if (info[i].func == func) {
      if (info[i].msg != NULL) {
	strcpy(*line,info[i].msg);
	return 1;
      } else {
	return 0;
      }
    }
  }
  return 0;
}


#ifdef __STDC__
static int
set_value_info (int value,
		char **info,
		char **line)
#else
static int
set_value_info (value, info, line)
     int value;
     char **info;
     char **line;
#endif
{
  if (info[value] == NULL) {
    return 0;
  } else {
    strcpy(*line,info[value]);
    return 1;
  }
}



/*
 * public function get_level_info
 *
 * general info about the level
 */
#ifdef __STDC__
void 
get_level_info (int level,
		char **info)
#else
void 
get_level_info (level, info)
     int level;
     char **info;
#endif
{
  int i,count;
  BMLevelData *data = maze_data[level];

  /* reset level info */
  for (i=0; i<MAX_INFO; i++) {
    info[i][0] = '\0';
  }

  count = 0;
  
  /* look for extra function */
  if (set_func_info(data->extra_func, special_extra_info, 
		    &(info[count])) ) {
    if ( ++count >= MAX_INFO) {
      goto MessagesFinished;
    }
  }
  /* look for special bombs */
  if (data->extra_func == special_extra_special_bomb) {
    if (NULL != bomb_name[data->buttonBMT])  {
      sprintf(info[count],"%s as an extra",bomb_name[data->buttonBMT]);
      if ( ++count >= MAX_INFO) {
	goto MessagesFinished;
      }
    }
  }
  
  /* look for invisible walls etc */
  if (data->block[BTBlock].id == data->block[BTFree].id) {
    sprintf(info[count],"Walls are invisble");
    if ( ++count >= MAX_INFO) {
      goto MessagesFinished;
    }
  }
  /* look for shrink function */
  if (set_func_info(data->shrink_func, shrink_info, &(info[count])) ) {
    if ( ++count >= MAX_INFO) {
      goto MessagesFinished;
    }
  }
  /* look for game functions */
  if (set_func_info(data->game_func, game_info, &(info[count])) ) {
    if ( ++count >= MAX_INFO) {
      goto MessagesFinished;
    }
  }
  /* look up fuse times */
  if (set_value_info(data->fuse_time, fuse_info, &(info[count])) ) {
    if ( ++count >= MAX_INFO) {
      goto MessagesFinished;
    }
  }
  /* look inital bomb  direction */
  if (set_value_info(data->bomb_dir+1, bomb_dir_info, &(info[count])) ) {
    if ( ++count >= MAX_INFO) {
      goto MessagesFinished;
    }
  }
  /* look for bomb_click */
  if (set_value_info(data->bomb_click, bomb_click_info, &(info[count])) ) {
    if ( ++count >= MAX_INFO) {
      goto MessagesFinished;
    }
  }
  /* look for wall_click */
  if (set_value_info(data->wall_click, wall_click_info, &(info[count])) ) {
    if ( ++count >= MAX_INFO) {
      goto MessagesFinished;
    }
  }
  /* look for player_click */
  if (set_value_info(data->player_click, player_click_info, &(info[count]))) {
    if ( ++count >= MAX_INFO) {
      goto MessagesFinished;
    }
  }
  
  return;
 MessagesFinished:
  fprintf(stderr, "Too many messages\n");
  return ;
}


/*
 * extra info strings
 */

static char *extra_info[] = {
  NULL,
  "%s are scarce",
  "%s are rare",
  "%s are uncommon",
  "%s are common",
  "%s are plentilful"
};

/* special extras */

/*
 * local function set_extra_info
 */
#ifdef __STDC__
static int
set_extra_info (int val, char *name, char **line)
#else
static int
set_extra_info (val, name, line)
     int val; 
     char *name; 
     char **line;
#endif
{
  int rate;

  /* first get rating */
  if (val <= 0) {
    rate = XR_None;
  } else if (val <=4) {
    rate = XR_Scarce;
  } else if (val <=8) {
    rate = XR_Rare;
  } else if (val <=16) {
    rate = XR_Uncommon;
  } else if (val <=32) {
    rate = XR_Common;
  } else {
    rate= XR_Plentiful;
  }

  if (NULL != extra_info[rate]) {
    sprintf(*line, extra_info[rate], name);
    return 1;
  }
  return 0;
}

/*
 * public function get_extra_info
 *
 * general info about the extras
 */
#ifdef __STDC__void 
get_extra_info (int level,
		char **info)
#else
void 
get_extra_info (level, info)
     int level;
     char **info;
#endif
{
  int i,count;
  BMLevelData *data = maze_data[level];

  /* reset extra info */
  for (i=0; i<MAX_INFO; i++) {
    info[i][0] = '\0';
  }

  count = 0;
  
  /* look for bombs */
  if (set_extra_info(data->prob.bomb, "Bomb extras" , &(info[count]) ) ) {
    if ( ++count >= MAX_INFO) {
      goto MessagesFinished;
    }
  }
  /* look for ranges */
  if (set_extra_info(data->prob.range - data->prob.bomb, "Range extras", 
		     &(info[count]) ) ) {
    if ( ++count >= MAX_INFO) {
      goto MessagesFinished;
    }
  }
  /* look for traps */
  if (set_extra_info(data->prob.ill - data->prob.range, "Infections", 
		     &(info[count]) ) ) {
    if ( ++count >= MAX_INFO) {
      goto MessagesFinished;
    }
  }
  /* look for special bombs */
  if (set_extra_info(data->prob.invinc - data->prob.ill, "Special extras", 
		     &(info[count]) ) ) {
    if ( ++count >= MAX_INFO) {
      goto MessagesFinished;
    }
  }
  /* look for evil bombs */
  if (set_extra_info(data->prob.evil - data->prob.invinc, "Hidden Bombs", 
		     &(info[count]) ) ) {
    if ( ++count >= MAX_INFO) {
      goto MessagesFinished;
    }
  }

  return;
 MessagesFinished:
  fprintf(stderr, "Too many messages\n");
  return ;
}

/*
 * illness info strings
 */
static char *sick_info[] = {
  NULL,
  "Permanent random bombing",
  "Permanent slowdown",
  "Permanent running",
  "Permanent mini bombs",
  "No bombs while healthy",
  "Permanent invisibility",
  "Permanent malfunctions",
  "Permanent reverse controls",
};


/*
 * public function get_player_info
 *
 * get info about player equipment and status
 */
#ifdef __STDC__
void 
get_player_info (int level, 
		 char **info)
#else
void 
get_player_info (level, info)
     int level;
     char **info;
#endif
{
  int i,count;
  BMLevelData *data = maze_data[level];

  /* reset extra info */
  for (i=0; i<MAX_INFO; i++) {
    info[i][0] = '\0';
  }

  count = 0;
  
  /* get number of bombs */
  switch(data->bombs) {
  case 0:
    sprintf(info[count], "No bombs");
    break;
  case 1:
    sprintf(info[count], "1 bomb");
    break;
  default:
    sprintf(info[count], "%d bombs", data->bombs);
    break;
  }
  if ( ++count >= MAX_INFO) {
    goto MessagesFinished;
  }

  /* get number of bombs */
  switch (data->range) {
  case 0:
    sprintf(info[count], "No initial Range");
    break;
  case 1:
    sprintf(info[count], "Initial mini bombs");
    break;
  default:
    sprintf(info[count], "Initial range %d", data->range);
    break;
  }
  if ( ++count >= MAX_INFO) {
    goto MessagesFinished;
  }

  /* special bombs as default */
  if (NULL != bomb_name[data->defaultBMT])  {
    sprintf(info[count],"%ss as default",bomb_name[data->defaultBMT]);
    if ( ++count >= MAX_INFO) {
      goto MessagesFinished;
    }
  }
  /* look up 30 special func */
  if (data->init_func == special_init_special_bombs_30) {
    sprintf(info[count],"30 %ss",bomb_name[data->buttonBMT]);
    if ( ++count >= MAX_INFO) {
      goto MessagesFinished;
    }
  }
  
  /* check inital illness */
  if (set_value_info(data->init_health, sick_info, &(info[count])) ) {
    if ( ++count >= MAX_INFO) {
      goto MessagesFinished;
    }
  }

  /* look for default extras */
  if (IF_Kick & data->init_flags) {
    sprintf(info[count], "Kick extra as default");
    if ( ++count >= MAX_INFO) {
      goto MessagesFinished;
    }
  }
  if (IF_RC & data->init_flags) {
    sprintf(info[count], "Remote control as default");
    if ( ++count >= MAX_INFO) {
      goto MessagesFinished;
    }
  }
  if (IF_Teleport & data->init_flags) {
    sprintf(info[count], "Teleport as default");
    if ( ++count >= MAX_INFO) {
      goto MessagesFinished;
    }
  }

  return;
 MessagesFinished:
  fprintf(stderr, "Too many messages\n");
  return ;
}
/*
 * end of file info.c
 */


