/* u_opt2.cc
 *$Header: /al/acs/src/RCS/u_opt2.cc,v 9.27 95/11/01 02:52:31 al Exp $
 * command and functions to access OPT class
 */
#include "constant.h"
#include "ap.h"
#include "error.h"
#include "io.h"
#include "u_opt.h"
#include "c_comand.h"
#include "s__.h"
#include "util.h"
/*--------------------------------------------------------------------------*/
//static void	OPT::command(CS& cmd);
//static int	OPT::set(CS& cmd);
//static void	OPT::print(int where)
/*--------------------------------------------------------------------------*/
/*static*/ void OPT::command(CS& cmd)
{
  int changed = set(cmd);
  if (!changed || opts){
    print(IO::mstdout);
  }
}
/*--------------------------------------------------------------------------*/
/* set:  set options from a string
 */
/*static*/ int OPT::set(CS& cmd)
{
  int dummy;
  int ii;
  double arg1, arg2;
  int changed = FALSE;
  
  while (cmd.more()){
    if (cmd.argparse(REPEAT,
    	"ACCT",		aENUM,		&acct,		TRUE,
    	"NOACCT",	aENUM,		&acct,		FALSE,
	"LIST",		aENUM,		&list,		TRUE,
	"NOLIST",	aENUM,		&list,		FALSE,
	"MOD",		aENUM,		&nomod,		FALSE,
	"NOMOD",	aENUM,		&nomod,		TRUE,
	"PAGE",		aENUM,		&page,		TRUE,
	"NOPAGE",	aENUM,		&page,		FALSE,
	"NODE",		aENUM,		&node,		TRUE,
	"NONODE",	aENUM,		&node,		FALSE,
	"OPTS",		aENUM,		&opts,		TRUE,
	"NOOPTS",	aENUM,		&opts,		FALSE,
	"GMIN",		aUDOUBLE,	&gmin,
	"RELTOL",	aUDOUBLE,	&reltol,
	"ABSTOL",	aUDOUBLE,	&abstol,
	"VNTOL",	aUDOUBLE,	&vntol,
	"TRTOL",	aUDOUBLE,	&trtol,
	"CHGTOL",	aUDOUBLE,	&chgtol,
	"PIVTOL",	aUDOUBLE,	&pivtol,
	"PIVREL",	aUDOUBLE,	&pivrel,
	"NUMDGT",	aFINT,		&numdgt,
	"TNOM",		aODOUBLE,	&tnom,		-ABS_ZERO,
	"CPTIME",	aFINT,		&cptime,
	"LIMTIM",	aFINT,		&limtim,
	"LIMPTS",	aFINT,		&limpts,
	"LVLCOD",	aFINT,		&lvlcod,
	"LVLTIM",	aFINT,		&lvltim,
	"METHOD",	aENUM,		&dummy,		TRUE,
	"GEAR",		aENUM,		&method,	mGEAR,
	"TRAPezoidal",	aENUM,		&method,	mTRAPEZOID,
	"MAXORD",	aFINT,		&maxord,
	"DEFL", 	aUDOUBLE,	&defl,
	"DEFW", 	aUDOUBLE,	&defw,
	"DEFAD",	aUDOUBLE,	&defad,
	"DEFAS",	aUDOUBLE,	&defas,
 	"")){
      changed = TRUE;
    }else if (cmd.argparse(REPEAT,
	"Seed",		aFINT,		&seed,
	"WCZero",	aUDOUBLE,	&wczero,
	"DAMPMAX",	aUDOUBLE,	&dampmax,
	"DAMPMIN",	aUDOUBLE,	&dampmin,
	"DAMPSTrategy",	aOCTAL,		&dampstrategy,
	"Floor",	aUDOUBLE,	&floor,
	"Tempamb",	aODOUBLE,	&tempamb,	-ABS_ZERO,
	"Short",	aUDOUBLE,	&shortckt,
	"TRansits",	aFINT,		&transits,
	"INwidth",	aFINT,		&inwidth,
	"OUTwidth",	aFINT,		&outwidth,
	"XDivisions",	aUDOUBLE,	&xdivisions,
	"YDivisions",	aUDOUBLE,	&ydivisions,
 	"")){
      changed = TRUE;
    }else if (cmd.argparse(REPEAT,
	"NAG",		aENUM,		&picky,	bNOERROR,
	"NONAG",	aENUM,		&picky,	bTRACE,
	"TRACE",	aENUM,		&picky,	bTRACE,
	"NOTRACE",	aENUM,		&picky,	bLOG,
	"LOG",		aENUM,		&picky,	bLOG,
	"NOLOG",	aENUM,		&picky,	bDEBUG,
	"DEBUG",	aENUM,		&picky,	bDEBUG,
	"NODEBUG",	aENUM,		&picky,	bPICKY,
	"PICKY",	aENUM,		&picky,	bPICKY,
	"NOPICKY",	aENUM,		&picky,	bWARNING,
	"WARNing",	aENUM,		&picky,	bWARNING,
	"NOWARN",	aENUM,		&picky,	bDANGER,
	"ERRor",	aENUM,		&picky,	bERROR,
	"NOERRor",	aENUM,		&picky,	bDISASTER,
	"DISASTER",	aENUM,		&picky,	bDISASTER,
	"")){
      changed = TRUE;
    }else if (cmd.argparse(REPEAT,
	"ORder",	aENUM,		&dummy,		TRUE,
	"REVerse",	aENUM,		&order,		oREVERSE,
	"FORward",	aENUM,		&order,		oFORWARD,
	"AUTo",		aENUM,		&order,		oAUTO,
	"MODe",		aENUM,		&dummy,		TRUE,
	"ANAlog",	aENUM,		&mode,		mANALOG,
	"DIGital",	aENUM,		&mode,		mDIGITAL,
	"MIXed",	aENUM,		&mode,		mMIXED,
	"DUPcheck",	aENUM,		&dupcheck,	TRUE,
	"NODUPcheck",	aENUM,		&dupcheck,	FALSE,
	"BYPass",	aENUM,		&bypass,	TRUE,
	"NOBYPass",	aENUM,		&bypass,	FALSE,
	"VBYPass",	aENUM,		&bypass,	bVOLT,
	"INCmode",	aENUM,		&incmode,	TRUE,
	"NOIncmode",	aENUM,		&incmode,	FALSE,
	"LUBypasss",	aENUM,		&lubypass,	TRUE,
	"NOLUbypass",	aENUM,		&lubypass,	FALSE,
	"LIMIT",	aUDOUBLE,	&limit,
	"VMAX",		aDOUBLE,	&vmax,
	"VMIN",		aDOUBLE,	&vmin,
	"MRT",		aUDOUBLE,	&dtmin,
	"DTMIn",	aUDOUBLE,	&dtmin,
	"DTRatio",	aUDOUBLE,	&dtratio,
	"RSTray",	aENUM,		&rstray,	TRUE,
	"NORSTray",	aENUM,		&rstray,	FALSE,
	"CSTray",	aENUM,		&cstray,	TRUE,
	"NOCSTray",	aENUM,		&cstray,	FALSE,
	"Harmonics",	aFINT,		&harmonics,
	"TRSTEPGrow",	aUDOUBLE,	&trstepgrow,
	"TRSTEPShrink",	aUDOUBLE,	&trstepshrink,
	"TRReject",	aUDOUBLE,	&trreject,
	"SHOWALL",	aENUM,		&showall,	TRUE,
	"NOSHOWALL",	aENUM,		&showall,	FALSE,
	"FOOOO",	aFINT,		&foooo,
	"DIODEflags",	aOCTAL,		&diodeflags,
	"MOSflags",	aOCTAL,		&mosflags,
 	"")){
      changed = TRUE;
    }else if (ii = cmd.index(), cmd.argparse(ONEPASS,
        "ITL",		a2DOUBLE,	&arg1,		&arg2,
	"")){
      if ((int)arg1 >= 1  &&  (int)arg1 < ITL_COUNT){
	itl[(int)arg1] = (int)arg2;
      }else{
	cmd.reset(ii);
	cmd.check(bWARNING);
	cmd.skiparg();
      }
      changed = TRUE;
    }else{
      cmd.check(bWARNING);
      cmd.skiparg();
    }
  }
  
  if (changed){
    SIM::uninit();
    lowlim = 1 - reltol;
    uplim  = 1 + reltol;
    outwidth = min(abs(outwidth), MAXWIDTH);
  }
  return changed;
}
/*--------------------------------------------------------------------------*/
/* print: "print" all option values to "where"
 * string is in a form suitable for passing to set
 */
/*static*/ void OPT::print(int where)
{
  int ii;
  mprintf(where, ".options ");
  mprintf(where, " %sacct ", ((acct)?"":"no"));
  mprintf(where, " %slist ", ((list)?"":"no"));
  mprintf(where, " %smod ", ((nomod)?"no":""));
  mprintf(where, " %spage ", ((page)?"":"no"));
  mprintf(where, " %snode ", ((node)?"":"no"));
  mprintf(where, " %sopts ", ((opts)?"":"no"));
  mprintf(where, " gmin=%s ",   ftos(gmin,   "", 7, 0));
  mprintf(where, " reltol=%s ", ftos(reltol, "", 7, 0));
  mprintf(where, " abstol=%s ", ftos(abstol, "", 7, 0));
  mprintf(where, " vntol=%s ",  ftos(vntol,  "", 7, 0));
  mprintf(where, " trtol=%s ",  ftos(trtol,  "", 7, 0));
  mprintf(where, " chgtol=%s ", ftos(chgtol, "", 7, 0));
  mprintf(where, " pivtol=%s ", ftos(pivtol, "", 7, 0));
  mprintf(where, " pivrel=%s ", ftos(pivrel, "", 7, 0));
  mprintf(where, " numdgt=%d ", numdgt);
  mprintf(where, " tnom=%s ",   ftos(tnom+ABS_ZERO,   "", 7, 0));
  mprintf(where, " cptime=%d ", cptime);
  mprintf(where, " limtim=%d ", limtim);
  mprintf(where, " limpts=%d ", limpts);
  mprintf(where, " lvlcod=%d ", lvlcod);
  mprintf(where, " lvltim=%d ", lvltim);
  if (method == mTRAPEZOID) mprintf(where, " method=trapezoid ");
  else if (method == mGEAR) mprintf(where, " method=gear ");
  mprintf(where, " maxord=%d ", maxord);
  for (ii=1;  ii<ITL_COUNT;  ii++)
    mprintf(where, " itl%d=%d ", ii, itl[ii]);
  mprintf(where, " defl=%s ", ftos(defl, "", 7, 0));
  mprintf(where, " defw=%s ", ftos(defw, "", 7, 0));
  mprintf(where, " defad=%s ", ftos(defad, "", 7, 0));
  mprintf(where, " defas=%s ", ftos(defas, "", 7, 0));
  mprintf(where, " seed=%d ",   seed);
  mprintf(where, " wczero=%s ", ftos(wczero,  "", 7, 0));
  mprintf(where, " dampmax=%s ",   ftos(dampmax,    "", 7, 0));
  mprintf(where, " dampmin=%s ",   ftos(dampmin,    "", 7, 0));
  mprintf(where, " dampstrategy=%o ", dampstrategy);
  mprintf(where, " floor=%s ",  ftos(floor,   "", 7, 0));
  mprintf(where, " tempamb=%s ",ftos(tempamb+ABS_ZERO, "", 7, 0));
  mprintf(where, " short=%s ",  ftos(shortckt,"", 7, 0));
  mprintf(where, " in=%d ",     inwidth);
  mprintf(where, " out=%d ",    outwidth);
  mprintf(where, " xdivisions=%s ",  ftos(xdivisions,   "", 7, 0));
  mprintf(where, " ydivisions=%s ",  ftos(ydivisions,   "", 7, 0));
  if (order == oREVERSE) mprintf(where, " order=reverse ");
  else if (order == oFORWARD) mprintf(where, " order=forward ");
  else if (order == oAUTO) mprintf(where, " order=auto ");
  if (mode == mANALOG) mprintf(where, " mode=analog ");
  else if (mode == mDIGITAL) mprintf(where, " mode=digital ");
  else if (mode == mMIXED) mprintf(where, " mode=mixed ");
  mprintf(where, " transits=%d ",transits);
  mprintf(where," %sdupcheck ", ((dupcheck)?"":"no"));  
  if (bypass == FALSE) mprintf(where, " nobypass ");
  else if (bypass == TRUE) mprintf(where, " bypass ");
  else if (bypass == bVOLT) mprintf(where, " vbypass ");
  mprintf(where, " %sincmode ", ((incmode)?"":"no"));    
  mprintf(where, " %slubypass ", ((lubypass)?"":"no"));    
  mprintf(where, " limit=%s ",  ftos(limit,"", 7, 0));
  mprintf(where, " vmax=%s ",  ftos(vmax,"", 7, 0));
  mprintf(where, " vmin=%s ",  ftos(vmin,"", 7, 0));
  mprintf(where, " dtmin=%s ",  ftos(dtmin,"", 7, 0));
  mprintf(where, " dtratio=%s ",  ftos(dtratio,"", 7, 0));
  mprintf(where, " %srstray ", ((rstray)?"":"no"));    
  mprintf(where, " %scstray ", ((cstray)?"":"no"));    
  mprintf(where, " harmonics=%d ", harmonics);
  mprintf(where, " trstepgrow=%s ",  ftos(trstepgrow,"", 7, 0));
  mprintf(where, " trstepshrink=%s ",  ftos(trstepshrink,"", 7, 0));
  mprintf(where, " trreject=%s ",  ftos(trreject,"", 7, 0));
  mprintf(where, " diodeflags=%o ", diodeflags);
  mprintf(where, " mosflags=%o ", mosflags);
  mputc('\n',where);
}
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
