/**
 *
 * $Id: ScrolledWP.h,v 1.3 1996/02/12 00:52:43 u27113 Exp $
 * 
 * Copyright (C) 1995 Free Software Foundation, Inc.
 *
 * This file is part of the GNU LessTif Library.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 **/

#ifndef XM_SCROLLEDW_P_H
#define XM_SCROLLEDW_P_H

#include <Xm/ScrolledW.h>
#include <Xm/ManagerP.h>

#ifdef __cplusplus
extern "C" {
#endif

/* Define the Scrolled window instance part */
typedef struct {
    int vmin;				/* vsb min coord pos (in work area??) */
    int vmax;
    int vOrigin;			/* slider edge */
    int vExtent;			/* slider size */

    int hmin;
    int hmax;
    int hOrigin;
    int hExtent;

    Position hsbX, hsbY;
    Dimension hsbWidth, hsbHeight;

    Position vsbX, vsbY;
    Dimension vsbWidth, vsbHeight;

    Dimension GivenHeight, GivenWidth;	/* work window size ?? */

    Dimension AreaWidth, AreaHeight;	/* clip window size ?? */
    Dimension WidthPad, HeightPad;	/* XmNscrolledWindowMarginWidth,
					 * XmNscrolledWindowMarginHeight ?? */
    Position XOffset, YOffset;		/* position of clip window ?? */

    Dimension pad;			/* XmNspacing ?? */

    Boolean hasHSB;
    Boolean hasVSB;
    Boolean InInit;
    Boolean FromResize;

    unsigned char VisualPolicy;		/* XmNvisualPolicy */
    unsigned char ScrollPolicy;		/* XmNscrollingPolicy */
    unsigned char ScrollBarPolicy;	/* XmNscrollBarDisplayPolicy */
    unsigned char Placement;		/* XmNscrollBarPlacement */

    Widget hScrollBar;			/* XmNhorizontalScrollBar */
    Widget vScrollBar;			/* XmNverticalScrollBar */
    Widget ClipWindow;			/* XmNclipWindow */
    Widget WorkWindow;			/* XmNworkWindow */

    XtCallbackList traverseObscuredCallback;
} XmScrolledWindowPart;

/* Define the full instance record */
typedef struct _XmScrolledWindowRec {
    CorePart core;
    CompositePart composite;
    ConstraintPart constraint;
    XmManagerPart manager;
    XmScrolledWindowPart swindow;
} XmScrolledWindowRec;

/* Define class part structure */
typedef struct {
    XtPointer extension;
} XmScrolledWindowClassPart;

/* Defint the full class record */
typedef struct _XmScrolledWindowClassRec {
    CoreClassPart core_class;
    CompositeClassPart composite_class;
    ConstraintClassPart constraint_class;
    XmManagerClassPart manager_class;
    XmScrolledWindowClassPart scrolled_window_class;
} XmScrolledWindowClassRec;

extern XmScrolledWindowClassRec xmScrolledWindowClassRec;

#define SW_VSBMinimum(w) \
    (((XmScrolledWindowWidget)w)->swindow.vmin)

#define SW_VSBMaximum(w) \
    (((XmScrolledWindowWidget)w)->swindow.vmax)

#define SW_VSBValue(w) \
    (((XmScrolledWindowWidget)w)->swindow.vOrigin)

#define SW_VSBSliderSize(w) \
    (((XmScrolledWindowWidget)w)->swindow.vExtent)

#define SW_HSBMinimum(w) \
    (((XmScrolledWindowWidget)w)->swindow.hmin)

#define SW_HSBMaximum(w) \
    (((XmScrolledWindowWidget)w)->swindow.hmax)

#define SW_HSBValue(w) \
    (((XmScrolledWindowWidget)w)->swindow.hOrigin)

#define SW_HSBSliderSize(w) \
    (((XmScrolledWindowWidget)w)->swindow.hExtent)

#define SW_HSBX(w) \
    (((XmScrolledWindowWidget)w)->swindow.hsbX)

#define SW_HSBY(w) \
    (((XmScrolledWindowWidget)w)->swindow.hsbY)

#define SW_HSBWidth(w) \
    (((XmScrolledWindowWidget)w)->swindow.hsbWidth)

#define SW_HSBHeight(w) \
    (((XmScrolledWindowWidget)w)->swindow.hsbHeight)

#define SW_VSBX(w) \
    (((XmScrolledWindowWidget)w)->swindow.vsbX)

#define SW_VSBY(w) \
    (((XmScrolledWindowWidget)w)->swindow.vsbY)

#define SW_VSBWidth(w) \
    (((XmScrolledWindowWidget)w)->swindow.vsbWidth)

#define SW_VSBHeight(w) \
    (((XmScrolledWindowWidget)w)->swindow.vsbHeight)

#define SW_WorkWidth(w) \
    (((XmScrolledWindowWidget)w)->swindow.GivenWidth)

#define SW_WorkHeight(w) \
    (((XmScrolledWindowWidget)w)->swindow.GivenHeight)

#define SW_ClipWidth(w) \
    (((XmScrolledWindowWidget)w)->swindow.AreaWidth)

#define SW_ClipHeight(w) \
    (((XmScrolledWindowWidget)w)->swindow.AreaHeight)

#define SW_MarginWidth(w) \
    (((XmScrolledWindowWidget)w)->swindow.WidthPad)

#define SW_MarginHeight(w) \
    (((XmScrolledWindowWidget)w)->swindow.HeightPad)

#define SW_ClipX(w) \
    (((XmScrolledWindowWidget)w)->swindow.XOffset)

#define SW_ClipY(w) \
    (((XmScrolledWindowWidget)w)->swindow.YOffset)

#define SW_Spacing(w) \
    (((XmScrolledWindowWidget)w)->swindow.pad)

#define SW_HasHSB(w) \
    (((XmScrolledWindowWidget)w)->swindow.hasHSB)

#define SW_HasVSB(w) \
    (((XmScrolledWindowWidget)w)->swindow.hasVSB)

#define SW_InInit(w) \
    (((XmScrolledWindowWidget)w)->swindow.InInit)

#define SW_FromResize(w) \
    (((XmScrolledWindowWidget)w)->swindow.FromResize)

#define SW_VisualPolicy(w) \
    (((XmScrolledWindowWidget)w)->swindow.VisualPolicy)

#define SW_ScrollPolicy(w) \
    (((XmScrolledWindowWidget)w)->swindow.ScrollPolicy)

#define SW_ScrollBarPolicy(w) \
    (((XmScrolledWindowWidget)w)->swindow.ScrollBarPolicy)

#define SW_Placement(w) \
    (((XmScrolledWindowWidget)w)->swindow.Placement)

#define SW_HSB(w) \
    (((XmScrolledWindowWidget)w)->swindow.hScrollBar)

#define SW_VSB(w) \
    (((XmScrolledWindowWidget)w)->swindow.vScrollBar)

#define SW_ClipWindow(w) \
    (((XmScrolledWindowWidget)w)->swindow.ClipWindow)

#define SW_WorkWindow(w) \
    (((XmScrolledWindowWidget)w)->swindow.WorkWindow)

#define SW_TraverseObscuredCallback(w) \
    (((XmScrolledWindowWidget)w)->swindow.traverseObscuredCallback)

#ifdef __cplusplus
};
#endif

#endif /* XM_SCROLLEDW_P_H */
