.TH gk_lockmanager n "7 April 1995" "GroupKit"
.SH NAME
gk_lockmanager \- a distributed locking mechanism
.SH SYNOPSIS
\fBgk_lockmanager \fIlockMgr\fR
.SH DESCRIPTION

The locking layer serves as a mechanism to manage locking data for
clients in a GroupKit conference.  In most applications, one lock
manager is created per conference.  The lock manager is a very simple
environment that stores the lock name and related information.  All
locks are managed through the lock manager.  In addition to the
standard operations on locks, a conflict detection procedure for lock
names can be specified on a per manager basis.

An instance of a lock manager is created with the \fBgk_lockmanager\fR
command, which specifies a name for the lock manager.  This creates a
\fIlock manager command\fR, similar to Tk's widget commands, which are
used to manipulate the lock manager.

.SH LOCK MANAGER COMMAND

The \fBgk_lockmanager\fR command creates a new Tcl command whose name
is \fIlockMgr\fR.  This command may be used to invoke various
operations on the lock manager.  It has the following general form:
.PP
.RS 5
\fIlockMgr option ?arg arg ...?\fR
.PP
.RE
The following subcommands are defined for lock managers:

.TP
\fIlockMgr\fB request\fI name callback ?timeout?\fR
Request a lock named \fIname\fR.  
This command returns immediately, before the lock request is complete.
The result is obtained through the
callback which is a Tcl command that takes as its last parameter the
word \fB"Succeeded"\fR or \fB"Failed"\fR.  
If the lock is not granted with the timeout period, the callback is
executed with the value \fB"Failed"\fR.

The \fBrequest\fR command also returns a transaction identifier for
the pending request that can be used by the \fBstatus\fR command to query
the state to the request.

.TP
\fIlockMgr \fBrelease \fIname\fR
Release the lock named \fIname\fR.  
Again, this command returns immediately.  Your program will not receive
notification when the lock has actually been released.

.TP
\fIlockMgr\fB status \fIidentifier\fR

Query the current state of the request for the transaction identifier.
The transaction identifier can be obtained from the return value of the
\fBrequest\fR command.  The \fBstatus\fR command returns the values
\fB"Succeeded"\fR, \fB"Failed"\fR and \fB"Pending"\fR.

.TP
\fIlockMgr\fB owner \fIname\fR
Return the user number of the owner of the lock \fIname\fR.  If the lock
is not found, then the empty string is returned.

.TP
\fIlockMgr\fB locks\fR
Returns a list of the current locks.

.TP
\fIlockMgr\fB setconflictproc \fIcommand\fR
Customize the conflict detection scheme for the locking data.  If a
conflict is detected, this command must return the value 1, or the
value 0 otherwise.  The default scheme is to assume that two locks
having the same name conflict, and two locks with different names
don't conflict.  This hook may be used to provide a more sophisticated
scheme, such as for overlapping locks in a text buffer.

.TP
\fIlockMgr\fB destroy\fR
Destroy the lock manager, its associated data, and the lock manager
command.

.SH NOTES

The locking mechanism described here is a storage and retrieval system
designed to maintain information about a set of locks.  This provides
an underlying, independent data structure for the creation of more
complicated locking mechanisms, in applications such as a GroupKit user
interface.

In the underlying implementation, lock requests are serialized through
a single GroupKit conference process.  Every other conference process
keeps a local cache of the existing locks.  Requests to change locks
(e.g. \fBrequest\fR, \fBrelease\fR) will be sent to the serializing
process, while state queries (e.g. \fBlocks\fR, \fBowner\fR) are
executed locally by examining this cache.

.SH AUTHOR
Terrence Asgar-Deen (terrence@cpsc.ucalgary.ca)
