------------------------------------------------------------------------------
--                                                                          --
--                 GNU ADA RUNTIME LIBRARY (GNARL) COMPONENTS               --
--                                                                          --
--                     S Y S T E M . T A S K _ C L O C K                    --
--                                                                          --
--                                  B o d y                                 --
--                                                                          --
--                             $Revision: 1.2 $                             --
--                                                                          --
--     Copyright (C) 1992,1993,1994,1995 Free Software Foundation, Inc.     --
--                                                                          --
-- GNARL is free software; you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion. GNARL is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with GNARL; see file COPYING.  If not, write --
-- to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
-- MA 02111-1307, USA.                                                      --
--                                                                          --
-- As a special exception,  if other files  instantiate  generics from this --
-- unit, or you link  this unit with other files  to produce an executable, --
-- this  unit  does not  by itself cause  the resulting  executable  to  be --
-- covered  by the  GNU  General  Public  License.  This exception does not --
-- however invalidate  any other reasons why  the executable file  might be --
-- covered by the  GNU Public License.                                      --
--                                                                          --
-- GNARL was developed by the GNARL team at Florida State University. It is --
-- now maintained by Ada Core Technologies Inc. in cooperation with Florida --
-- State University (http://www.gnat.com).                                  --
--                                                                          --
------------------------------------------------------------------------------

--  This implemetation is a version where no tasking supports provided.

package body System.Task_Clock is

   procedure Put_Character (C : Integer);
   pragma Import (C, Put_Character, "putchar");

   procedure Prog_Exit (Status : Integer);
   pragma Import (C, Prog_Exit, "exit");

   procedure Write_Character (C : Character);
   procedure Write_EOL;
   procedure Write_String (S : String);
   --  Debugging procedures used for assertion output

   procedure Unimplemented (Feature : String);
   --  This procedure writes out a message to the effect that the
   --  feature specified by the Feature string is unimplemented,
   --  and halts the program.

   ---------------------
   -- Write_Character --
   ---------------------

   procedure Write_Character (C : Character) is
   begin
      Put_Character (Character'Pos (C));
   end Write_Character;

   ---------------
   -- Write_Eol --
   ---------------

   procedure Write_EOL is
   begin
      Write_Character (Ascii.LF);
   end Write_EOL;

   ------------------
   -- Write_String --
   ------------------

   procedure Write_String (S : String) is
   begin
      for J in S'Range loop
         Write_Character (S (J));
      end loop;
   end Write_String;

   -------------------
   -- Unimplemented --
   -------------------

   procedure Unimplemented (Feature : String) is
   begin
      Write_String (Feature);
      Write_String (" is unimplemented in this version of GNARL.");
      Write_EOL;
      Prog_Exit (1);
   end Unimplemented;

   -----------------------
   -- Stimespec_Seconds --
   -----------------------

   function Stimespec_Seconds (TV : Stimespec) return Integer is
      Tmp : Stimespec := TV / Stimespec_Sec_Unit;
   begin
      Unimplemented ("Tasking");
      return 0;
   end Stimespec_Seconds;

   ------------------------
   -- Stimespec_Nseconds --
   -------------------------

   function Stimespec_NSeconds (TV : Stimespec) return Integer is
   begin
      Unimplemented ("Tasking");
      return 0;
   end Stimespec_NSeconds;

   -------------
   -- Time_Of --
   -------------

   function Time_Of (S, NS : Integer) return Stimespec is
   begin
      Unimplemented ("Tasking");
      return  Stimespec_Zero;
   end Time_Of;

   ---------------------------
   -- Stimespec_To_Duration --
   ---------------------------

   function Stimespec_To_Duration (TV : Stimespec) return Duration is
   begin
      Unimplemented ("Tasking");
      return 0.0;
   end Stimespec_To_Duration;

   ---------------------------
   -- Duration_To_Stimespec --
   ---------------------------

   function Duration_To_Stimespec (Time : Duration) return Stimespec is
   begin
      Unimplemented ("Tasking");
      return Stimespec_Zero;
   end Duration_To_Stimespec;

   ---------
   -- "-" --
   ---------

   --  Unary minus
   function "-" (TV : Stimespec) return Stimespec is
   begin
      Unimplemented ("Tasking");
      return Stimespec_Zero;
   end "-";

   ---------
   -- "+" --
   ---------

   function "+" (LTV, RTV : Stimespec) return Stimespec is
   begin
      Unimplemented ("Tasking");
      return Stimespec_Zero;
   end "+";

   ---------
   -- "-" --
   ---------

   function "-" (LTV, RTV : Stimespec) return Stimespec is
   begin
      Unimplemented ("Tasking");
      return Stimespec_Zero;
   end "-";

   ---------
   -- "*" --
   ---------

   function "*" (TV : Stimespec; N : Integer) return Stimespec is
   begin
      Unimplemented ("Tasking");
      return Stimespec_Zero;
   end "*";

   ---------
   -- "/" --
   ---------

   function "/" (TV : Stimespec; N : Integer) return Stimespec is
   begin
      Unimplemented ("Tasking");
      return Stimespec_Zero;
   end "/";

   ---------
   -- "/" --
   ---------

   function "/" (LTV, RTV : Stimespec) return Integer is
      Tmp : Stimespec := LTV / RTV;
   begin
      Unimplemented ("Tasking");
      return 0;
   end "/";

   ---------
   -- "<" --
   ---------

   function "<" (LTV, RTV : Stimespec) return Boolean is
   begin
      Unimplemented ("Tasking");
      return false;
   end "<";

   ----------
   -- "<=" --
   ----------

   function "<=" (LTV, RTV : Stimespec) return Boolean is
   begin
      Unimplemented ("Tasking");
      return false;
   end "<=";

   ---------
   -- ">" --
   ---------

   function ">" (LTV, RTV : Stimespec) return Boolean is
   begin
      Unimplemented ("Tasking");
      return false;
   end ">";

   ----------
   -- ">=" --
   ----------

   function ">=" (LTV, RTV : Stimespec) return Boolean is
   begin
      Unimplemented ("Tasking");
      return false;
   end ">=";

end System.Task_Clock;
