/*
 * config.h for tiny-cat - This file is part of the tiny-utils package for
 * Linux and ELKS, Copyright (C) 1995, 1996 Nat Friedman <ndf@linux.mit.edu>.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

/*
 * The higher this is, the less CPU used on a large cat,
 *  but the larger the footprint.  Generally there's an
 *  extremely good speed/memory payoff up to a point,
 *  where it starts to fall off (why does it fall off?)
 *  Anyway, just so people don't think I'm an idiot, tiny-cat
 *  and all optimization therein is kind of a joke.
 */
#define BUFFER_SIZE 2048

/*
 * Define USE_MYSTRERROR to use tiny-cat's built-in strerror()
 * function instead of the one in libc.  In Linux/386, strerror()
 * is 60k, so it's a good idea to define this.
 */
#define USE_MYSTRERROR
