#!	/bin/sh
#!	/bin/sh
# Boot Disk maker. Bruce Perens, July-September 1995
# This is free software under the GNU General Public License.

# Abort on any non-zero return.
set -e

# Verbose shell execution.
# set -x
# set -v

# Remove this soon - most people should run kerneld.
(modprobe msdos floppy; exit 0)

# Print a usage message and exit if the argument count is wrong.
if [ $# -lt 3 ]; then
echo "Usage: $0 floppy-drive blocks package [package ...]" 1>&2
	cat 1>&2 << EOF

	floppy-drive: the block device file for the floppy drive.
	blocks: the size of the floppy in 1K blocks, use 720, 1200, or 1440
	package: a Debian package that installs files in /lib/modules

	/mnt must be available for mounting the floppy disk.

EOF

	exit -1
fi

floppy=$1
shift
blocks=$1
shift

# Make sure the packages are available.
for i in $@; do
	if [ ! -f $i ]; then
		echo "Can't find $i" 1>&2
		exit -1
	fi
done

# Make sure the specified disk device is indeed a block device.
if [ ! -b $floppy ]; then
	echo "Error: "$floppy": not a block device. Should be the floppy disk device." \
		1>&2
	exit -1
fi

# Try to unmount anything that should not be mounted. Aborted runs of this
# script may have left things mounted.
(umount /mnt; umount $floppy; true)2>/dev/null >/dev/null

# Zero the entire disk, so that if I compress the raw disk image,
# unused blocks will compress well.
dd if=/dev/zero of=$floppy bs=1k count=$blocks

# Make the filesystem.
mkdosfs -n drivers -m scripts/drivers/boot.txt $floppy $blocks

# Extract the kernel from its package.
(rm -f -r /var/tmp/extract-tmp-$$;true)
mkdir /var/tmp/extract-tmp-$$
for i in $@; do
	dpkg-deb --extract $i /var/tmp/extract-tmp-$$
done

# mount the disk
mount $floppy /mnt

(cd /var/tmp/extract-tmp-$$/;tar cvlf - lib/modules|gzip -9 > /mnt/modules.tgz)

cp scripts/drivers/install.sh /mnt/install.sh
chmod 777 /mnt/install.sh
echo "drivers">/mnt/type.txt

umount /mnt

(rm -f -r /var/tmp/extract-tmp-$$ boot${blocks}.bin;true)
dd if=$floppy of=drv${blocks}.bin bs=1k count=$blocks
ls -l drv$blocks.bin
exit 0
