/*
 * dstore.c - Linux global storage for lsof
 */


/*
 * Copyright 1994 Purdue Research Foundation, West Lafayette, Indiana
 * 47907.  All rights reserved.
 *
 * Written by Victor A. Abell
 *
 * This software is not subject to any license of the American Telephone
 * and Telegraph Company or the Regents of the University of California.
 *
 * Permission is granted to anyone to use this software for any purpose on
 * any computer system, and to alter it and redistribute it freely, subject
 * to the following restrictions:
 *
 * 1. Neither the authors nor Purdue University are responsible for any
 *    consequences of the use of this software.
 *
 * 2. The origin of this software must not be misrepresented, either by
 *    explicit claim or by omission.  Credit to the authors and Purdue
 *    University must appear in documentation and sources.
 *
 * 3. Altered versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 *
 * 4. This notice may not be removed or altered.
 */

#ifndef lint
static char copyright[] =
"@(#) Copyright 1994 Purdue Research Foundation.\nAll rights reserved.\n";
static char *rcsid = "$Id: dstore.c,v 1.8 99/05/09 14:56:02 abe Exp $";
#endif


#include "lsof.h"


int Cfd;				/* current file descriptor */
struct file *Cfp;			/* current file pointer */


/*
 * Drive_Nl -- table to drive the building of Nl[] via build_Nl()
 *	       (See lsof.h and misc.c.)
 */

struct drive_Nl Drive_Nl[] = {		/* NB: COFF form used; ELF form
					 * symbols have no leading `_'.
					 * The special nlist() function
					 * in dproc.c compensates.  */

	{ "dehash",	"_dentry_hashtable"		},

#if	!defined(HASUNMINSOCK)
	{ "ipops",	"_inet_proto_ops"		},
	{ "ipops_st",	"_inet_stream_ops"		},
	{ "ipops_dg",	"_inet_dgram_ops"		},
	{ "uxops",	"_unix_proto_ops"		},
	{ "uxops_st",	"_unix_stream_ops"		},
	{ "uxops_dg",	"_unix_dgram_ops"		},
#endif	/* !defined(HASUNMINSOCK) */

	{ "lv1c",	"_level1_cache"			},
	{ "lv2c",	"_level2_cache"			},
	{ "ndops",	"_nfs_dir_inode_operations"	},
	{ "nfops",	"_nfs_file_inode_operations"	},
	{ "nlkupc",	"_nfs_lookup_cache"		},
	{ "rpfops",	"_read_pipe_fops"		},
	{ "rwpfops",	"_rdwr_pipe_fops"		},

#if	defined(HASHASHPID)
	{ "task",	"_pidhash"			},
#else	/* !defined(HASHASHPID) */
	{ "task",	"_task"				},
#endif	/* defined(HASHASHPID) */

	{ "wpfops",	"_write_pipe_fops"		},
	{ "",		""				},
	{ NULL,		NULL				}
};

int HasNFS = 0;				/* 1 == there is an NFS file system */
int Kd = -1;				/* /dev/kmem file descriptor */

#if	defined(HASFSTRUCT)
/*
 * Pff_tab[] - table for printing file flags
 */

struct pff_tab Pff_tab[] = {
	{ (long)(O_RDONLY + 1),	FF_READ		},
	{ (long)(O_WRONLY + 1),	FF_WRITE	},
	{ (long)O_APPEND,	FF_APPEND	},
	{ (long)FASYNC,		FF_ASYNC	},
	{ (long)O_NONBLOCK,	FF_NBLOCK	},
	{ (long)O_NDELAY,	FF_NDELAY	},
	{ (long)O_NOCTTY,	FF_NOCTTY	},
	{ (long)O_SYNC,		FF_SYNC		},
	{ (long)0,		NULL 		}
};


/*
 * Pof_tab[] - table for print process open file flags
 */

struct pff_tab Pof_tab[] = {

	{ (long)1,		POF_CLOEXEC	},
	{ (long)0,		NULL		}
};
#endif	/* defined(HASFSTRUCT) */

struct task_struct *Tsp;		/* kernel task struct pointer */
