import sys
from Stack import *

def test():

    s = Stack()
    print repr(s)
    s = Stack()
    for i in range(1000):
	  s.push(i)
    while s:
	  print s.pop(),

    # which could also be done as:
    s = StackFromSequence(range(1000))
    while s:
	  print s.pop(),

    # or a little different
    s = StackFromSequence(range(1000))
    print s.as_tuple()
    print s.as_list()
    print

    # pop many
    print 'Pop 3 entries at once:',s.pop_many(3)

    # push many
    print 'Push many.'
    s.push_many(range(100))
    assert s.pop_many(100) == tuple(range(100-1,-1,-1))

    assert len(s) > 0
    s.resize()

    s.clear()
    assert len(s) == 0

    # push many + exceptions
    class C:
	def __getitem__(self,i):
	    if i < 50:
		return i + 1
	    else:
		raise IndexError
	def __len__(self):
	    return 100
    l = C()

    try:
	s.push_many(l)
    except IndexError:
	pass
    else:
	raise AssertionError,'push_many() does not handle errors correctly'

    assert len(s) == 0

    del s

    # Implementation deleaked up to this line.

    print
    print 'Works.'

if '-c' in sys.argv:
    while 1:
	test()
else:
    test()


