/* -*- mode: C++; tab-width: 4 -*- */
/* ================================================================================== */
/* Copyright (c) 1998-1999 3Com Corporation or its subsidiaries. All rights reserved. */
/* ================================================================================== */

#include "EmulatorCommon.h"
#include "fltk_main.h"

#include "Platform.h"			// gPseudoTickcount
#include "EmRPC.h"				// SignalWaiters

#include <FL/Fl.H>
#include <FL/Fl_Window.H>

#include "fltk_MainWindow.h"
#include "Miscellaneous.h"		// CommonStartup, CommonShutdown
#include "PreferenceMgr.h"
#include "Startup.h"			// Startup::

#ifdef __QNXNTO__
#include <sys/neutrino.h>
#endif


// -----------------------------------------------------------------------------
// execute the given FN within the context of the UI thread. This function
// (fltkExecuteUI) will be called from a non-UI thread. Currently there is
// only support for ONE pending function

static void (*sUIFunc)(void);
static omni_mutex sUIFuncMutex;
static omni_thread* sMainThread;

void fltkExecuteUI (void (*fn) (void))
{
	sUIFuncMutex.lock();
	sUIFunc = fn;
	sUIFuncMutex.unlock();
}

bool currentlyUIThread()
{
	return omni_thread::self() == sMainThread;
}

int main(int argc, char** argv)
{
	// hold onto the main thread
	sMainThread = omni_thread::self();

#ifdef __QNXNTO__
	// speed NTO up so the timing will be about right (for an x86 anyway)
	struct _clockperiod cpnew;
	struct _clockperiod old;

	cpnew.nsec = 5000000;
	cpnew.fract = 0;
	ClockPeriod(CLOCK_REALTIME, &cpnew, &old, 0);
//	printf ("%d %d %d\n", old.nsec, old.fract);
#endif

	EmulatorPreferences prefs;
	prefs.Load ();

	::CommonStartup ();

	Bool result = Startup::DetermineStartupActions (argc, argv);

	if (result)
	{
		MainWindow* mainWin = new MainWindow;

		Fl::visual (FL_DOUBLE|FL_RGB);
		mainWin->show (argc, argv);

		while ( Fl::wait() )
		{
			// !!! Still need to idle every once and a while
			// when there's no document open in order to
			// handle RPC requests.

			gPseudoTickcount++;
			sUIFuncMutex.lock();
			if (sUIFunc != NULL)
			{
				sUIFunc();
				sUIFunc = NULL;
			}
			sUIFuncMutex.unlock();
		}
	}

	RPC::SignalWaiters (hostSignalQuit);

	::CommonShutdown ();

	prefs.Save ();

	return 0;
}
