/* -*- mode: C++; tab-width: 4 -*- */
/* ================================================================================== */
/* Copyright (c) 1998-1999 3Com Corporation or its subsidiaries. All rights reserved. */
/* ================================================================================== */

#ifndef _EMULATOR_COMMON_H_
#define _EMULATOR_COMMON_H_

// Common header file included by all Palm OS Emulator for UNIX files.

// Configuration

#include "Switches.h"


// Palm headers

#include "Palm.h"


// UAE headers

#include "UAE.h"


// Std C/C++ Library stuff

// Don't pull these in here.  These would be brought in for *every*
// file, which is too expensive.  We can do this on other platforms,
// as EmulatorCommon.h is the basis for the precompiled header files,
// which load in quickly even with lots of extra stuff in them.

//#include <assert.h>
//#include <ctype.h>				// isalpha, tolower
//#include <stdarg.h>
//#include <stddef.h>
//#include <stdio.h>
//#include <stdlib.h>
//#include <string.h>

//#include <sys/types.h>
//#include <sys/socket.h>
//#include <sys/ioctl.h>
//#include <netinet/in.h>
//#include <netinet/tcp.h>
//#include <netdb.h>

//#include <algorithm>			// find, sort
//#include <deque>				// deque
//#include <list>					// list
//#include <string>				// list
//#include <utility>				// pair
//#include <vector>
//#include <map>

#include <netinet/in.h>			// ntohl


using namespace std;


// Define a boolean type that is most efficient on each platform.
// Yes, they appear to be different...

typedef int		Bool;


// A *very* handy macro.  Let's put this in a central place.

#define countof(a)	(sizeof(a) / sizeof (a[0]))

#define UNUSED_PARAM(x) ((void) x);

#define down fl_down	// "down" defined both in WindowNew.h and Fl/Enumerations.h

#endif	/* _EMULATOR_COMMON_H_ */




