/* -*- mode: C++; tab-width: 4 -*- */
/* ================================================================================== */
/* Copyright (c) 1998-1999 3Com Corporation or its subsidiaries. All rights reserved. */
/* ================================================================================== */

#ifndef SYSTEMPACKET_H_
#define SYSTEMPACKET_H_

#include "ErrorHandling.h"		// ErrCode

class SLP;

class SystemPacket
{
	public:
		static ErrCode			SendState			(SLP&);
		static ErrCode			ReadMem 			(SLP&);
		static ErrCode			WriteMem			(SLP&);
		static ErrCode			SendRoutineName 	(SLP&);
		static ErrCode			ReadRegs			(SLP&);
		static ErrCode			WriteRegs			(SLP&);
		static ErrCode			Continue			(SLP&);
		static ErrCode			RPC 				(SLP&);
		static ErrCode			RPC2 				(SLP&);
		static ErrCode			GetBreakpoints		(SLP&);
		static ErrCode			SetBreakpoints		(SLP&);
		static ErrCode			ToggleBreak 		(SLP&);
		static ErrCode			GetTrapBreaks		(SLP&);
		static ErrCode			SetTrapBreaks		(SLP&);
		static ErrCode			Find				(SLP&);
		static ErrCode			GetTrapConditions	(SLP&);
		static ErrCode			SetTrapConditions	(SLP&);

		static ErrCode			SendMessage			(SLP&, const char*);

	private:
		static ErrCode			SendResponse		(SLP&, Byte code);
		static ErrCode			SendPacket			(SLP&, const void* body, long bodySize);

		static void 			GetRegs 			(M68KRegsType&);
		static void 			SetRegs 			(const M68KRegsType&);
};

#endif	// SYSTEMPACKET_H_
