/* -*- mode: C++; tab-width: 4 -*- */
/* ================================================================================== */
/* Copyright (c) 1998-1999 3Com Corporation or its subsidiaries. All rights reserved. */
/* ================================================================================== */

#ifndef _PROFILING_H_
#define _PROFILING_H_


// wait states vary with hardware

#define PILOT		1
#define	PALM_PILOT	2
#define PALM_III	3
#define PALM_V		5		// also PALM_IIIx
#define PALM_VII	7
#define PALM_VII_EZ	8
#define	AUSTIN		9


#define PALM_HARDWARE_TYPE PALM_III



#if PALM_HARDWARE_TYPE == PILOT

#define WAITSTATES_ROM			2
#define WAITSTATES_SRAM			4	
#define WAITSTATES_DRAM			4	
#define WAITSTATES_REGISTERS	0
#define WAITSTATES_SED1375		4
#define WAITSTATES_PLD			0	// !!! What's this value?
#define WAITSTATES_DUMMYBANK	99	// hopefully won't be used!


#elif PALM_HARDWARE_TYPE == PALM_PILOT

#define WAITSTATES_ROM			2
#define WAITSTATES_SRAM			4	
#define WAITSTATES_DRAM			4	
#define WAITSTATES_REGISTERS	0
#define WAITSTATES_SED1375		4
#define WAITSTATES_PLD			0	// !!! What's this value?
#define WAITSTATES_DUMMYBANK	99	// hopefully won't be used!


#elif PALM_HARDWARE_TYPE == PALM_III

#define WAITSTATES_ROM			2
#define WAITSTATES_SRAM			4	// according to Wayne Harrington
#define WAITSTATES_DRAM			4	// according to Wayne Harrington
#define WAITSTATES_REGISTERS	0
#define WAITSTATES_SED1375		4
#define WAITSTATES_PLD			0	// !!! What's this value?
#define WAITSTATES_DUMMYBANK	99	// hopefully won't be used!

#elif PALM_HARDWARE_TYPE == PALM_V

#define WAITSTATES_ROM			1
#define WAITSTATES_SRAM			1	
#define WAITSTATES_DRAM			1	
#define WAITSTATES_REGISTERS	0
#define WAITSTATES_SED1375		4
#define WAITSTATES_PLD			0	// !!! What's this value?
#define WAITSTATES_DUMMYBANK	99	// hopefully won't be used!


#elif PALM_HARDWARE_TYPE == PALM_VII

#define WAITSTATES_ROM			1
#define WAITSTATES_SRAM			2	// not sure about this yet	
#define WAITSTATES_DRAM			2	// not sure about this yet
#define WAITSTATES_REGISTERS	0
#define WAITSTATES_SED1375		4
#define WAITSTATES_PLD			0	// !!! What's this value?
#define WAITSTATES_DUMMYBANK	99	// hopefully won't be used!

#elif PALM_HARDWARE_TYPE == AUSTIN

#define WAITSTATES_ROM			1
#define WAITSTATES_SRAM			1	
#define WAITSTATES_DRAM			1	
#define WAITSTATES_REGISTERS	0
#define WAITSTATES_SED1375		4
#define WAITSTATES_PLD			0	// !!! What's this value?
#define WAITSTATES_DUMMYBANK	99	// hopefully won't be used!

#elif PALM_HARDWARE_TYPE == PALM_VII_EZ

#define WAITSTATES_ROM			1
#define WAITSTATES_SRAM			1	
#define WAITSTATES_DRAM			1	
#define WAITSTATES_REGISTERS	0
#define WAITSTATES_SED1375		4
#define WAITSTATES_PLD			0	// !!! What's this value?
#define WAITSTATES_DUMMYBANK	99	// hopefully won't be used!

#endif	// PALM_HARDWARE_TYPE




// Standard macros for incrementing our counters

#define CYCLE_GETLONG(waitstates)						\
	if (!(gProfilingEnabled && gProfilingCounted)) ;	\
	else ProfileIncrementRead (2, waitstates)

#define CYCLE_GETWORD(waitstates)						\
	if (!(gProfilingEnabled && gProfilingCounted)) ;	\
	else ProfileIncrementRead (1, waitstates)

#define CYCLE_GETBYTE(waitstates)						\
	if (!(gProfilingEnabled && gProfilingCounted)) ;	\
	else ProfileIncrementRead (1, waitstates)


#define CYCLE_PUTLONG(waitstates)						\
	if (!(gProfilingEnabled && gProfilingCounted)) ;	\
	else ProfileIncrementWrite (2, waitstates)

#define CYCLE_PUTWORD(waitstates)						\
	if (!(gProfilingEnabled && gProfilingCounted)) ;	\
	else ProfileIncrementWrite (1, waitstates)

#define CYCLE_PUTBYTE(waitstates)						\
	if (!(gProfilingEnabled && gProfilingCounted)) ;	\
	else ProfileIncrementWrite (1, waitstates)



// 16MHz, more or less
#define kCyclesPerSecond 16580608
#define kCyclesPerMilliSecond 16580





	// Declare these before including UAE.h, as UAE.h refers
	// to them (well, gProfilingEnabled at least).

#ifdef __cplusplus
extern "C" {
#endif

// Public (HostControl) functions
extern void ProfileInit(int maxCalls, int maxDepth);
extern void ProfileStart();
extern void ProfileStop();

// note, ProfileDump destructively modifies the profile data,
// you must call ProfileCleanup after dumping, do not attempt
// to gather more profiling data.
extern void ProfileDump(const char* dumpFileName);

extern void ProfilePrint(const char* textFileName);
extern void ProfileCleanup();

extern void ProfileDetailFn(uaecptr addr, int logInstructions);


// Private (Emulator Only) stuff

	// Indicates that the profiling system has been initialized
	// by calling ProfileInit.  Set back to false after ProfileCleanup.
	// If true, adds calls to ProfileIncrementClock throught the 68K
	// emuilator.  Also controls calls to ProfileFnEnter, ProfileFnExit,
	// ProfileInterruptEnter and ProfileInterruptExit, (but that seems
	// redundant with gProfilingOn).  Finally, enables cycle counting for
	// memory accesses (but only if gProfilingCounted is also true).
extern int gProfilingEnabled;

	// Set to false in ProfileInit and ProfileStop, set to true in ProfileStart.
	// If false, ProfileFnEnter, ProfileFnExit, ProfileInterruptEnter and
	// ProfileInterruptExit merely return.
extern int gProfilingOn;

	// Set to false in ProfileInit, set to true at the start of the loop in
	// Emulator::Execute and false at the end of the loop.
	// It controls whether or not memory access cycles are counted.  It
	// is always checked in conjunction with gProfilingEnabled; both have
	// to be true in order for memory access cycles to be counted.
extern int gProfilingCounted;


	// Set to false in ProfileInit, set to true by HostControl to enable
	// detailed profiling of a given address range (typically one function)
extern int gProfilingDetailed;

#ifdef __cplusplus

class StDisableAllProfiling
{
	public:
		StDisableAllProfiling () :
		  fOld (gProfilingEnabled)
		{
		  gProfilingEnabled = false;
		}

		~StDisableAllProfiling ()
		{
			gProfilingEnabled = fOld;
		}

	private:
		int	fOld;
};

class StDisableFunctionTracking
{
	public:
		StDisableFunctionTracking () :
		  fOld (gProfilingOn)
		{
		  gProfilingOn = false;
		}

		~StDisableFunctionTracking ()
		{
			gProfilingOn = fOld;
		}

	private:
		int	fOld;
};

class StDisableMemoryCycleCounting
{
	public:
		StDisableMemoryCycleCounting () :
		  fOld (gProfilingCounted)
		{
		  gProfilingCounted = false;
		}

		~StDisableMemoryCycleCounting ()
		{
			gProfilingCounted = fOld;
		}

	private:
		int	fOld;
};

#endif

#if defined(__MWERKS__)
	#include <Math64.h>
#endif

#if defined(_MSC_VER)
	typedef __int64 SInt64;
	typedef unsigned __int64 UInt64;
#endif

#if defined(__GNUC__)
	#ifdef __QNXNTO__
		#include <inttypes.h>
		typedef uint64_t  UInt64;
		typedef int64_t   SInt64;
	#else
		#include <sys/types.h>
		typedef int64_t SInt64;
		#if defined(__svr4__)
			typedef uint64_t UInt64;
		#else
			typedef u_int64_t UInt64;
		#endif
	#endif
#endif

#if defined(_MSC_VER) || defined(__GNUC__)
#define S64Max() 9223372036854775807
#define S64Min() (-S64Max() - 1)
#define S64Add(x, y) ((x) + (y))
#define S64Subtract(x, y) ((x) - (y))
#define S64Negate(x) (-(x))
#define S64Absolute(x) absll((x))
#define S64Multiply(x, y) ((x) * (y))
#define S64Div(x, y) ((x) / (y))
#define S64Mod(x, y) ((x) % (y))
#define S64Set(x) ((SInt64) (x))
#define S64SetU(x) ((SInt64) (x))
#define S32Set(x) ((SInt32) (x))
#define S64Compare(x, y) ((int)((x) - (y)))
#define S64And(x, y) ((Boolean)((x) && (y)))
#define S64Or(x, y) ((Boolean)((x) || (y)))
#define S64Eor(x, y) ((Boolean)((x) ^ (y)))
#define S64Not(x) ((Boolean)(!(x)))
#define S64BitwiseAnd(x, y) ((x) & (y))
#define S64BitwiseOr(x, y) ((x) | (y))
#define S64BitwiseEor(x, y) (((x) & (~(y))) | ((~(x)) & (y)))
#define S64BitwiseNot(x) (~(x))
#define S64ShiftRight(x, y) ((x) >> (y))
#define S64ShiftLeft(x, y) ((x) << (y))
#define SInt64ToLongDouble(x) ((long double)(x))
#define LongDoubleToSInt64(x) ((SInt64)(x))
#endif

#define DEFAULT_RESULTS_FILENAME	"Profile Results.mwp"
#define DEFAULT_RESULTS_TEXT_FILENAME	"Profile Results.txt"

#define HAS_PROFILING_DEBUG		0	// turn on code to help debug profiler


//  normally passed in to ProfileInit, but here for CEmulatorApp.cpp
#define MAXFNCALLS		0x10000
#define MAXUNIQUEFNS	2500
#define MAXDEPTH		200



	// Total running clock cycles.  Includes opcode execution
	// time and memory fetch time.
extern SInt64 gClockCycles;

	// Portion of gClockCycles spent reading memory.
extern SInt64 gReadCycles;

	// Portion of gClockCycles spent writing memory.
extern SInt64 gWriteCycles;


static __inline__ void ProfileIncrementClock(unsigned long by)
{
	gClockCycles = S64Add(gClockCycles, S64SetU(by));
}

static __inline__ void ProfileIncrementRead(int reads, int waitstates)
{
	gClockCycles = S64Add(gClockCycles, S64Set(reads * (4+waitstates)));
	gReadCycles = S64Add(gReadCycles, S64Set(reads));
}

static __inline__ void ProfileIncrementWrite(int writes, int waitstates)
{
	gClockCycles = S64Add(gClockCycles, S64Set(writes * (4+waitstates)));
	gWriteCycles = S64Add(gWriteCycles, S64Set(writes));
}


extern void ProfileFnEnter(uaecptr destAddress, uaecptr returnAddress);
extern void ProfileFnExit(uaecptr returnAddress, uaecptr oldAddress);

extern void ProfileInterruptEnter(uae_s32 iException, uaecptr returnAddress);
extern void ProfileInterruptExit(uaecptr returnAddress);

extern void ProfileInstructionEnter(uaecptr instructionAddress);
extern void ProfileInstructionExit(uaecptr instructionAddress);

// debugging stuff

extern long gReadMismatch;
extern long gWriteMismatch;

extern void ProfileTest();


#ifdef __cplusplus
}
#endif


#endif /* _PROFILING_H_ */
  
  
