/*******************************************************************
 * 							 Pilot Software
 *
 *	Copyright (c) 1994-1998, Palm Computing Inc., All Rights Reserved
 *
 *-------------------------------------------------------------------
 * FileName:
 *		BuildRules.h
 *
 * Description:
 *		Build Rules for Pilot. This file is necessary for
 *  the CodeWarrior environment since it doesn't permit #defines
 *  in the "Makefile" (project settings).
 *    
 *    This file is included from within Common.h
 *
 * History:
 *		12/13/94	RM		Created by Ron Marianetti  
 *		05/19/97	SL		Cleaned up CMD_LINE_BUILD and __PALMOS_TRAPS__ 
 *							for other build environments
 *		04/07/98	art	Added INTERNATIONAL_MGR build setting.
 *		12/29/98	kwk	Added error for unknown language.
 *		01/29/99	kwk	Removed LANGUAGE_WORKPAD, added LANGUAGE_DUTCH,
 *							added VENDOR values, and modified resource folder
 *							prefix calculation. Also turned on INTERNATIONAL_MGR
 *							by default.
 *
 *******************************************************************/

#ifndef 	__BUILDRULES_H__
#define	__BUILDRULES_H__

/************************************************************
 * Compilation Control Options
 *************************************************************/

// The makefile should set the define EMULATION_LEVEL to one of the following
//  constants:
#define	EMULATION_NONE			0		// native environment
#define	EMULATION_WINDOWS		1		// emulate on Windows
#define	EMULATION_DOS			2		// emulate on DOS
#define	EMULATION_MAC		   3		// emulate on Macintosh
#define	EMULATION_UNIX		   4		// emulate on Unix


// If emulation is not EMULATION_NONE, the following define controls
// whether we are talking to a touchdown device over the serial port,
// or if we are emulating a memory card in local RAM.
//
// The makefile should set the define MEMORY_TYPE to one of the following
//  constants
#define	MEMORY_LOCAL			0		// Emulate using local memory card image
#define	MEMORY_REMOTE			1		// Pass calls through serial port to the device


// The makefile should set the define ENVIRONMENT to one of the following:
#define	ENVIRONMENT_CW			0		// CodeWarrior compiler/linker (IDE or MPW)
#define	ENVIRONMENT_MPW		1		// Apple's MPW compiler/linker


// The makefile should set the define PLATFORM_TYPE to one of the following
//  constants:
#define	PLATFORM_VIEWER		0		// PalmPilot Viewer
#define	PLATFORM_SERVER		1		// Server code


// The makefile should set the define ERROR_CHECK_LEVEL to one of the 
//  following constants:
#define	ERROR_CHECK_NONE		0		// compile no error checking code
#define	ERROR_CHECK_PARTIAL	1		// display for fatal errors only
#define	ERROR_CHECK_FULL		2		// display fatal or non-fatal errors


// The makefile should set the define CPU_TYPE to one of the 
//  following constants:
#define	CPU_68K					0		// Motorola 68K type
#define	CPU_x86					1		// Intel x86 type


// The makefile should set the define HW_TARGET to one of the 
// following constants:
#define	HW_TARGET_NONE			0		// Emulating
#define	HW_TARGET_302			1		// Motorola 302 ADS board
#define	HW_TARGET_328EMU		2		// Motorola 328 Emulator ADS board
#define	HW_TARGET_328			3		// Motorola 328 ADS board
#define	HW_TARGET_TD1			4		// Pilot hardware
#define  HW_TARGET_EZ			6		// EZ hardware (68EZ328 Processor-based)

// The makefile should set the define MODEL to one of the
// following constants. This equate is currently only use by
//  special purpose applications like Setup that need to install different
//  files for each type of product. Normally, model dependent behavior
//  should be run-time based off of Features using FtrGet(). 
#define	MODEL_GENERIC			0		// Not one of the specific models that follow
#define	MODEL_ELEVEN			1		// Eleven (Palm Seven)
#define	MODEL_SUMO				2		// EZ product 



// The makefile should set the define OEM_PRODUCT to one of the
// following constants:
#define	OEM_PRODUCT_NONE		0		// Not an OEM product build (i.e. Palm Computing build)
#define	OEM_PRODUCT_THUMPER	1		// Qualcomm Thumper
#define	OEM_PRODUCT_SPT1740	2		// Symbol SPT-1740


// The makefile should set the define MEMORY_FORCE_LOCK to one of the
// following.
#define	MEMORY_FORCE_LOCK_OFF	0	// Don't force all handles to be locked
#define	MEMORY_FORCE_LOCK_ON		1	// Force all handles to be locked before usage


// The makefile should set the define DEBUG_LEVEL to one of the
// following. THIS DEFINE IS ONLY USED BY A COUPLE MODULES SO WE
//  DON'T GIVE IT A DEFAULT VALUE BELOW...
// ANY MODULE THAT USES THIS DEFINE SHOULD VERIFY THAT IT IS DEFINED!!
#define	DEBUG_LEVEL_NONE			1	// None: Does not auto-launch Console or Debugger
#define	DEBUG_LEVEL_PARTIAL		2	// Partial: Auto-Launches Console but skips debugger
#define	DEBUG_LEVEL_FULL			3	// Full: Waits in debugger on reset


// The makefile should set the define PILOT_SERIAL_MGR to one of the following:
// PILOT_SERIAL_MGR is used to allow component of the OS and libraries to decide
// whether to use the old serial library API's or the new SerHWMgr.
#define	PILOT_SERIAL_MGR_OLD				0
#define	PILOT_SERIAL_MGR_NEW				1

// The makefile should set the define CONSOLE_SERIAL_LIB to one of
// the following.  THIS DEFINE IS ONLY USED BY A COUPLE MODULES SO WE
//  DON'T GIVE IT A DEFAULT VALUE BELOW...
// ANY MODULE THAT USES THIS DEFINE SHOULD VERIFY THAT IT IS DEFINED!!
#define	CONSOLE_SERIAL_LIB_68328	1	// SerialMgr68328 used by Console app
#define	CONSOLE_SERIAL_LIB_68681	2	// SerialMgr68681 used by Console app
#define	CONSOLE_SERIAL_LIB_16C650	3	// New SerialMgr only - specifies Console App to use 650 card for serial.
#define	CONSOLE_SERIAL_LIB_68328EZ	4	// New SerialMgr only - specifies Console App to use 650 card for serial.


// The makefile should set the define COUNTRY to one of the 
// following constants:
#define	COUNTRY_UNITED_STATES	0
#define	COUNTRY_FRANCE				1
#define	COUNTRY_GERMANY			2
#define	COUNTRY_ITALY				3
#define	COUNTRY_SPAIN				4
#define	COUNTRY_NETHERLANDS		5
#define	COUNTRY_JAPAN				6


// The makefile should set the define LANGUAGE to one of the 
// following constants:
#define	LANGUAGE_ENGLISH			0
#define	LANGUAGE_FRENCH			1
#define	LANGUAGE_GERMAN			2
#define	LANGUAGE_ITALIAN			3
#define	LANGUAGE_SPANISH			4
// #define	LANGUAGE_WORKPAD		5 (Obsolete)
#define	LANGUAGE_JAPANESE			6
#define	LANGUAGE_DUTCH				7


// The makefile should set the define VENDOR to one of the
// following constants:
#define	VENDOR_3COM					0
#define	VENDOR_IBM					1
#define	VENDOR_SYMBOL				2
#define	VENDOR_QUALCOMM			3
#define	VENDOR_HANDSPRING			4
#define	VENDOR_FRANKLIN			5

// The makefile should set the define USER_MODE to one of the 
// following constants:
#define	USER_MODE_NORMAL			0	// normal operation
#define	USER_MODE_DEMO				1	// demo mode - Graffiti and pop-up keyboard disabled


// The makefile should set the define INTERNAL_COMMANDS to one of the 
// following constants:
#define	INTERNAL_COMMANDS_EXCLUDE		0
#define	INTERNAL_COMMANDS_INCLUDE		1	// Include internal shell commands

// The makefile should set the define MEMORY_VERSION to one of the 
// following constants:
#define	MEMORY_VERSION_1					1
#define	MEMORY_VERSION_2					2	// >64K chunks

// The makefile should set the define GRAPHICS_VERSION to one of the 
// following constants:
#define	GRAPHICS_VERSION_1				1
#define	GRAPHICS_VERSION_2				2	// color

// The makefile should set the define INCLUDE_DES to one of the 
// following constants:
#define	INCLUDE_DES_OFF					0
#define	INCLUDE_DES_ON						1	// include it

// The makefile should set the define TEXT_SERVICES to one of the 
// following constants:
#define	TEXT_SERVICES_OFF					0
#define	TEXT_SERVICES_ON					1	// include it

// The makefile should set the define INTERNATIONAL_MGR to one of the 
// following constants:
#define	INTERNATIONAL_MGR_OFF			0
#define	INTERNATIONAL_MGR_ON				1	// include it

// Used by Net Library to link in the CML encoder
#define	CML_ENCODER_OFF					0
#define	CML_ENCODER_ON						1



/************************************************************
 * Include the following when running under the CodeWarrior
 *  IDE so that default build options can be overriden. The default
 *  version of this file is in the Incs: directory. If an app wishes
 *  to override the default options, it should create a copy of this
 *  include file in its own local directory. This include file
 *  is never used when building from MPW since MPW can specify compiler
 *  defines from the command line.
 *
 * Other environments can override all of these settings by simply
 *  pre-defining CMD_LINE_BUILD and any other desired settings.
 *************************************************************/

#ifndef CMD_LINE_BUILD				// typically pre-defined only from MPW

	#if !defined(__MWERKS__) && !defined(__PALMOS_TRAPS__) && !defined(_MSC_VER)

		// assume other environments generally build only PalmOS executables
		#define __PALMOS_TRAPS__ 	1

	#endif
	

	#if	__PALMOS_TRAPS__			// defined by CodeWarrior IDE or above

		// Settings to build a PalmOS executable
		#define EMULATION_LEVEL		EMULATION_NONE		// building Pilot executable
		#define USE_TRAPS				1						// use Pilot traps
		
	#endif


	// Include default definitions - either from Incs: directory or from
	// local project directory (if present, to override system defaults).
	// <chg 4-27-98 RM> Microsoft's Visual C compiler does include paths wrong -
	//  it starts the search from *this* header instead of from the C file. We
	//  we don't want it to find the "AppBuildRules.h" that's located in the
	//  Viewer:Incs: directory so we force Windows apps to use a different name for it.
	#ifdef _MSC_VER
		#include "AppBuildRulesMSC.h"
	#else
		#include "AppBuildRules.h"
	#endif
	#include <SysBuildRules.h>
#endif



/************************************************************
 * Settings that can be overriden in the makefile (for MPW)
 *	OR (for CodeWarrior) in "AppBuildRules.h".  If there is no
 * local copy of "AppBuildRules.h" within the project directory,
 * the one in the Incs directory will be used instead.
 *************************************************************/ 
#ifndef	EMULATION_LEVEL
	#define	EMULATION_LEVEL		EMULATION_MAC
#endif

#if EMULATION_LEVEL == EMULATION_NONE
	#define	MEMORY_TYPE				MEMORY_LOCAL
#endif

#ifndef MEMORY_TYPE
	#define	MEMORY_TYPE 			MEMORY_LOCAL
#endif

#ifndef ENVIRONMENT
	#define	ENVIRONMENT				ENVIRONMENT_CW
#endif

#ifndef	PLATFORM_TYPE
	#define	PLATFORM_TYPE			PLATFORM_VIEWER
#endif

#ifndef	ERROR_CHECK_LEVEL
	#define	ERROR_CHECK_LEVEL		ERROR_CHECK_FULL
#endif

#ifndef CPU_TYPE
	#define	CPU_TYPE					CPU_68K
#endif

#ifndef HW_TARGET
	#define	HW_TARGET				HW_TARGET_NONE
#endif

#ifndef PILOT_SERIAL_MGR
	#define PILOT_SERIAL_MGR		PILOT_SERIAL_MGR_OLD
#endif

#ifndef	MEMORY_FORCE_LOCK
	#define	MEMORY_FORCE_LOCK		MEMORY_FORCE_LOCK_ON
#endif

#ifndef VENDOR
	#define	VENDOR					VENDOR_3COM
#endif

#ifndef	LANGUAGE
	#define	LANGUAGE					LANGUAGE_ENGLISH
#endif

#ifndef	COUNTRY
	#define	COUNTRY					COUNTRY_UNITED_STATES
#endif

#ifndef	USER_MODE
	#define	USER_MODE				USER_MODE_NORMAL
#endif

#ifndef	INTERNAL_COMMANDS
	#define	INTERNAL_COMMANDS		INTERNAL_COMMANDS_EXCLUDE
#endif

#ifndef	MEMORY_VERSION
	#define	MEMORY_VERSION			MEMORY_VERSION_2
#endif

#ifndef	GRAPHICS_VERSION
	#define	GRAPHICS_VERSION		GRAPHICS_VERSION_2
#endif

#ifndef	INCLUDE_DES
	#define	INCLUDE_DES				INCLUDE_DES_OFF
#endif

#ifndef	TEXT_SERVICES
	#define	TEXT_SERVICES			TEXT_SERVICES_OFF
#endif

#ifndef	CML_ENCODER
	#define CML_ENCODER				CML_ENCODER_OFF
#endif

#ifndef	INTERNATIONAL_MGR
	#define	INTERNATIONAL_MGR		INTERNATIONAL_MGR_ON
#endif

// kwk - This needs to be deleted, but we can't until all of the apps,
// panels, etc. have been fixed up to use the new TextMgr routines.

#define	NON_INTERNATIONAL

/**********************************************************************
 * By putting these here (once), we don't need them in each :Src:Rsc.c
 **********************************************************************/ 
#if		VENDOR == VENDOR_3COM
	#if 		LANGUAGE == LANGUAGE_ENGLISH
		#define RESOURCE_FILE_PREFIX ""
	#elif 	LANGUAGE == LANGUAGE_FRENCH
		#define RESOURCE_FILE_PREFIX "{3CfrFR}:"
	#elif 	LANGUAGE == LANGUAGE_GERMAN
		#define RESOURCE_FILE_PREFIX "{3CdeDE}::"
	#elif 	LANGUAGE == LANGUAGE_ITALIAN
		#define RESOURCE_FILE_PREFIX "{3CitIT}:"
	#elif 	LANGUAGE == LANGUAGE_SPANISH
		#define RESOURCE_FILE_PREFIX "{3CesES}:"
	#elif		LANGUAGE == LANGUAGE_DUTCH
		#define RESOURCE_FILE_PREFIX "{3CnlNL}:"
	#elif 	LANGUAGE == LANGUAGE_JAPANESE
		#define RESOURCE_FILE_PREFIX "{3CjpJP}:"
	#else
		#error "Unknown LANGUAGE specified for BuildRules.h"
	#endif
#elif		VENDOR == VENDOR_IBM
	#if 		LANGUAGE == LANGUAGE_ENGLISH
		#define RESOURCE_FILE_PREFIX "{WPenUS}"
	#elif 	LANGUAGE == LANGUAGE_FRENCH
		#define RESOURCE_FILE_PREFIX "{WPfrFR}:"
	#elif 	LANGUAGE == LANGUAGE_GERMAN
		#define RESOURCE_FILE_PREFIX "{WPdeDE}::"
	#elif 	LANGUAGE == LANGUAGE_ITALIAN
		#define RESOURCE_FILE_PREFIX "{WPitIT}:"
	#elif 	LANGUAGE == LANGUAGE_SPANISH
		#define RESOURCE_FILE_PREFIX "{WPesES}:"
	#elif		LANGUAGE == LANGUAGE_DUTCH
		#define RESOURCE_FILE_PREFIX "{WPnlNL}:"
	#elif 	LANGUAGE == LANGUAGE_JAPANESE
		#define RESOURCE_FILE_PREFIX "{WPjpJP}:"
	#else
		#error "Unknown LANGUAGE specified for BuildRules.h"
	#endif
#else
	#error "Unknown VENDOR specified for BuildRules.h"
#endif

#endif // __BUILDRULES_H__
