/* -*- mode: C++; tab-width: 4 -*- */
/* ================================================================================== */
/* Copyright (c) 1998-1999 3Com Corporation or its subsidiaries. All rights reserved. */
/* ================================================================================== */

#ifndef __CPU_MT_H__
#define __CPU_MT_H__

#include "ErrorHandling.h"		// ErrCode
#include "omnithread.h" 		// omni_thread
#include "Platform_Files.h" 	// FileReference
#include "Skins.h"				// SkinElement

enum { kStopManually = 1, kStopOnADime, kStopOnATrap };
enum { kStateStopped, kStateWaitingToStart, kStateRunning, kStateStopRequested };

class CPU : public omni_thread
{
	public:
  
	// -----------------------------------------------------------------------------
	// constructor / destructor
	// -----------------------------------------------------------------------------

								CPU 			(void);
		virtual 				~CPU			(void);

	// -----------------------------------------------------------------------------
	// public methods
	// -----------------------------------------------------------------------------

		void					CreateThread	(void);
		void					DestroyThread	(void);

		void					StartThread 	(void);
		void					StopThread		(Bool& wasStopped, Bool& isStopped, int how);

		void					Sleep			(long timeout);

	private:

		// -----------------------------------------------------------------------------
		// private methods
		// -----------------------------------------------------------------------------

		void					MSecsToSecsNSecs(long msecs, unsigned long& secs, unsigned long& nsecs);

		// -----------------------------------------------------------------------------
		// omni_thread overrides
		// -----------------------------------------------------------------------------

		virtual void*			run_undetached	(void* arg);

		// -----------------------------------------------------------------------------
		// private data members
		// -----------------------------------------------------------------------------

		omni_mutex				fRunMutex;
		omni_condition			fRunCondition;

		omni_mutex				fStopMutex;
		omni_condition			fStopCondition;

		omni_mutex				fSleepMutex;
		omni_condition			fSleepCondition;

		Bool					fRunning;		// Protected by fStopMutex.  Note that having fRunMutex
												// acquired will also protect fRunning, as that implies
												// the CPU thread is stopped.
		Bool					fStopRequest;	// Protected by fRunMutex (except for end of CPU::Stop).
		Bool					fQuitRequest;	// Protected by fRunMutex.
};


// -----------------------------------------------------------------------------
// Stack object which is used to briefly stop the emulator:
// -----------------------------------------------------------------------------

class CPUStopper
{
	public:
								CPUStopper		(int how);
								~CPUStopper 	(void);

		Bool					Stop			(int how);
		void					Start			(void);

		Bool					Stopped 		(void)	{ return fNowStopped; }

		void					ShowError		(const char*);

		static Bool				fgInstantiated;

	private:
		CPU*					fCPU;
		Bool					fNowStopped;
};

#endif /* __CPU_MT_H__ */
