/* pgp4pine main.c
 *
 * See common.c for the version and license.
 * Copyright (C) 1998 by Chris Wiegand
 */

#include "defines.h"
#include "includes.h"
#include "structs.h"
#include "declares.h"
#include "externs.h"

/* ------------------------------------------------------------ */

int main(int argc,char **argv)
{
	char recipients[EMAIL_ADDRESS_MAX_LENGTH];
	char recipientsTmp[EMAIL_ADDRESS_MAX_LENGTH];

	int showWelcome=1;
	int i, j, pipeFiles = -1, keepTmpFile = -1;
	int outgoing=0,myClearScreen=1;

	char inFile[MAX_COMMAND_LINE_LENGTH];
	char outFile[MAX_COMMAND_LINE_LENGTH];

	char mainTmpFile[MAX_COMMAND_LINE_LENGTH];
	char realTmpFile[MAX_COMMAND_LINE_LENGTH];

	int ret = 0; /* return value */
	int signFile=0,encryptFile=0,armorFile=0,canonFile=0,detachedSig=0;
	/* set in command line... */

	secretKeyring = NULL;
	publicKeyring = NULL;

	if (argc == 1) {
		printUsage();
		exit(-1);
        }
	if (strcmp(argv[1],"--version") == 0) {
		printVersion();
		exit(-1);
	}
	if (strcmp(argv[1],"--usage") == 0 || strcmp(argv[1],"--help") == 0 || strcmp(argv[1],"-h") == 0) {
		printUsage();
		exit(-1);
	}

	// Here we initialize the recipients list
	saveDebugFile = 0;
	strcpy(recipients,""); // initialize it...
	strcpy(recipientsTmp,""); // initialize it too...
	strcpy(mainTmpFile,""); // clear this out (Dale Osowski found this one..)
	strcpy(outFile,""); // init string...

	for (i=1; i<=argc-1; i++) {
		// This stuff can be anywhere...
		if (strcmp(argv[i],"-e") == 0 || strcmp(argv[i],"--encrypt") == 0) outgoing = 1;
		if (strcmp(argv[i],"-s") == 0 || strcmp(argv[i],"--sign") == 0) outgoing = 1;
		if (strcmp(argv[i],"-d") == 0 || strcmp(argv[i],"--decrypt") == 0) outgoing = -1;
		if (strcmp(argv[i],"--debug") == 0) saveDebugFile = 1;
		if (strcmp(argv[i],"-sf+") == 0 || strcmp(argv[i],"-sf") == 0) signFile = 1;
		if (strcmp(argv[i],"-sf-") == 0) signFile = -1;
		if (strcmp(argv[i],"-ef+") == 0 || strcmp(argv[i],"-ef") == 0) encryptFile = 1;
		if (strcmp(argv[i],"-ef-") == 0) encryptFile = -1;
		if (strcmp(argv[i],"-af+") == 0 || strcmp(argv[i],"-af") == 0) armorFile = 1;
		if (strcmp(argv[i],"-af-") == 0) armorFile = -1;
		if (strcmp(argv[i],"-uf+") == 0 || strcmp(argv[i],"-uf") == 0) canonFile = 1;
		if (strcmp(argv[i],"-uf-") == 0) canonFile = -1;
		if (strcmp(argv[i],"-ds+") == 0 || strcmp(argv[i],"-ds") == 0) detachedSig = 1;
		if (strcmp(argv[i],"-ds-") == 0) detachedSig = -1;
		if (strcmp(argv[i],"--noclear") == 0) myClearScreen = -1;
		if (strcmp(argv[i],"-k") == 0 || strcmp(argv[i],"--keep") == 0) keepTmpFile = 1;
		if (strcmp(argv[i],"-f") == 0 || strcmp(argv[i],"--pipe") == 0) pipeFiles = 1;
		if (strcmp(argv[i],"-q") == 0 || strcmp(argv[i],"--quiet") == 0) showWelcome = -1;
		if (i<argc-1) {
			// stuff that reads the NEXT argv[] goes inside here...
			if (strcmp(argv[i],"-t") == 0 || strcmp(argv[i],"--tempfile") == 0) strcpy(mainTmpFile,argv[i+1]);
			if (strcmp(argv[i],"-i") == 0 || strcmp(argv[i],"--infile") == 0) strcpy(inFile,argv[i+1]);
			if (strcmp(argv[i],"-o") == 0 || strcmp(argv[i],"--outfile") == 0) strcpy(outFile,argv[i+1]);
			if (strcmp(argv[i],"-r") == 0 || strcmp(argv[i],"--recipients") == 0) {
				strcpy(recipientsTmp,""); // to make it blank...
				for (j=i+1;j<=argc-1;j++) {
					strcat(recipientsTmp,argv[j]);
					strcat(recipientsTmp," ");
				}
				strcpy(recipients,recipientsTmp);
				i=argc; // so that we end...
			}
		}
	}

	openDebugFile();
	snprintf(debugLine,DEBUG_LINE_LENGTH,"In File: %s\nOut File: %s\nTmp File: %s\n",inFile,outFile,mainTmpFile);
	documentStatus(debugLine);
	snprintf(debugLine,DEBUG_LINE_LENGTH,"main: recipients: %s\n",recipients);
	documentStatus(debugLine);
	if (myClearScreen > 0) clearScreen();

	if (showWelcome > 0) printVersion();  // we introduce ourselves...
	if (saveDebugFile) printf("DEBUG flags on\n");
	readRCFile();    // read our prefs...
	selectProfile(); // and get the profile for this session...

	// now we want to merge the profile we selected with the options from the command line...
	if (signFile != 0) myUserPrefs->autoSign = signFile;
	if (encryptFile != 0) myUserPrefs->autoEncrypt = encryptFile;
	if (armorFile != 0) myUserPrefs->asciiArmor = armorFile;
	if (canonFile != 0) myUserPrefs->universalText = canonFile;
	if (detachedSig != 0) myUserPrefs->detachedSig = detachedSig;

	snprintf(debugLine,DEBUG_LINE_LENGTH,"Preferences: s%c,e%c,a%c,c%c,d%c\n",
	  (myUserPrefs->autoSign==-1)     ?'-':(myUserPrefs->autoSign==1)     ?'+':'?',
	  (myUserPrefs->autoEncrypt==-1)  ?'-':(myUserPrefs->autoEncrypt==1)  ?'+':'?',
	  (myUserPrefs->asciiArmor==-1)   ?'-':(myUserPrefs->asciiArmor==1)   ?'+':'?',
	  (myUserPrefs->universalText==-1)?'-':(myUserPrefs->universalText==1)?'+':'?',
	  (myUserPrefs->detachedSig==-1)  ?'-':(myUserPrefs->detachedSig==1)  ?'+':'?');
	documentStatus(debugLine);

	if (strlen(inFile) < 3) {
		if (pipeFiles > 0) {
			// If we're piping, we use /tmp/pgp4pine.tmp unless
			// it's overridden in the command line.
			// If we're not piping, we set that in the command line anyways
			strcpy(inFile,"/tmp/pgp4pine.tmp");
		} else {
			// we're not piping...
			printf("You are not piping, yet no input file was found in the command line.\nUse -i (fileName) to specify one.\n");
			exit(-1);
		}
	}

	// If we don't set an outfile, we use the infile...
	if (strlen(outFile) < 3) strcpy(outFile,inFile);

	if (outgoing == 0) {
		printf("You must specify either -e to sign/encrypt or -d to verify/decrypt.\n");
		exit(-1);
	}

	if (pipeFiles > 0) pipeSTDINToFile(inFile);

	if (strlen(mainTmpFile) > 1) {
		if (access(mainTmpFile,F_OK) == 0) {
			// file exists...
			printf("Exists: %s\n",mainTmpFile);
			if (askInteger("Your temporary file already exists. Do you want me to overwrite it?",1) == 1) {
				remove(mainTmpFile);
				strcpy(realTmpFile,mainTmpFile);
			} else {
				strcpy(realTmpFile,outFile);
			}
		} else {
			strcpy(realTmpFile,mainTmpFile);
		}
	} else if (strlen(myUserPrefs->myTmpFile) > 1) {
		if (access(myUserPrefs->myTmpFile,F_OK) == 0) {
			// file exists...
			printf("Exists: %s\n",myUserPrefs->myTmpFile);
			if (askInteger("Your temporary file already exists. Do you want me to overwrite it?",1) == 1) {
				remove(myUserPrefs->myTmpFile);
				strcpy(realTmpFile,myUserPrefs->myTmpFile);
			} else {
				strcpy(realTmpFile,outFile);
			}
		} else {
			strcpy(realTmpFile,myUserPrefs->myTmpFile);
		}
	} else {
		/* Note: shouldn't ever reach here, since the default for the 
		 * prefs is ~/pgp4pine.tmp, however, just in case ...
		 */
		strcpy(realTmpFile,outFile);
	}

	if (outgoing == 1) {
		// sending the file/message...
		switch (fileSignEncryptMenu(inFile,realTmpFile,recipients))
		{
		   case -1:  /* abort message */
			ret = -1; /* set return value */			
		   	break;
		   case 0:   /* send unmodified */
		    	/* Simply label infile as TmpFile, this will either
			   make the infile be copied if in- and outfile are 
			   different, or nothing at all as desired */
		   	strcpy(realTmpFile,inFile);
			break;
		}
	} else {
		// receiving the file/message for Decryption
		fileVerifyDecryptMenu(inFile,realTmpFile);
	}

	if ((strlen(realTmpFile) > 1) && (strcmp(realTmpFile,outFile)) && (ret != -1))
	/* Not yet failed, and infile different from outfile */
	{
		char c;
		FILE *fin, *fout;
		if ((fin = fopen(realTmpFile,"r")) != NULL && (fout = fopen(outFile,"w")) != NULL) {
			while (!feof(fin)) {
				c = fgetc(fin);
				if (!feof(fin)) fputc(c,fout);
			}
			fclose(fin);
			fclose(fout);
		} else {
			/* Okay, for some reason we FAILED to copy the file, so
			 * we'll tell the user and QUIT. */
			fprintf(stderr,"I FAILED to copy from the temporary file (%s) to the outgoing file (%s). Quitting...\n\n",realTmpFile,outFile);
			ret = -1; /* FAILURE */
		}
		if (keepTmpFile < 0) remove(realTmpFile);
	}
	
	if (pipeFiles > 0) {
		char tmpAppString[MAX_COMMAND_LINE_LENGTH];
		sprintf(tmpAppString,"%s %s",prefsMyPager,outFile);
		runProcessFG(tmpAppString);
		if (keepTmpFile < 0) remove(outFile);
		if (keepTmpFile < 0 && strcmp(inFile,outFile) != 0) remove(inFile);
	}
	
	// dealloc secret and public keyrings!
	documentStatus("Deallocating SECRET Keyring: ");
	if (secretKeyring != NULL) deallocAllKeys(secretKeyring);
	secretKeyring = NULL;

	documentStatus("Deallocating PUBLIC keyring.: ");
	if (publicKeyring != NULL) deallocAllKeys(publicKeyring);
	publicKeyring = NULL;

	documentStatus("almost closed...\n");
	closeDebugFile();
	return ret;
}

