//                                                                            
// Copyright 1998 CDS Networks, Inc., Medford Oregon                          
//                                                                            
// All rights reserved.                                                       
//                                                                            
// Redistribution and use in source and binary forms, with or without         
// modification, are permitted provided that the following conditions are met:
// 1. Redistributions of source code must retain the above copyright          
//    notice, this list of conditions and the following disclaimer.           
// 2. Redistributions in binary form must reproduce the above copyright       
//    notice, this list of conditions and the following disclaimer in the     
//    documentation and/or other materials provided with the distribution.    
// 3. All advertising materials mentioning features or use of this software   
//    must display the following acknowledgement:                             
//      This product includes software developed by CDS Networks, Inc.        
// 4. The name of CDS Networks, Inc.  may not be used to endorse or promote   
//    products derived from this software without specific prior              
//    written permission.                                                     
//                                                                            
// THIS SOFTWARE IS PROVIDED BY CDS NETWORKS, INC. ``AS IS'' AND              
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE      
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
// ARE DISCLAIMED.  IN NO EVENT SHALL CDS NETWORKS, INC. BE LIABLE            
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL 
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS    
// OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)      
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT 
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY  
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF     
// SUCH DAMAGE.                                                               
//                                                                            



package com.internetcds.jdbc.tds;


public class PacketDoneInProcResult extends PacketResult
{
   public static final String cvsVersion = "$Id: PacketDoneInProcResult.java,v 1.1 1998/10/30 01:58:49 cts Exp $";


   private byte    status;
   private int     rowCount;
   private int     retStat;
   private boolean isRetStatSet;

   public PacketDoneInProcResult(
      byte   type,
      byte   _status,
      int    _rowCount)
      throws TdsConfused
   {
      super(type);
      if(type != TdsDefinitions.TDS_DONEINPROC)
      {
         // NOTE-  The packet isn't 
         throw new TdsConfused("Internal error");
      }
      status       = _status;
      rowCount     = _rowCount;
      isRetStatSet = false;
   }

   public int getRowCount()
   {
      return rowCount;
   }

   public boolean moreResults()
   {
      return (status & 0x01) != 0;
   }

   public boolean wasCanceled()
   {
      return (status & 0x20) != 0;
   }

   public boolean haveRetStat()
   {
      return isRetStatSet;
   }

   public void setRetStat(int value)
   {
      retStat = value;
      isRetStatSet = true;
   }
   
   public int getRetStat()
   {
      return retStat;
   }

   public String toString()
   {
      return ""
         + "token type- " + Integer.toHexString(getPacketType() & 0xff)
         + ", rowCount- " + getRowCount()
         + ", moreResults- " + moreResults()
         + ", wasCanceled- " + wasCanceled()
         + ", " + (haveRetStat() 
                   ? ("retstat- " + getRetStat()) 
                   : "no retstat");
   }
}

