#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <string.h>

#include "Xsqldefs.h"

static char string[2000];
/* there is no way to predict how large a string can be after vsprintf is applied.
 * For that reason I just take it so large it will almost never overflow.
 * However, there really should be a better way !*/

void SqlError(char *s,...)
{  va_list ap;
   
   va_start(ap,s);
   
   vsprintf(string,s,ap);
   fl_show_alert(string,"",msqlErrMsg,1);
}

void Message(char *s,...)
{  va_list ap;
   
   va_start(ap,s);
   
   vsprintf(string,s,ap);
   fl_show_message("",string,"");
}

void Info(FD_Xsql *fd_Xsql,char *s,...)
{  va_list ap;
   int count;
   
   va_start(ap,s);
   
   vsprintf(string,s,ap);

   fl_freeze_form(fd_Xsql->Xsql);
   fl_addto_browser(fd_Xsql->XsqlMessages,string);
   
   /* Clear toplines regularly to avoid heavy memory use */
   if(fl_get_browser_maxline(fd_Xsql->XsqlMessages) > MAXLOGINFO)
   {
      for(count=1;count< (MAXLOGINFO / 2);count++)
	fl_delete_browser_line(fd_Xsql->XsqlMessages,count);
   }
   fl_unfreeze_form(fd_Xsql->Xsql);
/*
    fprintf(stderr,"%s\n",string);
*/
}

