package biss.jde;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import sun.tools.javac.Main;

/**
 * Wrapper for calling (asynchonously) the Java bytecode compiler
 *
 * (C) 1996,97 BISS GmbH Germany, see file 'LICENSE.BISS-AWT' for details
 * @author P.C.Mehlitz
 */
public class ByteCodeCompiler
  extends Observable
  implements Runnable
{
	String ClassPath = System.getProperty( "java.class.path");
	String TargetPath;
	boolean Debug = false;
	boolean Optimize = false;
	boolean Verbose = false;
	boolean Check = false;
	String Targets[];
	String Args[];
	OutputStream Out = System.out;
	ByteArrayOutputStream LocalOut;
	boolean Result = true;
	boolean IsRunning = false;
	sun.tools.javac.Main RealCompiler;

void buildArgArray () {
	Vector list = new Vector( 10);
	Enumeration e;
	int i;

	if ( Debug )    list.addElement( "-g");
	if ( Optimize ) list.addElement( "-O");
	if ( Verbose )  list.addElement( "-verbose");
	if ( Check )    list.addElement( "-nowrite");

	if ( TargetPath != null ) {
		list.addElement( "-d");
		list.addElement( TargetPath);
	}

	if ( ClassPath != null ) {
		list.addElement( "-classpath");
		list.addElement( ClassPath);
	}

	if ( Targets != null ) {
		for ( i=0; i<Targets.length; i++ )
			list.addElement( Targets[i]);
	}

	Args = new String[list.size()];
	for ( i=0, e=list.elements(); i<Args.length; i++ )
		Args[i] = (String)e.nextElement();
}

public boolean compile () {
	run();
	return Result;
}

public OutputStream getOutput () {
	return Out;
}

public static void main ( String args[] ) {
	try {
		ByteCodeCompiler compiler = new ByteCodeCompiler();

		System.out.println( "--- start compile: " + args[0]);
		compiler.setTarget( args[0]);
		compiler.startCompile();
		System.out.println( "--- ok, it's running");

		while ( compiler.IsRunning )  // BAD practice, better use a wait() here
			Thread.sleep( 100);
	}
	catch ( Exception x ) {
		x.printStackTrace();
	}
}

public synchronized void run () {
	IsRunning = true;
	buildArgArray();

	if ( LocalOut != null )
		LocalOut.reset();

	RealCompiler = new sun.tools.javac.Main( Out, "javac");
	Result =  RealCompiler.compile( Args);

	IsRunning = false;

	setChanged();
	notifyObservers();
	clearChanged();
}

public void setOutputStream ( OutputStream s ) {
	Out = s;
}

public void setTarget ( String file ) {
	Targets = new String[1];
	Targets[0] = file;
}

public void setTargetPath ( String dir ) {
	TargetPath = dir;
}

void startCompile () {
	Thread t = new Thread( this );
	t.setPriority( Thread.MIN_PRIORITY);
	t.start();
}

public void storeOutput () {
	LocalOut = new ByteArrayOutputStream( 2000);
	Out = LocalOut;
}
}
