package biss.awt;

import biss.ObserverSocket;
import java.awt.Color;
import java.awt.Container;
import java.awt.Event;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.ImageObserver;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;

/**
 * abstract base for Compounds containing scrollable Canvas widgets
 *
 * There is an anomaly with respect to border handling. ScrollablePanes
 * don't have visible borders of their own. They just propagate their
 * border style to their ScrollableCanvas component.
 *
 * (C) 1996,97 BISS GmbH Germany, see file 'LICENSE.BISS-AWT' for details
 * @author J.H.Mehlitz
 */
abstract public class ScrollablePane
  extends Compound
  implements Observer, FocusSetInterface, DrawablePane
{
	public ScrollableCanvas BaseCv = null;
	protected int Type = 0;
	protected HScrollBar Horz = null;
	protected VScrollBar Vert = new VScrollBar();
/**
 * shadow of ScrollableCanvas OsCommand ( see Control)
 */
	public ObserverSocket OsCommand = null;
/**
 * triggered externally on demand by drawPane() method
 * parameter: -
 */
	public ObserverSocket OsDrawPane = new ObserverSocket( this);
	final public static int BarWidth = Awt.ScrollBarWidth;
	final public static int SPS_NOHSCROLL = 1;
	final public static int BarDist = 1;
	public static int DefaultBorderStyle = Border.BS_STEP;
	public Graphics DrawGraphics;
	public Rectangle DrawRect;

public ScrollablePane(){
	this( 0);
}

public ScrollablePane( int type) {
	Type = type;

	if ( Type != SPS_NOHSCROLL)
		Horz = new HScrollBar();

	//	FBorder.setBorder( DefaultBorderStyle);
	FBorder.setBorder( Border.BS_NONE);
}

public boolean addHotKey( int c, int mods, HotKeyProcessor p, Object sel){
	return BaseCv.addHotKey( c, mods, p, sel);
}

public boolean addHotKey ( int c, int mods, Object sel ) {
	return BaseCv.addHotKey( c, mods, null, sel);
}

public boolean canGetFocus(){
	return BaseCv.canGetFocus();
}

public int countLines(){
	if ( BaseCv.Lines == null)
		return 0;
	return BaseCv.Lines.size();
}

void drawFocusMark () {
	Graphics g = getGraphics();
	if ( g != null ) {
		drawFocusMark( g);
		g.dispose();
	}
}

protected void drawFocusMark ( Graphics g) {

	int b = Awt.ScrollBarWidth;
	int x = Width - b;
	int y = Height - b;

	if ( BaseCv.hasFocus() )
		GraphicsLib.drawFocusMark( g, x, y);
	else {
		Color c = getBackground();
		if ( c != null) {
			g.setColor( c);
			g.fillRect( x, y, b, b);
		}
	}

}

public void drawPane () {
	synchronized ( BaseCv ) {
		DrawGraphics = BaseCv.ResGraph;
		DrawRect = new Rectangle( BaseCv.XOffset, BaseCv.YOffset,
		                          BaseCv.Width - BaseCv.XOffset - BaseCv.XBorder,
		                          BaseCv.Height - 2*BaseCv.YOffset );
		OsDrawPane.notifyObservers();
		DrawRect = null;
		DrawGraphics = null;
	}
}

public int getLineHeight () {
	return BaseCv.LineHeight;
}

public Menu getMenu(){
	return BaseCv.getMenu();
}

public Point getSBPositions () {
	int x = (Horz != null) ? Horz.getPosition() : 0;
	int y = Vert.getPosition();
	return new Point( x, y); 
}

public boolean hasFocus(){
	return BaseCv.hasFocus();
}

public boolean imageUpdate ( Image img, int infoflags, int x, int y,
                      int width, int height) {

	if ( infoflags == 3) //( width and height)
		Awt.DefToolkit.prepareImage( img, width, height, this);

	boolean ready = ( (infoflags & ImageObserver.ALLBITS) > 0);

	if (ready)
		BaseCv.redraw();

	return !ready;
}

public void paint ( Graphics g ){
	// we don't have a borders or Decorations, so exit right away
}

public void registerObserver(){
	BaseCv.OsFocusLost.addObserver( this);
	BaseCv.OsFocusGot.addObserver( this);
}

public void repaint ( long tm, int x, int y, int width, int height) {
	super.repaint( tm, x, y, width, height);
	if ( Vert != null )   Vert.repaint();
	if ( Horz != null )   Horz.repaint();
	if ( BaseCv != null ) BaseCv.repaint();
}

public void setBorder ( int borderStyle ){
	// we don't have a border of our own, this is just forwarded to the canvas

	BaseCv.setBorder( borderStyle);
}

void setCanvas( ScrollableCanvas cv) {
	BaseCv = cv;

	BaseCv.setBorder( DefaultBorderStyle);

	if ( Horz != null) {
		Lo.add( BaseCv, 0,    0, 1000, 1000, false, 0, 0, -BarWidth-BarDist, -BarWidth-BarDist, 0);
		Lo.add( Vert,   1000, 0, 1000, 1000, false, -BarWidth, 0, 0, -BarWidth, 0);
		Lo.add( Horz,   0,    1000, 1000, 1000, false, 0, -BarWidth, -BarWidth, 0, 0);
	}
	else {
		Lo.add( BaseCv, 0,    0, 1000, 1000, false, 0, 0, -BarWidth-BarDist, -BarDist, 0);
		Lo.add( Vert,   1000, 0, 1000, 1000, false, -BarWidth, 0, 0, 0, 0);
	}

	OsCommand = BaseCv.OsCommand;
	registerObserver();
}

public static void setDefaultBorderStyle ( int style ) {
	DefaultBorderStyle = style;
}

public boolean setFocus(){
	return BaseCv.setFocus();
}

public synchronized void setForeground ( Color c) {
	if ( BaseCv != null)
		BaseCv.setForeground( c);
}

public void setLineHeight( int h){
	BaseCv.LineHeight = h;
}

public void setLineWidth( int w){
	BaseCv.LineWidth = w;
}

public void setMenu ( Menu m) {
	BaseCv.setMenu( m);
}

public void setSBPositions (Point p) {
	if ( Horz != null)
		Horz.setPosition( p.x);
	Vert.setPosition( p.y);
}

public void unregisterObserver(){
	BaseCv.OsFocusLost.deleteObserver( this);
	BaseCv.OsFocusGot.deleteObserver( this);
}

public void update ( Graphics g ) {
	paint( g);
}

public void update( Observable o, Object arg){
	if ( o == BaseCv.OsFocusLost )
		drawFocusMark();
	else if ( o == BaseCv.OsFocusGot )
		drawFocusMark();
}
}
