package biss;


/**
 * class to implement defered processing by means of a queue holding
 * Command objects which are executed in a separate thread
 *
 * (C) 1996,97 BISS GmbH Germany, see file 'LICENSE.BISS-AWT' for details
 * @author J.H.Mehlitz
 */
public class CommandQueue
  implements Runnable
{
	Thread Actor;
	Queue Elements = null;
	int Delay;
	static CommandQueue Instance = null;

public CommandQueue( int d){
	Delay = d;
	Actor = null;
	Instance = this;
	Elements = new Queue(20);
}

public static void append( Command o){
	if ( Instance == null)
		Instance = new CommandQueue( 0);
	Instance.appendCmd( o);
}

public void appendCmd( Command o){
	if ( Actor == null )
		createActor();

	Elements.appendNotify( o);
}

public static boolean appendUnique( Command o){
	if ( Instance == null)
		Instance = new CommandQueue( 0);

	return Instance.appendUniqueCmd( o);
}

public boolean appendUniqueCmd ( Command o){
	boolean ret;

	if ( Actor == null)
		createActor();

	ret = Elements.appendNotifyUnique( o);

	return ret;
}

public void createActor () {
	Actor = new Thread( this);
	Actor.setPriority( Thread.MIN_PRIORITY + 1);
	Actor.setDaemon( true);
	Actor.start();
}

public void run() {
	while( true) {
		try {
			while ( ! Elements.empty() ){
				((Command)Elements.getNext()).execute();

				if ( Delay > 0 )
					Thread.sleep( Delay);
				else
					Thread.yield();
			}
			synchronized ( Elements ) {
				Elements.wait();
			}
		}
		catch ( Exception x ) {
			x.printStackTrace();
		}
	}
}

public static void setDelay( int d){
	if ( Instance == null)
		Instance = new CommandQueue( d);
	else
		Instance.Delay = d;
}
}
