// QWeb - An SGML Web Browser
// Copyright (C) 1997  Sean Vyain
// svyain@mail.tds.net
// smvyain@softart.com
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#include <qlistbox.h>
#include <qmsgbox.h>
#include <qpushbt.h>
#include "CatalogEntry.h"
#include "SgmlCatalog.h"
#include "StyleSelect.h"

StyleSelect::StyleSelect( QWidget* parent, const char* name )
        : QDialog( parent, name, TRUE ),
          _styleSheet( 0 )
{
    setCaption( "QWeb: Select a Style Sheet" );
    setIconText( "QWeb: Select a Style Sheet" );
    
    _list = new QListBox( this );
    connect( _list, SIGNAL( selected( int ) ), this, SLOT( selected( int ) ) );
    
    CatalogEntry* e;
    for ( e = sgmlCatalog->entries().first(); e; e = sgmlCatalog->entries().next() ) {
        if ( e->type() == CatalogEntry::Style ) {
            _list->inSort( sgmlCatalog->entryToString( e ) );
        }
    }

    _okButton = new QPushButton( "OK", this );
    connect( _okButton, SIGNAL( clicked() ), this, SLOT( ok() ) );

    _cancelButton = new QPushButton( "Cancel", this );
    connect( _cancelButton, SIGNAL( clicked() ), this, SLOT( reject() ) );

    resize( 500, 250 );
}

StyleSelect::~StyleSelect()
{
}

void StyleSelect::resizeEvent( QResizeEvent* )
{
    const int pad         = 4;
    const int buttonWidth = 50;
    const int lineHeight  = 24;
    const int listHeight  = height() - 3 * pad - lineHeight;

    _list->setGeometry( pad, pad, width() - 2 * pad, listHeight );

    _okButton->setGeometry( pad, 2 * pad + listHeight, buttonWidth, lineHeight );

    _cancelButton->setGeometry( width() - pad - buttonWidth, 2 * pad + listHeight, buttonWidth, lineHeight );
}

void StyleSelect::styleSheet( StyleSheet* styleSheet )
{
    if ( styleSheet ) {
        _styleSheet = styleSheet;
        accept();
    }
}

void StyleSelect::ok()
{
    int     type;
    QString id, soi;

    if ( _list->currentItem() == -1 ) {
        QMessageBox::message( "QWeb: Error", "You must select a Style Sheet." );
        return;
    }
    
    sgmlCatalog->stringToEntry( _list->text( _list->currentItem() ), type, id, soi );

    styleSheetManager->request( this, id, id );
}

void StyleSelect::selected( int )
{
    ok();
}
