// QWeb - An SGML Web Browser
// Copyright (C) 1997  Sean Vyain
// svyain@mail.tds.net
// smvyain@softart.com
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#include <qpainter.h>
#include "ProgressBar.h"

ProgressBar::ProgressBar( QWidget* parent, const char* name )
        : QFrame( parent, name ),
          _percent( 0 )
{
    setFrameStyle( Panel | Sunken );
}

ProgressBar::~ProgressBar()
{
}

void ProgressBar::setValue( int percent )
{
    _percent = percent;
    paintEvent( 0 );
}

void ProgressBar::paintEvent( QPaintEvent* e )
{
    QPainter p;
    
    p.begin( this );
    p.fillRect( 0, 0, width() * _percent / 100, height(), QColor( "blue" ) );
    p.end();

    QFrame::paintEvent( e );
}
