// QWeb - An SGML Web Browser
// Copyright (C) 1997  Sean Vyain
// svyain@mail.tds.net
// smvyain@softart.com
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#ifndef _PlainRenderer_h_
#define _PlainRenderer_h_

#include <qstring.h>
#include "Renderer.h"
#include "StyleSheetManager.h"

class Dtd;
class PreformatRenderer;

//: The PlainRenderer class displays content of type text/plain.
//. The PlainRenderer is just a wrapper around the PreformatRenderer.  It
//. coverts raw data into strings, and forwards the text to the
//. PreformatRenderer.  It also takes care of loading the style sheet for the
//. plain DTD.
class PlainRenderer : public Renderer,
                      public StyleSheetReceiver
{
    Q_OBJECT
    QString            _leftover;
    PreformatRenderer* _pre;
    bool               _done;
public:
    //. Create a new PlainRenderer.
    PlainRenderer( Canvas*     canvas,
                   int         clipWidth=0,
                   QObject*    parent=0,
                   const char* name=0 );

    ~PlainRenderer();

    //. Given the PreformatRenderer a chance to redraw itself.
    bool redraw();

    void styleSheet( StyleSheet* styleSheet );

    void repaint( QPainter& p, const Rect& r );
public slots:
    //. Forward all data to the PreformatRenderer as text content.
    void data( const char* bytes, int length );

    //. Forward end of data to the PreformatRenderer, and redraw.
    void endOfData();
};

#endif
