program tex2ex;

{ Strip TeX file prepared by M-Tx 0.30 -> PMX 1.3 so the resulting
  file can be imported into LaTeX }

var infile, outfile: text;
    buffer, infilename, outfilename: string;

procedure fatalerror(message: string);
begin  writeln (message);
  begin close(outfile); rewrite(outfile); close(outfile); halt(10);
  end;
end;

procedure OpenFiles;
var i, j, testin: integer;
    basename, param: string;
begin
  if ParamCount<1 then
  begin  writeln('Please type a basename (<9 characters, no dots):');
    readln(basename);
  end
  else basename:=paramstr(1);
  infilename := basename+'.tex';  outfilename := basename+'.ex';
{$I-}
  assign(infile,infilename);  reset(infile);  testin := ioresult;
  assign(outfile,outfilename);  rewrite(outfile);
{$I+}
  if testin<>0 then FatalError('Input file '+infilename+' not found');
  writeln('Writing to ',basename,'.ex');
end;

function match(buffer, start: string): boolean;
  var i: integer;
begin  match := false;  if length(buffer)<length(start) then exit;
  for i:=1 to length(start) do
    if buffer[i]<>start[i] then exit;
  match:=true;
end;

procedure predelete (var s: string; l: integer);
  var i, n: integer;
begin  n:=length(s);
  for i:=1 to n-l do s[i]:=s[i+l];
  for i:=n-l+1 to n do s[i]:=' ';  
end;

procedure Process;
  const nhits = 7;
        ncuts = 1;
        hit: array[1..nhits] of string = ( '\immediate', '\let\:',
           '\nopagenumbers', '\input', '\readmod', '\vfill\eject', 
           '\bye');
        cut: array[1..ncuts] of string = ('\startmuflex');
  var i: integer;
begin
  for i:=1 to ncuts do if match(buffer,cut[i]) 
     then predelete(buffer,length(cut[i]));
  for i:=1 to nhits do
  if match(buffer,hit[i]) then begin buffer:=''; exit; end;
end;

procedure CloseFiles;
begin  close(outfile);  close(infile);
end;

begin
  OpenFiles;
  repeat buffer:=''; readln(infile,buffer); Process;
    if buffer<>'' then writeln(outfile,buffer);
  until eof(infile);
  CloseFiles;
end.

