//
// /home/ms/sidplay/X11/RCS/AudioDriver.h,v
//

#ifndef LINUXAUDIO_H
#define LINUXAUDIO_H

#include <unistd.h>
#include <fcntl.h>
#include <sys/ioctl.h>
#include <linux/soundcard.h>

#include "mytypes.h"
#include "emucfg.h"

class audioDriver
{

 public:  // --------------------------------------------------------- public
	
	const char AUDIODEVICE[] = "/dev/dsp";

    audioDriver();
  
	bool IsThere();

	bool Open(udword freq, int precision, int channels,
			  int fragments, int fragBase);
	
	void Close();
	
	void Play(ubyte* buffer, int bufferSize);

	bool Reset()
	{
		return ioctl(audioHd,SNDCTL_DSP_RESET,0);
	}
	
	int GetAudioHandle()
	{
		return audioHd;
	}
	udword GetFrequency()
    { 
		return frequency;
    }
	int GetSamplePrecision()
    {
		return precision;
    }
	int GetChannels()
    {
		return channels;
    }
	int GetSampleEncoding()
    {
		return encoding;
    }
	int GetBlockSize()
	{
		return blockSize;
	}
	int GetFragments()
    {
		return fragments;
    }
	int GetFragsizebase()
    {
		return fragSizeBase;
    }
	
 private:  // ------------------------------------------------------- private

	int audioHd;

	char* errorString;

	udword frequency;

	// These are constants/enums from ``emucfg.h''.
	int encoding;
	int precision;
	int channels;

	int blockSize;
	int fragments;
	int fragSizeBase;
};


#endif  // LINUXAUDIO_H
