/*
 * kbddef.h - MS-DOS keyboard definitions.
 *
 * Written by
 *  Ettore Perazzoli (ettore@comm2000.it)
 * Based on the X11 code by
 *  Jouko Valta      (jopi@stekt.oulu.fi)
 *  Andre' Fachat    (fachat@physik.tu-chemnitz.de)
 *  Ettore Perazzoli (ettore@comm2000.it)
 *
 * This file is part of VICE, the Versatile Commodore Emulator.
 * See README for copyright notice.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifndef _KBDEF_DOS_H
#define _KBDEF_DOS_H

/* Keymap definition structure. */
typedef struct {
    BYTE row;
    BYTE column;
    int vshift;
} keyconv;

/* On the VIC20, row 0 and 7 and columns 3 and 7 are swapped. */
#ifdef VIC20
#define ROW0	7
#define ROW7	0
#define COL3	7	
#define COL7	3
#else
#define ROW0	0
#define ROW7	7
#define COL3	3	
#define COL7	7
#endif

#if defined(CBM64) || defined(VIC20) || defined(C128)

/* C64/VIC20/C128 keyboard map. */

static keyconv keyconvmap[256] = {
    { -1, -1, 0 },		/*           (no key)           */
    { -1, -1, 0 },		/*          ESC -> (no key)     */
    { ROW7, 0, 0 },		/*            1 -> 1            */
    { ROW7, COL3, 0 },		/*            2 -> 2            */
    { 1, 0, 0 },		/*            3 -> 3            */
    { 1, COL3, 0 },		/*            4 -> 4            */
    { 2, 0, 0 },		/*            5 -> 5            */
    { 2, COL3, 0 },		/*            6 -> 6            */
    { 3, 0, 0 },		/*            7 -> 7            */
    { 3, COL3, 0 },		/*            8 -> 8            */
    { 4, 0, 0 },		/*            9 -> 9            */
    { 4, COL3, 0 },		/*            0 -> 0            */
    { 5, 0, 0 },		/*        Minus -> Plus         */
    { 5, COL3, 0 },		/*        Equal -> Minus        */
    { ROW0, 0, 0 },		/*    Backspace -> Del          */
    { ROW7, 2, 0 },		/*          TAB -> Ctrl         */
    { ROW7, 6, 0 },		/*            Q -> Q            */
    { 1, 1, 0 },		/*            W -> W            */
    { 1, 6, 0 },		/*            E -> E            */
    { 2, 1, 0 },		/*            R -> R            */
    { 2, 6, 0 },		/*            T -> T            */
    { 3, 1, 0 },		/*            Y -> Y            */
    { 3, 6, 0 },		/*            U -> U            */
    { 4, 1, 0 },		/*            I -> I            */
    { 4, 6, 0 },		/*            O -> O            */
    { 5, 1, 0 },		/*            p -> P            */
    { 5, 6, 0 },		/*            [ -> @            */
    { 6, 1, 0 },		/*            ] -> *            */
    { ROW0, 1, 0 },		/*       Return -> Return       */
    { ROW7, 2, 0 },		/*    Left Ctrl -> Ctrl         */
    { 1, 2, 0 },		/*            A -> A            */
    { 1, 5, 0 },		/*            S -> S            */
    { 2, 2, 0 },		/*            D -> D            */
    { 2, 5, 0 },		/*            F -> F            */
    { 3, 2, 0 },		/*            G -> G            */
    { 3, 5, 0 },		/*            H -> H            */
    { 4, 2, 0 },		/*            J -> J            */
    { 4, 5, 0 },		/*            K -> K            */
    { 5, 2, 0 },		/*            L -> L            */
    { 5, 5, 0 },		/*            ; -> :            */
    { 6, 2, 0 },		/*            ' -> ;            */
    { ROW7, 1, 0 },		/*            ` -> Left Arrow   */
    { 1, COL7, 1 },		/*   Left Shift -> Left Shift   */
    { 6, 5, 0 },		/*            \ -> =	        */
    { 1, 4, 0 },		/*            Z -> Z            */
    { 2, COL7, 0 },		/*            X -> X            */
    { 2, 4, 0 },		/*            C -> C            */
    { 3, COL7, 0 },		/*            V -> V            */
    { 3, 4, 0 },		/*            B -> B            */
    { 4, COL7, 0 },		/*            N -> N            */
    { 4, 4, 0 },		/*            M -> M            */
    { 5, COL7, 0 },		/*            , -> ,            */
    { 5, 4, 0 },		/*            . -> .            */
    { 6, COL7, 0 },		/*            / -> /            */
    { 6, 4, 0 },		/*  Right Shift -> Right Shift  */
    { 6, 1, 0 },		/*       Grey * -> *            */
    { ROW7, 5, 0 },		/*     Left Alt -> CBM key      */
    { ROW7, 4, 0 },		/*        Space -> Space        */
    { ROW7, COL7, 0 },		/*    Caps Lock -> Run/Stop     */
    { ROW0, 4, 0 },		/*           F1 -> F1           */
    { ROW0, 4, 1 },		/*           F2 -> F2           */
    { ROW0, 5, 0 },		/*           F3 -> F3           */
    { ROW0, 5, 1 },		/*           F4 -> F4           */
    { ROW0, 6, 0 },		/*           F5 -> F5           */
    { ROW0, 6, 1 },		/*           F6 -> F6           */
    { ROW0, COL3, 0 },		/*           F7 -> F7           */
    { ROW0, COL3, 1 },		/*           F8 -> F8           */
    { -1, -1, 0 },		/*           F9 -> (no key)     */
    { -1, -1, 0 },		/*          F10 -> (no key)	*/
    { -1, -1, 0 },		/*     Num Lock -> (no key)	*/
    { -1, -1, 0 },		/*  Scroll Lock -> (no key)	*/
    { -1, -1, 0 },		/*     Numpad 7 -> (no key) 	*/
    { -1, -1, 0 },		/*     Numpad 8 -> (no key)	*/
    { -1, -1, 0 },		/*     Numpad 9 -> (no key)	*/
    { -1, -1, 0 },		/*     Numpad - -> (no key)	*/
    { -1, -1, 0 },		/*     Numpad 4 -> (no key) 	*/
    { -1, -1, 0 },		/*     Numpad 5 -> (no key) 	*/
    { -1, -1, 0 },		/*     Numpad 6 -> (no key) 	*/
    { -1, -1, 0 },		/*     Numpad + -> (no key)	*/
    { -1, -1, 0 },		/*     Numpad 1 -> (no key) 	*/
    { -1, -1, 0 },		/*     Numpad 2 -> (no key) 	*/
    { -1, -1, 0 },		/*     Numpad 3 -> (no key) 	*/
    { -1, -1, 0 },		/*     Numpad 0 -> (no key) 	*/
    { -1, -1, 0 },		/*     Numpad . -> (no key) 	*/
    { -1, -1, 0 },		/*       SysReq -> (no key) 	*/
    { -1, -1, 0 },		/*           85 -> (no key) 	*/
    { -1, -1, 0 },		/*           86 -> (no key) 	*/
    { -1, -1, 0 },		/*          F11 -> (no key) 	*/
    { -1, -1, 0 },		/*          F12 -> (no key) 	*/
    { 6, COL3, 0 },		/*         Home -> CLR/HOME 	*/
    { ROW0, COL7, 1 },		/*           Up -> CRSR UP 	*/
    { -1, -1, 0 },		/*         PgUp -> (no key) 	*/
    { ROW0, 2, 1 },		/*         Left -> CRSR LEFT 	*/
    { ROW0, 2, 0 },		/*        Right -> CRSR RIGHT 	*/
    { -1, -1, 0 },		/*          End -> (no key) 	*/
    { ROW0, COL7, 0 },		/*         Down -> CRSR DOWN 	*/
    { -1, -1, 0 },		/*       PgDown -> (no key) 	*/
    { 6, 0, 0 },		/*          Ins -> Pound 	*/
    { 6, 6, 0 },		/*          Del -> Up Arrow 	*/
    { -1, -1, 0 },		/* Numpad Enter -> (no key) 	*/
    { -1, -1, 0 },		/*   Right Ctrl -> (no key) 	*/
    { -1, -1, 0 },		/*        Pause -> (no key) 	*/
    { -1, -1, 0 },		/*       PrtScr -> (no key) 	*/
    { -1, -1, 0 },		/*     Numpad / -> (no key) 	*/
    { -1, -1, 0 },		/*    Right Alt -> (no key) 	*/
    { -1, -1, 0 },		/*        Break -> (no key) 	*/
    { -1, -1, 0 },		/*   Left Win95 -> (no key) 	*/
    { -1, -1, 0 },		/*  Right Win95 -> (no key) 	*/
};

#endif /* CBM64 || VIC20 */

/* -------------------------------------------------------------------------- */

/* FIXME: these keyboards are not complete. */

#ifdef PET

/* PET 3032/4032 keyboard map.  */
static keyconv keyconvmap40[256] = {
    { -1, -1, 0 },		/*           (no key)           */
    { -1, -1, 0 },		/*          ESC -> (no key)     */
    { 0, 0, 0 },		/*            1 -> !            */
    { 1, 0, 0 },		/*            2 -> "            */
    { 0, 1, 0 },		/*            3 -> #            */
    { 1, 1, 0 },		/*            4 -> $            */
    { 0, 2, 0 },		/*            5 -> %            */
    { 1, 2, 0 },		/*            6 -> '            */
    { 0, 3, 0 },		/*            7 -> &            */
    { 1, 3, 0 },		/*            8 -> \            */
    { 0, 4, 0 },		/*            9 -> (            */
    { 1, 4, 0 },		/*            0 -> )            */
    { 0, 5, 0 },		/*        Minus -> Left arrow   */
    { -1, -1, 0 },		/*        Equal -> (no key)     */
    { 1, 7, 0 },		/*    Backspace -> Del          */
    { -1, -1, 0 },		/*          TAB -> (no key)     */
    { 2, 0, 0 },		/*            Q -> Q            */
    { 3, 0, 0 },		/*            W -> W            */
    { 2, 1, 0 },		/*            E -> E            */
    { 3, 1, 0 },		/*            R -> R            */
    { 2, 2, 0 },		/*            T -> T            */
    { 3, 2, 0 },		/*            Y -> Y            */
    { 2, 3, 0 },		/*            U -> U            */
    { 3, 3, 0 },		/*            I -> I            */
    { 2, 4, 0 },		/*            O -> O            */
    { 3, 4, 0 },		/*            P -> P            */
    { 2, 5, 0 },		/*            [ -> Up arrow     */
    { -1, -1, 0 },		/*            ] -> (no key)     */
    { 6, 5, 0 },		/*       Return -> Return       */
    { 9, 0, 0 },		/*    Left Ctrl -> RVS ON/OFF   */
    { 4, 0, 0 },		/*            A -> A            */
    { 5, 0, 0 },		/*            S -> S            */
    { 4, 1, 0 },		/*            D -> D            */
    { 5, 1, 0 },		/*            F -> F            */
    { 4, 2, 0 },		/*            G -> G            */
    { 5, 2, 0 },		/*            H -> H            */
    { 4, 3, 0 },		/*            J -> J            */
    { 5, 3, 0 },		/*            K -> K            */
    { 4, 4, 0 },		/*            L -> L            */
    { 5, 4, 0 },		/*            ; -> :            */
    { -1, -1, 0 },		/*            ' -> (no key)     */
    { -1, -1, 0 },		/*	      ` -> (no key)     */
    { 8, 0, 1 },		/*   Left Shift -> Left Shift   */
    { -1, -1, 0 },		/*            \ -> (no key)     */
    { 6, 0, 0 },		/*            Z -> Z            */
    { 7, 0, 0 },		/*            X -> X            */
    { 6, 1, 0 },		/*            C -> C            */
    { 7, 1, 0 },		/*            V -> V            */
    { 6, 2, 0 },		/*            B -> B            */
    { 7, 2, 0 },		/*            N -> N            */
    { 6, 3, 0 },		/*            M -> M            */
    { 7, 3, 0 },		/*            , -> ,            */
    { 6, 4, 0 },		/*            . -> ;            */
    { 7, 4, 0 },		/*            / -> ?            */
    { 8, 5, 0 },		/*  Right Shift -> Right Shift  */
    { 5, 7, 0 },		/*       Grey * -> *            */
    { -1, -1, 0 },		/*     Left Alt -> (no key)     */
    { 9, 2, 0 },		/*        Space -> Space        */
    { 9, 4, 0 },		/*    Caps Lock -> RUN/STOP	*/
    { -1, -1, 0 },		/*           F1 -> (no key)     */
    { -1, -1, 0 },		/*           F2 -> (no key)     */
    { -1, -1, 0 },		/*           F3 -> (no key)     */
    { -1, -1, 0 },		/*           F4 -> (no key)     */
    { -1, -1, 0 },		/*           F5 -> (no key)     */
    { -1, -1, 0 },		/*           F6 -> (no key)     */
    { -1, -1, 0 },		/*           F7 -> (no key)     */
    { -1, -1, 0 },		/*           F8 -> (no key)     */
    { -1, -1, 0 },		/*           F9 -> (no key)     */
    { -1, -1, 0 },		/*          F10 -> (no key)	*/
    { 0, 6, 0 },		/*     Num Lock -> CLR/HOME	*/
    { -1, -1, 0 },		/*  Scroll Lock -> (no key)	*/
    { 2, 6, 0 },		/*     Numpad 7 -> 7	 	*/
    { 3, 6, 0 },		/*     Numpad 8 -> 8		*/
    { 2, 7, 0 },		/*     Numpad 9 -> 9		*/
    { 8, 7, 0 },		/*     Numpad - -> -		*/
    { 4, 6, 0 },		/*     Numpad 4 -> 4		*/
    { 5, 6, 0 },		/*     Numpad 5 -> 5		*/
    { 4, 7, 0 },		/*     Numpad 6 -> 6	 	*/
    { 7, 7, 0 },		/*     Numpad + -> +		*/
    { 6, 6, 0 },		/*     Numpad 1 -> 1		*/
    { 7, 6, 0 },		/*     Numpad 2 -> 2	 	*/
    { 6, 7, 0 },		/*     Numpad 3 -> 3		*/
    { 8, 6, 0 },		/*     Numpad 0 -> 0		*/
    { 9, 6, 0 },		/*     Numpad . -> .		*/
    { -1, -1, 0 },		/*       SysReq -> (no key) 	*/
    { -1, -1, 0 },		/*           85 -> (no key) 	*/
    { -1, -1, 0 },		/*           86 -> (no key) 	*/
    { -1, -1, 0 },		/*          F11 -> (no key) 	*/
    { -1, -1, 0 },		/*          F12 -> (no key) 	*/
    { 9, 1, 0 },		/*         Home -> [	 	*/
    { 1, 6, 1 },		/*           Up -> CRSR UP      */
    { 8, 2, 0 },		/*         PgUp -> ]	 	*/
    { 0, 7, 1 },		/*         Left -> CRSR LEFT	*/
    { 0, 7, 0 },		/*        Right -> CRSR RIGHT 	*/
    { 9, 3, 0 },		/*          End -> <	 	*/
    { 1, 6, 0 },		/*         Down -> CRSR DOWN 	*/
    { 8, 4, 0 },		/*       PgDown -> >	 	*/
    { 8, 1, 0 },		/*          Ins -> @	 	*/
    { -1, -1, 0 },		/*          Del -> (no key) 	*/
    { 9, 7, 0 },		/* Numpad Enter -> =	 	*/
    { 9, 4, 0 },		/*   Right Ctrl -> RUN/STOP 	*/
    { -1, -1, 0 },		/*        Pause -> (no key) 	*/
    { -1, -1, 0 },		/*       PrtScr -> (no key) 	*/
    { 3, 7, 0 },		/*     Numpad / -> (no key) 	*/
    { -1, -1, 0 },		/*    Right Alt -> (no key) 	*/
    { -1, -1, 0 },		/*        Break -> (no key) 	*/
    { -1, -1, 0 },		/*   Left Win95 -> (no key) 	*/
    { -1, -1, 0 },		/*  Right Win95 -> (no key) 	*/
};

/* PET 8032 keyboard map. */
static keyconv keyconvmap80[256] = {
    { -1, -1, 0 },		/*           (no key)           */
    { -1, -1, 0 },		/*          ESC -> (no key)     */
    { 1, 0, 0 },		/*            1 -> 1            */
    { 0, 0, 0 },		/*            2 -> 2            */
    { 9, 1, 0 },		/*            3 -> 3            */
    { 1, 1, 0 },		/*            4 -> 4            */
    { 0, 1, 0 },		/*            5 -> 5            */
    { 9, 2, 0 },		/*            6 -> 6            */
    { 1, 2, 0 },		/*            7 -> 7            */
    { 0, 2, 0 },		/*            8 -> 8            */
    { 9, 3, 0 },		/*            9 -> 9            */
    { 1, 3, 0 },		/*            0 -> 0            */
    { 9, 5, 0 },		/*            - -> :            */
    { 0, 3, 0 },		/*            = -> -            */
    { 4, 7, 0 },		/*    Backspace -> Del          */
    { 4, 0, 0 },		/*          Tab -> Tab		*/
    { 5, 0, 0 },		/*            Q -> Q            */
    { 4, 1, 0 },		/*            W -> W            */
    { 5, 1, 0 },		/*            E -> E            */
    { 4, 2, 0 },		/*            R -> R            */
    { 5, 2, 0 },		/*            T -> T            */
    { 4, 3, 0 },		/*            Y -> Y            */
    { 5, 3, 0 },		/*            U -> U            */
    { 4, 5, 0 },		/*            I -> I            */
    { 5, 5, 0 },		/*            O -> O            */
    { 4, 6, 0 },		/*            p -> P            */
    { 5, 6, 0 },		/*            [ -> [            */
    { 2, 4, 0 },		/*            ] -> ]		*/
    { 3, 4, 0 },		/*       Return -> Return       */
    { 8, 0, 0 },		/*    Left Ctrl -> RVS	        */
    { 3, 0, 0 },		/*            A -> A            */
    { 2, 1, 0 },		/*            S -> S            */
    { 3, 1, 0 },		/*            D -> D            */
    { 2, 2, 0 },		/*            F -> F            */
    { 3, 2, 0 },		/*            G -> G            */
    { 2, 3, 0 },		/*            H -> H            */
    { 3, 3, 0 },		/*            J -> J            */
    { 2, 5, 0 },		/*            K -> K            */
    { 3, 5, 0 },		/*            L -> L            */
    { 2, 6, 0 },		/*            ; -> ;            */
    { 3, 6, 0 },		/*            ' -> @            */
    { 9, 0, 0 },		/*            ` -> Left Arrow	*/
    { 6, 0, 1 },		/*   Left Shift -> Left Shift   */
    { 4, 4, 0 },		/*            \ -> \	        */
    { 7, 0, 0 },		/*            Z -> Z            */
    { 8, 1, 0 },		/*            X -> X            */
    { 6, 1, 0 },		/*            C -> C            */
    { 7, 1, 0 },		/*            V -> V            */
    { 6, 2, 0 },		/*            B -> B            */
    { 7, 2, 0 },		/*            N -> N            */
    { 8, 3, 0 },		/*            M -> M            */
    { 7, 3, 0 },		/*            , -> ,            */
    { 6, 3, 0 },		/*            . -> .            */
    { 8, 6, 0 },		/*            / -> /            */
    { 6, 6, 0 },		/*  Right Shift -> Right Shift  */
    { -1, -1, 0 },		/*       Grey * -> (no key)     */
    { -1, -1, 0 },		/*     Left Alt -> (no key)     */
    { 8, 2, 0 },		/*        Space -> Space        */
    { 2, 0, 0 },		/*    Caps Lock -> ESC	        */
    { -1, -1, 0 },		/*           F1 -> (no key)     */
    { -1, -1, 0 },		/*           F2 -> (no key)     */
    { -1, -1, 0 },		/*           F3 -> (no key)     */
    { -1, -1, 0 },		/*           F4 -> (no key)     */
    { -1, -1, 0 },		/*           F5 -> (no key)     */
    { -1, -1, 0 },		/*           F6 -> (no key)     */
    { -1, -1, 0 },		/*           F7 -> (no key)     */
    { -1, -1, 0 },		/*           F8 -> (no key)     */
    { -1, -1, 0 },		/*           F9 -> (no key)     */
    { -1, -1, 0 },		/*          F10 -> (no key)	*/
    { -1, -1, 0 },		/*     Num Lock -> (no key)	*/
    { -1, -1, 0 },		/*  Scroll Lock -> (no key)	*/
    { 1, 4, 0 },		/*     Numpad 7 -> Numpad 7 	*/
    { 0, 4, 0 },		/*     Numpad 8 -> Numpad 8	*/
    { 1, 7, 0 },		/*     Numpad 9 -> Numpad 9	*/
    { -1, -1, 0 },		/*     Numpad - -> (no key)	*/
    { 5, 7, 0 },		/*     Numpad 4 -> Numpad 4 	*/
    { 2, 7, 0 },		/*     Numpad 5 -> Numpad 5 	*/
    { 3, 7, 0 },		/*     Numpad 6 -> Numpad 6 	*/
    { -1, -1, 0 },		/*     Numpad + -> (no key)	*/
    { 8, 7, 0 },		/*     Numpad 1 -> Numpad 1 	*/
    { 7, 7, 0 },		/*     Numpad 2 -> Numpad 2 	*/
    { 6, 7, 0 },		/*     Numpad 3 -> Numpad 3 	*/
    { 7, 4, 0 },		/*     Numpad 0 -> Numpad 0 	*/
    { 6, 4, 0 },		/*     Numpad . -> .	 	*/
    { -1, -1, 0 },		/*       SysReq -> (no key) 	*/
    { -1, -1, 0 },		/*           85 -> (no key) 	*/
    { -1, -1, 0 },		/*           86 -> (no key) 	*/
    { -1, -1, 0 },		/*          F11 -> (no key) 	*/
    { -1, -1, 0 },		/*          F12 -> (no key) 	*/
    { 8, 4, 0 },		/*         Home -> CLR/HOME 	*/
    { 5, 4, 1 },		/*           Up -> CRSR UP  	*/
    { -1, -1, 0 },		/*         PgUp -> (no key) 	*/
    { 0, 5, 1 }, 		/*         Left -> CRSR LEFT	*/
    { 0, 5, 0 }, 		/*        Right -> CRSR RIGHT	*/
    { -1, -1, 0 },		/*          End -> (no key) 	*/
    { 5, 4, 0 },		/*         Down -> CRSR DOWN	*/
    { -1, -1, 0 },		/*       PgDown -> (no key) 	*/
    { 9, 4, 0 },		/*          Ins -> STOP 	*/
    { 1, 5, 0 },		/*          Del -> Up arrow 	*/
    { -1, -1, 0 },		/* Numpad Enter -> (no key) 	*/
    { 7, 6, 0 },		/*   Right Ctrl -> RPT	 	*/
    { -1, -1, 0 },		/*        Pause -> (no key) 	*/
    { -1, -1, 0 },		/*       PrtScr -> (no key) 	*/
    { -1, -1, 0 },		/*     Numpad / -> (no key) 	*/
    { -1, -1, 0 },		/*    Right Alt -> (no key) 	*/
    { -1, -1, 0 },		/*        Break -> (no key) 	*/
    { -1, -1, 0 },		/*   Left Win95 -> (no key) 	*/
    { -1, -1, 0 }		/*  Right Win95 -> (no key) 	*/
};

#endif

#endif
