/* 
   PXKScreen.m

   NSScreen for GNUstep GUI X/DPS Backend

   Copyright (C) 1996 Free Software Foundation, Inc.

   Author:  Scott Christley <scottc@net-community.com>
   Date: March 1996
   
   This file is part of the GNUstep GUI X/DPS Backend.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; see the file COPYING.LIB.
   If not, write to the Free Software Foundation,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/ 

#include <stdlib.h>

#include <gnustep/xdps/PXKScreen.h>
#include <gnustep/xdps/PXKDPSContext.h>

//
// Backend structure for PXKScreen
//
typedef struct _PXKScreen_struct
{
  int screen;
} PXKScreen_struct;

#define PXKSCREEN (((PXKScreen_struct *)be_screen_reserved)->screen)

//
// Class variables
//
NSScreen *gnustep_xdps_main_screen = nil;

@implementation PXKScreen

+ (NSScreen *)mainScreen
{
  if (!gnustep_xdps_main_screen)
    gnustep_xdps_main_screen = [[NSScreen alloc] init];
  return gnustep_xdps_main_screen;
}

- init
{
  [super init];

  // Allocate backend structure
  be_screen_reserved = malloc(sizeof(PXKScreen_struct));

  return self;
}

- (void)dealloc
{
  // Free backend structure
  free(be_screen_reserved);

  [super dealloc];
}

- (NSRect)frame
{
  NSDPSContext *cur = [NSDPSContext currentContext];
  Display *xdis = [(PXKDPSContext *)cur xDisplay];
  NSRect r;

  r.origin = NSZeroPoint;
  r.size.width = (float)DisplayWidth(xdis, PXKSCREEN);
  r.size.height = (float)DisplayHeight(xdis, PXKSCREEN);

  return r;
}

@end

@implementation PXKScreen (GNUstepXDPS)

- (int)xScreen
{
  return PXKSCREEN;
}

- (void)setXScreen:(int)xscreen
{
  PXKSCREEN = xscreen;
}

@end
