/****************************************************************************/
/*                                                                          */
/* IMG* Image Processing Tools Library                                      */
/* Program:   imgTee.c                                                      */
/* Author:    Simon A.J. Winder                                             */
/* Date:      Thu Oct 20 20:46:00 1994                                      */
/* Copyright (C) 1994 Simon A.J. Winder                                     */
/*                                                                          */
/****************************************************************************/

#include "tools.h"

#define PRGNAME "Tee"
#define ERROR(e) imgError(e,PRGNAME)

int main(int argc,char **argv)
{
  it_image *image;
  int seq_start,seq_incr,seq_count;
  int count,select_start,select_incr;

  IFHELP
    {
      fprintf(stderr,"img%s - Tee selected images from stream to seq files\n",
	      PRGNAME);
      fprintf(stderr,"img%s [start [incr [count [select_start [select_incr]]]]]\n",PRGNAME);
      fprintf(stderr,"  stdin: Any\n");
      fprintf(stderr,"  stdout: Any\n");
      fprintf(stderr,"  files: Any\n");
      exit(0);
    }

  imgStart(PRGNAME);

  seq_start= -1;
  seq_incr=1;
  seq_count=999;
  select_start=0;
  select_incr=2;

  if(argc<2 || argc>7)
    ERROR("illegal arguments");
  if(argc>2)
    seq_start=atoi(argv[2]);
  if(argc>3)
    seq_incr=atoi(argv[3]);
  if(argc>4)
    seq_count=atoi(argv[4]);
  if(argc>5)
    select_start=atoi(argv[5]);
  if(argc>6)
    select_incr=atoi(argv[6]);
  
  if(seq_start<0)
    seq_count=1;
  
  count=0;
  do {
    if((image=i_read_image_file(stdin,IT_ANY,IM_FRAGMENT))==NULL)
      ERROR("can't import image file");
    i_write_image_file(stdout,image,IF_BINARY);
    if(count==select_start && seq_count>0)
      {
	if(i_save_image(argv[1],seq_start,image,IF_BINARY))
	  ERROR("can't write image file");
	seq_start+=seq_incr;
	select_start+=select_incr;
	seq_count--;
      }
    i_destroy_image(image);
    count++;
  } while(!feof(stdin));

  imgFinish(PRGNAME);
  return(0);
}
/* Version 1.0 (Oct 1994) */
/* Version 1.1 (Nov 1994) */
