/*
    cthugha-saver
	
    Linux-X11 Screen Saver Version of Cthugha

    The screen-saver interface is based on the beforelight screensaver.
	
-----------------------------------------------------------------------------*/

/*
 * Some notes from beforelight:
 */

/*
 * $XConsortium: b4light.c,v 1.3 94/04/17 20:59:38 rws Exp $
 * $XFree86: xc/programs/beforelight/b4light.c,v 3.2 1994/08/01 13:21:00 dawes Exp $
 *
Copyright (c) 1992  X Consortium

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

Except as contained in this notice, the name of the X Consortium shall not be
used in advertising or otherwise to promote the sale, use or other dealings
in this Software without prior written authorization from the X Consortium.
 *
 * Author:  Keith Packard, MIT X Consortium
 */

/****************************************************************************/

#include <X11/Xatom.h> 
#include <X11/Intrinsic.h>
#include <X11/Xaw/Cardinals.h>
#include <X11/extensions/scrnsaver.h>

#include <unistd.h>
#include <stdlib.h>
#include <time.h>
#include <stdio.h>
#include <signal.h>

#include "cthugha.h"
#include "information.h"			/* title, credits, ... */
#include "sound.h"
#include "net_sound.h"
#include "action.h"				/* display_sound() */
#include "translate.h"
#include "options.h"
#include "keys.h"
#include "cd_player.h"
#include "display.h"

Display * cth_display;
Window cth_window, cth_window_pal;
Visual * cth_visual;
int cth_screen;
GC cth_gc;
int rev_byte_order;
int cth_planes;
Colormap cth_cmap;

static void quit ();

int key_esc;

static int  ss_event, ss_error;

static Window  root;
static GC  black_gc;
static int  screen_saved;
static XtAppContext app_con;
static GC   bit_1_gc, bit_0_gc;
static unsigned long	black_pixel;

/* functions referenced, but not used */
void update_status() {}
int server=0;
int broadcast_sound() { return 0; }
int server_accept() { return 0; }


static void Timeout (XtPointer closure, XtIntervalId * id) {
    if (screen_saved) {
	display_sound();		/* do cthugha - displaying */
	XtAppAddTimeOut (app_con, 0, Timeout, NULL);
    }
}

void StartSaver () {
    if (screen_saved)			/* check if running */
	return;

    init_graph_mode();			/* some extra initialization stuff */
    alloc_sound();			/* get sound only when needd */
    screen_saved = True;
    XInstallColormap(cth_display, cth_cmap);  
    XtAppAddTimeOut (app_con, 0, Timeout, NULL);
}

void StopSaver () {
    if (!screen_saved)
	return;
    screen_saved = False;
    exit_graph_mode();
    free_sound();		/* release sound when no longer needed */
    XInstallColormap(cth_display, DefaultColormap(cth_display,cth_screen));
}

int ignoreError(Display * d, XErrorEvent * e) {
    return 0;
}

int main(int argc, char *argv[]) {
    Widget toplevel;
    XEvent  event;
    XScreenSaverNotifyEvent *sevent;
    XSetWindowAttributes    attr;
    XScreenSaverInfo	    *info;
    unsigned long	    mask;
    Pixmap		    blank_pix;
    XColor		    dummyColor;
    XID			    kill_id;
    Atom		    kill_type;

    /* initialize screen saver */
    toplevel = XtAppInitialize (&app_con, "Cthugha-saver", NULL, ZERO,
				&argc, argv, NULL, NULL, ZERO);

    cth_display   = XtDisplay(toplevel);
    root	  = DefaultRootWindow(cth_display);
    cth_screen    = DefaultScreen(cth_display);
    cth_visual    = DefaultVisual(cth_display, cth_screen);
    cth_planes    = DefaultDepth(cth_display, cth_screen);
    window_width  = DisplayWidth(cth_display, cth_screen);
    window_height = DisplayHeight(cth_display, cth_screen);

    if (!XScreenSaverQueryExtension (cth_display, &ss_event, &ss_error))
	exit (1);
    
    XScreenSaverUnregister(cth_display, cth_screen);
    if (XScreenSaverGetRegistered(cth_display, cth_screen, 
				  &kill_id, &kill_type))
	XKillClient (cth_display, kill_id);
    
    XScreenSaverSelectInput (cth_display, root, ScreenSaverNotifyMask);

    blank_pix = XCreatePixmap (cth_display, root, 1, 1, 1);
    XScreenSaverRegister (cth_display, cth_screen, (XID) blank_pix, XA_PIXMAP);
    
    bit_0_gc = XCreateGC(cth_display, blank_pix, 0, 0);
    XSetForeground (cth_display, bit_0_gc, 0);
    
    bit_1_gc = XCreateGC(cth_display, blank_pix, 0, 0);
    XSetForeground (cth_display, bit_1_gc, ~0);
    
    XFillRectangle(cth_display, blank_pix, bit_0_gc, 0, 0, 1, 1);
    
    info = XScreenSaverAllocInfo ();
    XScreenSaverQueryInfo (cth_display, root, info);
    
    mask = 0;
    attr.background_pixel = black_pixel;
    mask |= CWBackPixel;
    attr.cursor = XCreatePixmapCursor (cth_display, blank_pix, blank_pix, 
				       &dummyColor, &dummyColor, 0, 0);
    mask |= CWCursor;
    XScreenSaverSetAttributes (cth_display, root, 0, 0,
			       DisplayWidth (cth_display, cth_screen), 
			       DisplayHeight(cth_display, cth_screen), 0,
			       CopyFromParent, CopyFromParent, 
			       CopyFromParent, mask, &attr);

    XSync (cth_display, False);

    cth_gc = XCreateGC (cth_display, root, 0, 0);
    black_gc = XCreateGC (cth_display, root, 0, 0);
    XSetForeground (cth_display, black_gc, black_pixel);

    XSetErrorHandler (ignoreError);
    cth_window = cth_window_pal = info->window;

    /* initialize cthugha */
    if( init_cthugha(argc, argv) ) {
	XScreenSaverUnregister(cth_display, cth_screen);
	return 1;
    }
    free_sound();		/* release sound again, get only when needed */

    signal(SIGINT, quit);
    signal(SIGQUIT, quit);
    signal(SIGHUP, quit);
    signal(SIGKILL, quit);
    signal(SIGTERM, quit);

    printf("Ready.\n");

    if (info->state == ScreenSaverOn)
    {
	if (info->kind != ScreenSaverExternal) 
	{
	    XResetScreenSaver (cth_display);
	    XActivateScreenSaver (cth_display);
	}
	StartSaver ();
    }

    for (;;) 
    {
	XtAppNextEvent (app_con, &event);
	if (event.type == ss_event) {
	    sevent = (XScreenSaverNotifyEvent *) &event;
	    if (sevent->state == ScreenSaverOn) {
		if (sevent->kind != ScreenSaverExternal) {
	    	    XResetScreenSaver (cth_display);
	    	    XActivateScreenSaver (cth_display);
		} else {
		    StartSaver ();
		}
	    } else if (sevent->state == ScreenSaverOff) {
	        StopSaver ();
	    }
	} else {
	    XtDispatchEvent(&event);
	}
    }
    return 0;
}

void quit () {
    printfe("Exiting cthugha-saver...\n");
    exit_cthugha(0);
    exit (0);
}



