#include "cthugha.h"
#include "action.h"
#include "sound.h"
#include "display.h"
#include "translate.h"
#include "options.h"
#include "information.h"
#include "cd_player.h"
#include "net_sound.h"

#include <string.h>
#include <stdlib.h>


void (*flame)(void);				/* Pointer to active flame */

char flame_first[256] = "";			/* Start witth this flame */
int action_lock=0;				/* change automatically */
int change_little=0;				/* only change one options */

char silence_strings[MAX_SILENCE_STRINGS][256] = {/* Display when no sound */
/*   1234567890123456789012345678901234567890	*/
    "          Where is the music?           ",	/* 0 */
    "                 JOLT !                 ",	/* 1 */	
    "           Turn The Music On            ",	/* 2 */	
    "             Lets Party!!!              ",	/* 3 */	
    "            Pink Floyd Rules            ",	/* 4 */	
    "           Sounds of Silence ?          ",	/* 5 */	
    "               The Torps                ",	/* 6 */	
    "              Play Descent              ",	/* 7 */	
    "               Drink COKE               ",	/* 8 */	
    "           Press ? for help             ",	/* 9 */	
    "          Number 5 is ALIVE!!           ",	/* 10 */	
    "          Spooky Mulder.....            ",	/* 11 */	
    "          Wheres Cthugha 6.0?           ",	/* 12 */	
    "             Subliminal Ads             ",	/* 13 */	
    "              Read a book               ",	/* 14 */	
    "             Get a life...              ",	/* 15 */	
    "                SMILE!                  ",	/* 16 */	
    "              Cthugha-L                 ",	/* 17 */	
    "             Don't Panic!               ",	/* 18 */	
    "@fortune                                "  /* 19 */
};
int nr_silence_strings = 20;

int init_action() {

    init_action_tables();

    return 0;
}

int exit_action() {
    return 0;
}

/*
 * select a new flame-function
 */
int change_flame(int to) {
    flame = opt_change( to, flames, nr_flames, flame)->data;
    return 0;
}
/*
 * change the table for a general flame function
 */
int change_flame_general() {
    int i;

    for(i=0; i < 5; i++)
	flame_general[i] = rand() % 9;

    return 0;
}
    

/* 
 * select what flame-fkts are used 
 */
int select_flame() {
    int i;
	
    i = display_selection( flames, nr_flames, flame, "Select Flames\n");
    if ( i >= 0)
	change_flame(i);
    return 0;
}

int change_lock(int to) {
    action_lock = val_change( to, 0, 1, action_lock);
    return 0;
}

/*
 * change everything 
 */
int general_change() {
    if(change_little) {
	switch(rand() % 9) {
	case 0:
	    change_flame(CHANGE_RANDOM);
	    change_flame_general();
	    break;
	case 1:
	    change_display_wave(CHANGE_RANDOM);
	    break;
	case 2:
	    change_update_screen(CHANGE_RANDOM);
	    break;
	case 3:
	    change_palette(CHANGE_RANDOM,0);
	    break;
	case 4:
	    change_table(CHANGE_RANDOM);
	    break;
	case 5:
	    change_translate(CHANGE_RANDOM);
	    break;
	case 6:
	    change_massage_style(CHANGE_RANDOM);
	    break;
	case 7:
	    change_FFT(CHANGE_RANDOM);
	    break;
	case 8:	    
	    change_pcx(CHANGE_RANDOM);
	    return 1;
	    break;
	}
    } else {
	change_flame(CHANGE_RANDOM);
	change_flame_general();
	change_display_wave(CHANGE_RANDOM);
	change_update_screen(CHANGE_RANDOM);
	change_palette(CHANGE_RANDOM,0);
	change_table(CHANGE_RANDOM);
	change_translate(CHANGE_RANDOM);
	change_massage_style(CHANGE_RANDOM);
	change_FFT(CHANGE_RANDOM);
	change_pcx(CHANGE_RANDOM);
    }
    
    return 0;
}

/*
 * The Main-display-Funktion
 */
int display_sound() {
    int change;

    /* accept requests from clients */
    if(server)
	server_accept();

    /* set border to black */
    memset(active_buffer+BUFF_SIZE,   0, 3*BUFF_WIDTH);
    memset(active_buffer-3*BUFF_WIDTH,0, 3*BUFF_WIDTH);

    done_translation = 0;
    
    flame();				/* flame (primary transformation) */
    translate();			/* secondard transformation */
    change = get_sound();		/* Get the next sound into memory */
    if(server)				/* send to clients */
	broadcast_sound();
    massage_audio();			/* audio-processing 1 */
    FFT();				/* audio-processing 2 */
    display_wave();			/* Bring the sound to buffer */
	
    if ( (change == 1) && !action_lock) {	/* time to change and not locked*/
	if ( general_change() ||		/* new wave, flame, ... */
	    ((display_use_pcx) && (pcx_count -- <= 0)) ) {
	    show_pcx(rand() % 2, rand() % 3);
	    pcx_count = rand() % 5;
	}
	update_status();
    }

    if ( (change == -1) && !display_text[0]) {		/* silence */
	int print_nr = rand() % nr_silence_strings;

	if ( silence_strings[ print_nr][0] != '@' ) {
	    /* traditional string */
	    display_print( silence_strings[ print_nr ], -1, 1); 
	} else {
	    /* print fortune */
	    FILE * msgPipe;

	    if ( (msgPipe = popen("fortune","r")) == NULL) {
		display_print( "Can not open fortune pipe", -1, 1);
	    } else {
		char str[MAX_TEXT_DISPLAY];
		str[ fread( str, 1, MAX_TEXT_DISPLAY-1, msgPipe) ] = '\0';
		display_print(str,-1,1);
		pclose(msgPipe);
	    }
	}
    }

    display();				/* bring the active_buffer to screen */
    smooth_setpalette();		/* smooth pal. to next */
    cd_check();				/* check for complete rotation of CD */
    return 0;
}










