/**********************************************************************
** Simple widget that demonstrates the use of QPixmap and QPainter
** to display an image stored in a file.
** The paintEvent() is smart and only updates the part of the widget
** that needs to be redrawn.
** resizeEvent() scales the image so it always fits the widget size.
**********************************************************************/

#ifndef SHOWIMG_H
#define SHOWIMG_H

#include <qwidget.h>
#include <qimage.h>


class QLabel;
class QMenuBar;
class QPopupMenu;

class ImageViewer : public QWidget
{
    Q_OBJECT
public:
    ImageViewer( QWidget *parent=0, const char *name=0 );
    bool	loadImage( const char *fileName );
protected:
    void	paintEvent( QPaintEvent * );
    void	resizeEvent( QResizeEvent * );
    void	mouseMoveEvent( QMouseEvent * );

private:
    void	scale();
    int		conversion_flags;
    const char* filename;
    QImage	image;			// the loaded image
    QPixmap	pm;			// the converted pixmap
    QPixmap	pmScaled;		// the scaled pixmap
    QMenuBar   *menubar;
    QPopupMenu *file;
    QPopupMenu *options;
    QPopupMenu *saveimage;
    QPopupMenu *savepixmap;
    QWidget    *helpmsg;
    QLabel     *status;
    int         si, sp, ac, co, mo, fd, bd, // Menu item ids
		td, ta, ba, fa, au, ad, dd;
    void	updateStatus();
    void	setMenuItemFlags();
    bool 	reconvertImage();
    int		pickx, picky;

private slots:
    void	openFile();
    void	saveImage(int);
    void	savePixmap(int);
    void	giveHelp();
    void	doOption(int);
};


#endif // SHOWIMG_H
