/* FreeBSD code added 7/17/97 By Eric A. Griff  aka setjmp */
#ifndef __cdrom_h_
#define __cdrom_h_

#ifndef __FreeBSD__
#	include <mntent.h>
#else
#	include <sys/param.h>
#	include <sys/ucred.h>
#	include <sys/mount.h>
#	include <sys/file.h>
#	include <sys/cdio.h>
#endif /* __FreeBSD__ */

#include <sys/ioctl.h>
#include <signal.h>
#include <fcntl.h>

#ifndef __FreeBSD__
#include <linux/cdrom.h>
#include <linux/errno.h>
#endif /* __FreeBSD__ */

extern void	set_cd_device _((Window *, char *, int));
extern void cd_stop _((char *, char *, char *));
extern void cd_eject _((char *, char *, char *));
extern void cd_play _((char *, char *, char *));
extern void cd_list _((char *, char *, char *));
extern void cd_volume _((char *, char *, char *));
extern void cd_pause _((char *, char *, char *));
extern void cd_help _((char *, char *, char *));

#ifndef __FreeBSD__
struct cdrom_etocentry 
{
	u_char	cdte_track;
	u_char	cdte_adr	:4;
	u_char	cdte_ctrl	:4;
	u_char	cdte_format;
	union cdrom_addr cdte_addr;
	u_char	cdte_datamode;
	int avoid;
	int length;
};
#else
struct cdrom_etocentry
{
	u_char m_length;
	u_char m_start;
	int avoid;
};
	
#define CDROMSTOP CDIOCSTOP
#define CDROMEJECT CDIOCEJECT
#define CDROMREADTOCHDR CDIOREADTOCHEADER
#define CDROMVOLCTRL CDIOCSETVOL
#define CDROMPAUSE CDIOCPAUSE
#define CDROMRESUME CDIOCRESUME
#endif /* __FreeBSD__ */

#endif /* __undef_h_ */
