# This script will generate the Resources interface for Python.
# It uses the "bgen" package to generate C code.
# It execs the file resgen.py which contain the function definitions
# (resgen.py was generated by resscan.py, scanning the <Resources.h> header file).

from macsupport import *


class ResMixIn:

	def checkit(self):
		OutLbrace()
		Output("OSErr _err = ResError();")
		Output("if (_err != noErr) return PyMac_Error(_err);")
		OutRbrace()
		FunctionGenerator.checkit(self) # XXX

class ResFunction(ResMixIn, FunctionGenerator): pass
class ResMethod(ResMixIn, MethodGenerator): pass

# includestuff etc. are imported from macsupport

includestuff = includestuff + """
#include <Resources.h>

#define resNotFound -192 /* Can't include <Errors.h> because of Python's "errors.h" */
"""

finalstuff = finalstuff + """
"""

initstuff = initstuff + """
"""

module = MacModule('Res', 'Res', includestuff, finalstuff, initstuff)

getattrHookCode = """
if (strcmp(name, "size") == 0)
	return PyInt_FromLong(GetHandleSize(self->ob_itself));
if (strcmp(name, "data") == 0) {
	PyObject *res;
	char state;
	state = HGetState(self->ob_itself);
	HLock(self->ob_itself);
	res = PyString_FromStringAndSize(
		*self->ob_itself,
		GetHandleSize(self->ob_itself));
	HUnlock(self->ob_itself);
	HSetState(self->ob_itself, state);
	return res;
}
if (strcmp(name, "__members__") == 0)
	return Py_BuildValue("[ss]", "data", "size");
"""

class ResDefiniton(GlobalObjectDefinition):

	def outputCheckNewArg(self):
		Output("if (itself == NULL) return PyMac_Error(resNotFound);")

	def outputGetattrHook(self):
		Output(getattrHookCode)


resobject = ResDefiniton('Resource', 'ResObj', 'Handle')
module.addobject(resobject)

functions = []
resmethods = []

execfile('resgen.py')
execfile('resedit.py')

for f in functions: module.add(f)
for f in resmethods: resobject.add(f)

SetOutputFileName('Resmodule.c')
module.generate()
