<?xml version="1.0" encoding="ISO-8859-1"?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" lang="fr" xml:lang="fr"><head><!--
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
              This file is generated from xml source: DO NOT EDIT
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
      -->
<title>Limites des descripteurs de fichiers - Serveur Apache HTTP</title>
<link href="../style/css/manual.css" rel="stylesheet" media="all" type="text/css" title="Main stylesheet" />
<link href="../style/css/manual-loose-100pc.css" rel="alternate stylesheet" media="all" type="text/css" title="No Sidebar - Default font size" />
<link href="../style/css/manual-print.css" rel="stylesheet" media="print" type="text/css" />
<link href="../images/favicon.ico" rel="shortcut icon" /></head>
<body id="manual-page" class="no-sidebar"><div id="page-header">
<p class="menu"><a href="../mod/">Modules</a> | <a href="../mod/directives.html">Directives</a> | <a href="../faq/">FAQ</a> | <a href="../glossary.html">Glossaire</a> | <a href="../sitemap.html">Plan du site</a></p>
<p class="apache">Serveur Apache HTTP Version 2.2</p>
<img alt="" src="../images/feather.gif" /></div>
<div class="up"><a href="./"><img title="&lt;-" alt="&lt;-" src="../images/left.gif" /></a></div>
<div id="path">
<a href="http://www.apache.org/">Apache</a> &gt; <a href="http://httpd.apache.org/">Serveur HTTP</a> &gt; <a href="http://httpd.apache.org/docs/">Documentation</a> &gt; <a href="../">Version 2.2</a> &gt; <a href="./">Serveurs Virtuels</a></div><div id="page-content"><div id="preamble"><h1>Limites des descripteurs de fichiers</h1>
<div class="toplang">
<p><span>Langues Disponibles: </span><a href="../en/vhosts/fd-limits.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="../fr/vhosts/fd-limits.html" title="Franais">&nbsp;fr&nbsp;</a> |
<a href="../ja/vhosts/fd-limits.html" hreflang="ja" rel="alternate" title="Japanese">&nbsp;ja&nbsp;</a> |
<a href="../ko/vhosts/fd-limits.html" hreflang="ko" rel="alternate" title="Korean">&nbsp;ko&nbsp;</a></p>
</div>


    <p>Quand de nombreux serveurs virtuels sont crs, Apache peut 
    dpasser les limites en descripteurs de fichiers ('file descriptors', 
    galement appels <cite>gestionnaires de fichiers</cite>) si chacun 
    des serveurs virtuels utilise ses propres fichiers journaux. Le 
    nombre total de descripteurs de fichiers utiliss par Apache est 
    d'un par fichier journal, un pour chacune des autres directives 
    de fichiers journaux, plus un nombre constant compris entre 10 et 20 
    pour son fonctionnement interne. Les systmes d'exploitation Unix 
    limitent le nombre de descripteurs de fichiers utilisables par 
    processus&nbsp;; une valeur courante pour cette limite est de 64, et 
    cette valeur peut le plus souvent tre augmente.</p>

    <p>Apache tente d'accrotre cette valeur limite si ncessaire, mais 
    sans y parvenir dans les cas suivants&nbsp;:</p>

    <ol>
      <li>Le systme d'exploitation ne permet pas l'utilisation d'appels 
      systmes <code>setrlimit()</code>.</li>

      <li>L'appel <code>setrlimit(RLIMIT_NOFILE)</code> ne fonctionne pas 
      sur votre systme d'exploitation (c'est le cas sous Solaris 2.3).</li>

      <li>Le nombre de descripteurs de fichiers ncessaires  Apache 
      dpasse la limite physique du matriel.</li>
      
      <li>Le systme impose d'autres limites sur l'utilisation des 
      descripteurs de fichiers, comme par exemple une limite sur les 
      flux stdio, utilisables uniquement sur les descripteurs de 
      fichiers infrieurs  256. (sous Solaris 2).</li>
    </ol>

	<p>En cas de problme, Vous pouvez&nbsp;:</p>

    <ul>
      <li>Rduire le nombre de fichiers journaux, en ne spcifiant 
      aucun fichier journal dans les sections 
      <code class="directive"><a href="../mod/core.html#virtualhost">&lt;VirtualHost&gt;</a></code>, 
      en donc en envoyant les informations aux fichiers journaux du 
      serveur principal (Voir <a href="#splitlogs">clatement des 
      fichiers journaux</a> ci-dessous pour plus d'informations sur 
      cette possibilit).</li>

      <li>
        Dans les cas 1 ou 2 (voqus ci-dessus), augmentez la limite sur 
        les descripteurs de fichiers avant le dmarrage d'Apache, au 
        moyen d'un script comme

        <div class="example"><p><code>
          <code>#!/bin/sh<br />
           ulimit -S -n 100<br />
           exec httpd</code>
        </code></p></div>
      </li>
    </ul>
    


</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="splitlogs" id="splitlogs">clatement des fichiers journaux</a></h2>

<p>Lorsque vous choisissez d'enregistrer les informations manant de 
plusieurs serveurs virtuels dans un mme fichier journal, vous voudrez 
ensuite pouvoir scinder ces informations  des fins de statistiques, par 
exemple, sur les diffrents serveurs virtuels. Il est possible de procder 
de la manire suivante&nbsp;:</p>

<p>Tout d'abord, vous devez ajouter le nom du serveur virtuel  chaque 
entre du journal. Ceci se paramtre au moyen de la directive 
<code class="directive"><a href="../mod/mod_log_config.html# logformat"> LogFormat</a></code> et de la 
variable <code>%v</code>. Ajoutez cette variable au dbut de la chane 
de dfinition du format de journalisations&nbsp;:</p>

<div class="example"><p><code>
LogFormat "%v %h %l %u %t \"%r\" %&gt;s %b" vhost<br />
CustomLog logs/multiple_vhost_log vhost
</code></p></div>

<p>Cette configuration va provoquer la cration d'un fichier de 
journalisation au format standard (CLF&nbsp;: 'Common Log Format'), mais dont 
chaque ligne dbutera par le nom canonique du serveur virtuel (spcifi 
par la directive <code class="directive"><a href="../mod/core.html#servername">ServerName</a></code>). 
(Voir <code class="directive"><a href="../mod/mod_log_config.html#formats de journalisation &#10;personnaliss">Formats de journalisation 
personnaliss</a></code> pour d'autres informations sur la 
personnalisation des fichiers journaux.)</p>

<p>Au moment de sparer les informations du fichier journal en un fichier 
par serveur virtuel, le programme <code>
<a href="../programs/other.html">split-logfile</a></code> peut tre 
utilis. Ce programme peut tre trouv dans le rpertoire 
<code>support</code> de la distribution d'Apache.</p>

<p>Excutez ce programme au moyen de la commande&nbsp;:</p>

<div class="example"><p><code>
split-logfile &lt; /logs/multiple_vhost_log
</code></p></div>

<p>Une fois excut avec le nom du fichier contenant tous les journaux, 
ce programme va gnrer un fichier pour chacun des serveurs virtuels 
qui apparat dans le fichier d'entre. Chaque fichier en sortie est 
nomm <code>nomduserveur.log</code>.</p>

</div></div>
<div class="bottomlang">
<p><span>Langues Disponibles: </span><a href="../en/vhosts/fd-limits.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="../fr/vhosts/fd-limits.html" title="Franais">&nbsp;fr&nbsp;</a> |
<a href="../ja/vhosts/fd-limits.html" hreflang="ja" rel="alternate" title="Japanese">&nbsp;ja&nbsp;</a> |
<a href="../ko/vhosts/fd-limits.html" hreflang="ko" rel="alternate" title="Korean">&nbsp;ko&nbsp;</a></p>
</div><div id="footer">
<p class="apache">Copyright 2006 The Apache Software Foundation.<br />Authoris sous <a href="http://www.apache.org/licenses/LICENSE-2.0">Apache License, Version 2.0</a>.</p>
<p class="menu"><a href="../mod/">Modules</a> | <a href="../mod/directives.html">Directives</a> | <a href="../faq/">FAQ</a> | <a href="../glossary.html">Glossaire</a> | <a href="../sitemap.html">Plan du site</a></p></div>
</body></html>